/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.Redundancy;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.commons.util.Version;

class GroupOpOutputParser
extends KFODOpOutputParser {
    private static final Logger logger = Logger.getLogger(GroupOpOutputParser.class.getName());
    List<DiskGroup> diskGroups = new ArrayList<DiskGroup>();

    @Override
    public void parseLine(String line) {
        DiskGroup diskGroup = this.parseDiskGroup(line);
        if (diskGroup != null && !this.diskGroups.contains(diskGroup)) {
            this.diskGroups.add(diskGroup);
        }
    }

    public List<DiskGroup> getDiskGroups() {
        return this.diskGroups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DiskGroup parseDiskGroup(String line) {
        DiskGroup diskGroup = null;
        String[] tokens = Helper.tokenize(line);
        if (tokens.length < 4) return diskGroup;
        try {
            Redundancy redundancy;
            long freeSpace;
            long size;
            block8: {
                String strRedundancy;
                block9: {
                    block11: {
                        block10: {
                            size = Long.parseLong(tokens[0]);
                            freeSpace = Long.parseLong(tokens[1]);
                            redundancy = null;
                            strRedundancy = tokens[2];
                            if (strRedundancy == null || strRedundancy.trim().length() <= 0) break block9;
                            if (!strRedundancy.equalsIgnoreCase("EXTEND")) break block10;
                            redundancy = Redundancy.EXTENDED;
                            break block8;
                        }
                        if (!strRedundancy.equalsIgnoreCase("FLEX")) break block11;
                        redundancy = Redundancy.FLEX;
                        break block8;
                    }
                    if (strRedundancy.equalsIgnoreCase("HIGH")) {
                        redundancy = Redundancy.HIGH;
                        break block8;
                    } else if (strRedundancy.equalsIgnoreCase("NORMAL")) {
                        redundancy = Redundancy.NORMAL;
                        break block8;
                    } else {
                        if (!strRedundancy.equalsIgnoreCase("EXTERN")) {
                            logger.log(Level.WARNING, "No match for Redundancy value '" + strRedundancy + "'in " + Redundancy.class.getName());
                            throw new IllegalArgumentException(strRedundancy);
                        }
                        redundancy = Redundancy.EXTERNAL;
                    }
                    break block8;
                }
                logger.log(Level.WARNING, "Redundancy value is null or it is of zero length");
                throw new IllegalArgumentException(strRedundancy);
            }
            String path = tokens[3];
            if (tokens.length <= 5) return new DiskGroup(path, redundancy, size, freeSpace, null);
            Version asmCompatibility = Version.parseVersion((String)tokens[4]);
            return new DiskGroup(path, redundancy, size, freeSpace, asmCompatibility);
        }
        catch (NumberFormatException numberFormatException) {
            return diskGroup;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return diskGroup;
    }
}

