/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.driver.DiagsetupToolJob;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.PlatformInfo;

public class ClientDiagsetupToolJob
extends DiagsetupToolJob {
    private final String diagSetupClientsDirectory = File.separator + "diag" + File.separator + "clients";
    private static final Logger logger = Logger.getLogger(ClientDiagsetupToolJob.class.getName());

    public ClientDiagsetupToolJob(String oracleHome, String oracleBase, String localNode, List<String> clusterNodes) {
        super(oracleHome, oracleBase, localNode, clusterNodes);
    }

    @Override
    public Void call() throws Exception {
        this.setDiagSetupToolJob();
        return null;
    }

    @Override
    public void retry() throws Exception {
        this.setDiagSetupToolJob();
    }

    private void setDiagSetupToolJob() throws Exception {
        String OHBinDir = new File(this.oracleHome, "bin").getAbsolutePath();
        File diagSetupDirectory = null;
        String diagSetupBinary = "";
        diagSetupBinary = PlatformInfo.getInstance().isWindows() ? OHBinDir + File.separator + "diagsetup.bat" : OHBinDir + File.separator + "diagsetup";
        diagSetupDirectory = new File(diagSetupBinary);
        if (diagSetupDirectory.exists()) {
            super.call();
        } else {
            boolean ADRCreated;
            logger.info("ADR setup (diagsetup) tool was not found");
            File ADRClientDirectory = new File(this.oracleBase + this.diagSetupClientsDirectory);
            boolean bl = ADRCreated = ADRClientDirectory.exists() || ADRClientDirectory.mkdirs();
            if (ADRCreated) {
                if (!PlatformInfo.getInstance().isWindows()) {
                    Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxrwxr-x");
                    Files.setPosixFilePermissions(ADRClientDirectory.toPath(), permissions);
                    Files.setPosixFilePermissions(ADRClientDirectory.getAbsoluteFile().getParentFile().toPath(), permissions);
                }
                logger.info("Diagsetup client directory was created successfully: " + ADRClientDirectory.getPath());
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.message = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_DIAGSETUP_CLIENT_DIRECTORY_FAILED, new Object[]{ADRClientDirectory.getPath()});
                ExceptionManager.advise((ErrorMessage)this.message);
                this.setStatus(Status.FAILED);
            }
        }
    }
}

