/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.install.commons.base.logging.BasicLogHandler;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.ivw.common.bean.InstallerPatchBean;
import oracle.install.ivw.common.driver.job.InstallerPatchJob;
import oracle.install.ivw.common.validator.InstallerPatchValidator;
import oracle.install.library.util.InventoryInfo;

public class InstallerPatchDriver {
    private List<String> arguments;
    InstallerPatchBean installerPatchBean = new InstallerPatchBean();
    private String logDirectoryPrefix;
    private static String logFile;

    private InstallerPatchDriver(String[] args) {
        this.logDirectoryPrefix = args[0];
        this.installerPatchBean.setOracleHome(args[1]);
        this.arguments = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            this.arguments.add(args[i]);
        }
    }

    private void parseArgs() {
        if (this.arguments != null && !this.arguments.isEmpty()) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i).equalsIgnoreCase("-applyRU") || this.arguments.get(i).equalsIgnoreCase("-applyPSU") || this.arguments.get(i).equalsIgnoreCase("-applyRUR")) {
                    this.installerPatchBean.setApplyingPSU(true);
                    if (this.arguments.size() >= i + 2 && !this.arguments.get(i + 1).startsWith("-")) {
                        this.installerPatchBean.setPsuPath(this.arguments.get(++i));
                    }
                    if (this.installerPatchBean.getApplyPSUFirst() != null) continue;
                    this.installerPatchBean.setApplyPSUFirst(true);
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-applyOneOffs")) {
                    this.installerPatchBean.setApplyingOneOffs(true);
                    if (this.arguments.size() >= i + 2 && !this.arguments.get(i + 1).startsWith("-")) {
                        this.installerPatchBean.setOneOffsPaths(this.arguments.get(++i).split(","));
                    }
                    if (this.installerPatchBean.getApplyPSUFirst() != null) continue;
                    this.installerPatchBean.setApplyPSUFirst(false);
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-applyInstallerUpdates")) {
                    this.installerPatchBean.setApplyingInstallerUpdates(true);
                    if (this.arguments.size() < i + 2 || this.arguments.get(i + 1).startsWith("-")) continue;
                    this.installerPatchBean.setInstallerUpdatesPaths(this.arguments.get(++i).split(","));
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-opatchLocation")) {
                    this.installerPatchBean.setUpdatingOpatch(true);
                    if (this.arguments.size() < i + 2 || this.arguments.get(i + 1).startsWith("-")) continue;
                    this.installerPatchBean.setOpatchLoc(this.arguments.get(++i));
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-skipOpatchVersionCheck")) {
                    this.installerPatchBean.setSkipOpatchVersionCheck(true);
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-timestamp")) {
                    if (this.arguments.size() < i + 2 || this.arguments.get(i + 1).startsWith("-")) continue;
                    this.installerPatchBean.setTimestamp(this.arguments.get(++i));
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-tempLocation")) {
                    if (this.arguments.size() < i + 2 || this.arguments.get(i + 1).startsWith("-")) continue;
                    this.installerPatchBean.setTempLocation(this.arguments.get(++i));
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-debug")) {
                    this.installerPatchBean.setDebug(true);
                    continue;
                }
                if (this.arguments.get(i).equalsIgnoreCase("-status")) {
                    this.installerPatchBean.setCheckStatus(true);
                    continue;
                }
                if (!this.arguments.get(i).equalsIgnoreCase("-revert")) continue;
                this.installerPatchBean.setRevert(true);
            }
        }
    }

    private void init() {
        String timestamp = this.installerPatchBean.getTimestamp();
        String logFileName = "installerPatchActions_" + timestamp + ".log";
        String logLoc = null;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        if (invInfo.isInventoryExist()) {
            boolean isNonWindowsAndUserNonMemberOfInvGroup = false;
            if (!PlatformInfo.getInstance().isWindows()) {
                String invGroup = invInfo.getUnixGroupName();
                if (!Arrays.asList(invInfo.getOSGroups()).contains(invGroup)) {
                    isNonWindowsAndUserNonMemberOfInvGroup = true;
                }
            }
            if (!isNonWindowsAndUserNonMemberOfInvGroup) {
                logLoc = invInfo.getDefaultInventoryLoc() + File.separator + "logs" + File.separator + this.logDirectoryPrefix + timestamp;
                try {
                    File logLocFile = new File(logLoc);
                    if (!logLocFile.exists()) {
                        logLocFile.mkdirs();
                    }
                }
                catch (Exception e) {
                    logLoc = null;
                }
            }
        }
        if (logLoc == null) {
            logLoc = this.installerPatchBean.getTempLocation();
        }
        logFile = logLoc + File.separator + logFileName;
        BasicLogHandler blh = null;
        try {
            blh = new BasicLogHandler(logFile, (Formatter)new SimpleFormatter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (blh != null) {
            Logger.getLogger("").addHandler((Handler)blh);
        }
    }

    private void validate() {
        InstallerPatchValidator installerPatchValidator = new InstallerPatchValidator(this.installerPatchBean);
        try {
            installerPatchValidator.validate();
        }
        catch (ValidationException e) {
            String errorMessage = e.getMessage();
            Logger.getLogger(InstallerPatchDriver.class.getName()).log(Level.SEVERE, errorMessage);
            System.out.println(errorMessage);
            System.exit(Application.CommonExitStatus.FAILURE.getIntValue());
        }
    }

    private void run() {
        InstallerPatchJob installerPatchJob = new InstallerPatchJob(this.installerPatchBean);
        installerPatchJob.call();
    }

    public static void main(String[] args) {
        Handler[] handlers;
        Logger globalLogger = Logger.getLogger("");
        for (Handler handler : handlers = globalLogger.getHandlers()) {
            globalLogger.removeHandler(handler);
        }
        InstallerPatchDriver installerPatchDriver = new InstallerPatchDriver(args);
        installerPatchDriver.parseArgs();
        installerPatchDriver.init();
        installerPatchDriver.validate();
        installerPatchDriver.run();
        System.exit(Application.CommonExitStatus.SUCCESS.getIntValue());
    }

    public static String getLogFile() {
        return logFile;
    }

    public static void setLogFile(String logFile) {
        InstallerPatchDriver.logFile = logFile;
    }
}

