/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.driver.oui.OUICloneDriver;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SetupJob;
import oracle.install.ivw.common.driver.DiagsetupToolJob;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.WinHelper;

public class OracleCloneDriver
extends OUICloneDriver {
    private static Logger logger = Logger.getLogger(OracleCloneDriver.class.getName());

    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        super.constructAdditionalProperties(hashMap);
        List args = Application.getInstance().getArguments();
        Iterator virtualIter = args.iterator();
        CommandLineArgumentHandler cliArgumentHandler = CommandLineArgumentHandler.getInstance();
        boolean isVirtualAccount = false;
        String oracleHome = hashMap.get("ORACLE_HOME").toString();
        String oracleHomeName = hashMap.get("ORACLE_HOME_NAME").toString();
        if (PlatformInfo.getInstance().isWindows()) {
            if (cliArgumentHandler.isArgumentPassed("virtualAccount")) {
                isVirtualAccount = true;
            }
            if (isVirtualAccount && oracleHomeName != null) {
                String oracle_home_userName = WinHelper.getVirtualHomeUserName(oracleHome, oracleHomeName);
                hashMap.put("oracle_install_OracleHomeUserName", oracle_home_userName);
                hashMap.put("oracle_install_IsOracleServiceUserExists", true);
                hashMap.put("oracle_install_IsBuiltInAccount", false);
                hashMap.put("oracle_install_OracleSVCUserPWDReq", false);
            }
        }
        return hashMap;
    }

    public void showUsage() {
        super.showUsage();
    }

    public CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob compositeJob = new CompositeJob();
        SetupJob cloneJob = new SetupJob((Object)"Clone", "Oracle Cloning", 0.95f, this.getCloneDetails(), SetupJob.OUISetupMode.CLONE);
        compositeJob.add((Job)cloneJob);
        DiagsetupToolJob diagSetupToolJob = new DiagsetupToolJob(this.getOracleHome(), this.getOracleBase(), null, null);
        compositeJob.add((Job)diagSetupToolJob);
        if (!PlatformInfo.getInstance().isWindows() && !Application.isCommandLineSwitchEnabled((String)"-suppressRootMessage")) {
            logger.log(Level.INFO, "Adding root script.");
            compositeJob.add((Job)new RootScriptJob(cloneJob));
        }
        return compositeJob;
    }

    public void unload(boolean isSetupWizard) throws SetupDriverException {
        if (isSetupWizard) {
            File oracleHome = new File(System.getProperty("ORACLE_HOME"));
            this.removeOuibakFiles(oracleHome);
        }
        super.unload();
    }

    private void removeOuibakFiles(File file) {
        try {
            List<String> ouibakFiles = FileInfo.getAllFilesRecursiveByExt(file, "ouibak");
            if (ouibakFiles != null && !ouibakFiles.isEmpty()) {
                for (String str : ouibakFiles) {
                    File ouibakFile = new File(str);
                    if (PlatformInfo.getInstance().isWindows()) {
                        ouibakFile.deleteOnExit();
                        continue;
                    }
                    ouibakFile.delete();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

