/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.library.util.PlatformInfo;

public class RoohHelper {
    private static RoohHelper instance;
    private String oraBaseHome;
    private static final Logger logger;

    private RoohHelper() {
    }

    public static RoohHelper getInstance() {
        if (instance == null) {
            instance = new RoohHelper();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOraBaseHomeLocation(String oracleHome) {
        String oraBaseHomeBinary;
        File oraBaseHomeBinaryFile;
        this.oraBaseHome = oracleHome;
        String oraBaseHomeUtil = "orabasehome";
        if (PlatformInfo.getInstance().isWindows()) {
            oraBaseHomeUtil = oraBaseHomeUtil + ".exe";
        }
        if ((oraBaseHomeBinaryFile = new File(oraBaseHomeBinary = oracleHome + File.separator + "bin" + File.separator + oraBaseHomeUtil)) != null && oraBaseHomeBinaryFile.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.environment().put("ORACLE_HOME", oracleHome);
            processBuilder.command().add(oraBaseHomeBinary);
            AbstractLineProcessor lineProcessor = new AbstractLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    RoohHelper.this.oraBaseHome = line.trim();
                }
            };
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, null);
            try {
                ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (Exception e) {
                logger.severe("GetClusterName Exception:" + e.getMessage());
            }
            finally {
                processBuilder.command().clear();
            }
        } else {
            logger.info(oraBaseHomeBinary + " utility does not exist");
        }
        logger.info("orabasehome returned : " + this.oraBaseHome);
        return this.oraBaseHome;
    }

    public boolean isReadOnlyOracleHome(String oracleHome) {
        boolean readOnlyOH = false;
        String oraBaseHome = null;
        if (oracleHome != null && oracleHome.trim().length() > 0) {
            oraBaseHome = RoohHelper.getInstance().getOraBaseHomeLocation(oracleHome);
        }
        if (oraBaseHome != null && oraBaseHome.trim().length() > 0 && new File(oracleHome).compareTo(new File(oraBaseHome)) != 0) {
            readOnlyOH = true;
        }
        return readOnlyOH;
    }

    static {
        logger = Logger.getLogger(RoohHelper.class.getName());
    }
}

