/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.DiskGroup;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.CompatibilityMatrix;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PathInfo;
import oracle.install.library.util.PlatformInfo;

public abstract class BaseInstallLocationValidator
implements CompositeValidator {
    private Map<ErrorCode, Severity> errorCodeSeverityMap = new HashMap<ErrorCode, Severity>();
    private ErrorCode errorCode;
    private StatusMessages<ValidationStatusMessage> errorMessages = new StatusMessages();
    public static final String NONE = "NONE";
    private static boolean skipWhiteSpaceCheck = false;
    private static final boolean isSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");
    private static Logger logger = Logger.getLogger(BaseInstallLocationValidator.class.getName());

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.errorMessages;
    }

    public void validate(FlowContext flowContext) throws ValidationException {
        Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("BaseInstallLocationValidator.statusControl.text", "Validating specified location...", new Object[0]));
        this.validate(flowContext, NONE, true);
        Application.hideStatus();
    }

    public void validate(FlowContext flowContext, String installType, boolean validateOracleBase) throws ValidationException {
        this.errorMessages.clear();
        InstallSettings bean = this.getInstallSettings(flowContext);
        String oracleBase = bean.getOracleBase();
        String oracleHome = bean.getOracleHome();
        this.errorMessages.addAll(BaseInstallLocationValidator.validateOracleHomeCompatiblity(oracleHome, installType));
        if (oracleBase.contains("#") || oracleBase.contains("$")) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_BASE_AND_HOME_INVALID_CHARS_ERR, new Object[]{"Oracle base"}));
        }
        if (oracleHome.contains("#") || oracleHome.contains("$")) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_BASE_AND_HOME_INVALID_CHARS_ERR, new Object[]{"Oracle home"}));
        }
        if (validateOracleBase && installType != "InstantClient") {
            this.errorMessages.addAll(BaseInstallLocationValidator.validateOracleBase(oracleBase));
        }
        this.errorMessages.addAll(BaseInstallLocationValidator.validateOracleHomeLocation(oracleHome));
        if (validateOracleBase && installType != "InstantClient") {
            boolean isHomeExpectedUnderBase = this.isHomeExpectedUnderBase(flowContext);
            this.errorMessages.addAll(this.validateOFACompliance(oracleBase, oracleHome, isHomeExpectedUnderBase));
        }
        this.doesHomeNameConflict(oracleHome);
        File shiphomePropFile = new File(OUIMetadata.METADATA_FILE_LOC);
        if (!(!PlatformInfo.getInstance().isWindows() || shiphomePropFile.exists() && OUIMetadata.is32BitShiphome((String)shiphomePropFile.getAbsolutePath()))) {
            this.checkWindowsOracleInventory();
        }
    }

    public abstract InstallSettings getInstallSettings(FlowContext var1);

    public boolean isHomeExpectedUnderBase(FlowContext flowContext) {
        return true;
    }

    public static boolean isSkipWhiteSpacesCheck() {
        return skipWhiteSpaceCheck;
    }

    public void setSkipWhiteSpacesCheck(boolean whiteSpace) {
        skipWhiteSpaceCheck = whiteSpace;
    }

    public static StatusMessages<ValidationStatusMessage> validateOracleBase(String oracleBase) {
        String locRoot;
        int ind;
        StatusMessages messages = new StatusMessages();
        String oraBaseText = BaseInstallLocationValidator.getCommonLabel("INSTALL_COMMON_ORACLE_BASE_LABEL2");
        try {
            BaseInstallLocationValidator.validateLocation(oracleBase, oraBaseText);
            BaseInstallLocationValidator.validateOHSpaceChar(oracleBase, oraBaseText);
        }
        catch (ValidationException e) {
            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
            return messages;
        }
        String userHome = PathInfo.getInstance().getNativeCanonicalPath(System.getProperty("user.home"));
        String nativeBaseLoc = PathInfo.getInstance().getNativeCanonicalPath(oracleBase);
        if (FileInfo.getInstance().areLocsSame(userHome, nativeBaseLoc)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_USER_HOME_AS_ORACLE_BASE_LOCATION_WRN, new Object[]{oracleBase}));
        }
        if (OFAWrapper.getInstance().isHomeWithLocationExist(oracleBase)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_AS_ORACLE_BASE_LOCATION_ERR, new Object[]{oracleBase}));
        }
        if (PlatformInfo.getInstance().isWindows() && (ind = oracleBase.indexOf(":")) != -1 && oracleBase.length() > ind + 1 && oracleBase.equalsIgnoreCase(locRoot = oracleBase.substring(0, ind + 2))) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_LOCATION_ON_WIN_DRIVE, new Object[]{oraBaseText, oracleBase}));
        }
        logger.info("Check if the oracle base is parent of existing inventory.");
        File oracleBaseFile = new File(oracleBase);
        if (oracleBaseFile.exists()) {
            InventoryInfo invInfo = InventoryInfo.getInstance();
            if (invInfo.isInventoryExist()) {
                String invLoc = invInfo.getDefaultInventoryLoc();
                if (invLoc != null && !invLoc.isEmpty()) {
                    File invLocFile = new File(invLoc);
                    if (invLocFile.exists()) {
                        FileInfo fileInfo = FileInfo.getInstance();
                        boolean oraBaseParentOfInv = false;
                        for (File invParentFile = invLocFile.getParentFile(); invParentFile != null; invParentFile = invParentFile.getParentFile()) {
                            if (!fileInfo.areLocsSame(oracleBase, invParentFile.getPath())) continue;
                            oraBaseParentOfInv = true;
                            break;
                        }
                        if (oraBaseParentOfInv) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_BASE_PARENT_OF_EXISTING_INVENTORY, new Object[]{invLoc}));
                        }
                        logger.info("Is oracle base " + oracleBase + " parent of the existing inventory " + invLoc + ": " + String.valueOf(oraBaseParentOfInv));
                    } else {
                        logger.warning("The inventory location does not exist: " + invLoc);
                    }
                } else {
                    logger.warning("The inventory location is null or empty.");
                }
            } else {
                logger.info("There is no inventory in the machine.");
            }
        } else {
            logger.info("The oracle base location does not exist: " + oracleBase);
        }
        return messages;
    }

    public static StatusMessages<ValidationStatusMessage> validateOracleHomeLocation(String homeLoc) {
        String locRoot;
        int ind;
        StatusMessages messages = new StatusMessages();
        String oraLocText = BaseInstallLocationValidator.getCommonLabel("INSTALL_COMMON_ORACLE_HOME_LOCATION_LABEL");
        try {
            BaseInstallLocationValidator.validateLocation(homeLoc, oraLocText);
            BaseInstallLocationValidator.validateOHSpaceChar(homeLoc, oraLocText);
        }
        catch (ValidationException e) {
            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
            return messages;
        }
        if (PlatformInfo.getInstance().isWindows() && (ind = homeLoc.indexOf(":")) != -1 && homeLoc.length() > ind + 1 && homeLoc.equalsIgnoreCase(locRoot = homeLoc.substring(0, ind + 2))) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_LOCATION_ON_WIN_DRIVE, new Object[]{oraLocText, homeLoc}));
        }
        if (!isSetupWizard) {
            try {
                BaseInstallLocationValidator.validateForEmptyLocation(homeLoc);
            }
            catch (ValidationException e) {
                messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
            }
        }
        String envValue = System.getenv("ORACLE_HOME");
        if (PlatformInfo.getInstance().isWindows() && envValue != null && envValue.trim().length() > 0 && !envValue.equalsIgnoreCase(homeLoc)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_ENV_SET_ERR, new Object[0]));
        }
        return messages;
    }

    public static StatusMessages<ValidationStatusMessage> validateOracleHomeCompatiblity(String homeLoc) {
        return BaseInstallLocationValidator.validateOracleHomeCompatiblity(homeLoc, NONE);
    }

    public static StatusMessages<ValidationStatusMessage> validateOracleHomeCompatiblity(String homeLoc, String installType) {
        StatusMessages messages = new StatusMessages();
        boolean skipOracleHomeCompatibilityCheck = Application.isCommandLineSwitchEnabled((String)"-skipOHCompatibilityCheck");
        if (skipOracleHomeCompatibilityCheck) {
            return messages;
        }
        if (!isSetupWizard) {
            try {
                if (!CompatibilityMatrix.getInstance().isCompatibleHome(homeLoc, installType)) {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_NOT_COMPATIBLE_ERR, new Object[]{homeLoc}));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_NOT_COMPATIBLE_ERR, new Object[]{homeLoc}));
            }
        }
        return messages;
    }

    public static void validateOHSpaceChar(String location, String label) throws ValidationException {
        if (BaseInstallLocationValidator.isSkipWhiteSpacesCheck()) {
            return;
        }
        String spaceFound = null;
        spaceFound = GenericValidation.validateBadCharGetString(" ", location);
        if (spaceFound != null) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPACECHAR_ERR, new Object[]{label});
        }
    }

    public static void validateASMDiskGroup(String diskGroupName) throws ValidationException {
        try {
            List<DiskGroup> asmDiskGroups;
            ASMUtility utility = ASMUtility.getInstance();
            ASMInstance asmInstance = utility.getASMInstance();
            if (asmInstance != null && !(asmDiskGroups = utility.getDiskGroups(asmInstance)).isEmpty()) {
                for (DiskGroup diskGroup : asmDiskGroups) {
                    if (!diskGroupName.equalsIgnoreCase(diskGroup.getName())) continue;
                    return;
                }
            }
        }
        catch (ASMUtilityException e) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_DISKGROUP_ERR, new Object[0]);
        }
        throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_DISKGROUP_ERR, new Object[0]);
    }

    public static void validateLocation(String location, String label) throws ValidationException {
        if (location == null || 0 == location.trim().length()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_HOME_LOC_EMPTY_ERR, new Object[]{label});
        }
        if (PlatformInfo.getInstance().isWindows()) {
            int ind = location.indexOf(":");
            String path = location.substring(ind + 1, location.length());
            if (path != null && path.length() > 0 && !path.startsWith("\\")) {
                throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_ORACLE_HOME_LOCATION_ERR, new Object[]{label});
            }
            String locRoot = location.substring(0, ind + 2);
            File[] roots = File.listRoots();
            boolean rootFound = false;
            if (roots != null && roots.length > 0) {
                for (File root : roots) {
                    String rootStr = root.getAbsolutePath();
                    if (!locRoot.equalsIgnoreCase(rootStr)) continue;
                    rootFound = true;
                    break;
                }
            }
            if (!rootFound) {
                throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_ORACLE_HOME_LOCATION_ERR, new Object[]{label});
            }
        }
        if (BaseInstallLocationValidator.getExistingDir(location) == null) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_ORACLE_HOME_LOCATION_ERR, new Object[]{label});
        }
        File fLoc = new File(location);
        if (fLoc.isFile()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_ORACLE_HOME_LOCATION_ERR, new Object[]{label});
        }
        BaseInstallLocationValidator.validateForBadChars(location, BaseInstallLocationValidator.getBadCharsForLocation(), label);
        BaseInstallLocationValidator.validateForFolderNameLength(location, label);
        BaseInstallLocationValidator.validateForWritePermission(location);
    }

    public StatusMessages<ValidationStatusMessage> validateOFACompliance(String oraBase, String oraHomeLoc, boolean whetherLocInBase) {
        File oHome;
        File oBase;
        StatusMessages messages = new StatusMessages();
        boolean bHomeInBase = true;
        boolean bHomeOnACFS = false;
        if (oraBase == null || oraBase.trim().length() == 0 || oraHomeLoc == null || oraHomeLoc.trim().length() == 0) {
            return messages;
        }
        String baseLocStandard = PathInfo.getInstance().getStandardForm(oraBase);
        if (baseLocStandard.length() > 0 && baseLocStandard.charAt(baseLocStandard.length() - 1) != '/') {
            baseLocStandard = baseLocStandard + "/";
        }
        String homeLocStandard = PathInfo.getInstance().getStandardForm(oraHomeLoc);
        int curPlatId = PlatformInfo.getInstance().getCurrentPlatform();
        int curPlatGroup = PlatformInfo.getInstance().getPlatGroup(curPlatId);
        if (curPlatGroup == -3) {
            homeLocStandard = homeLocStandard.toLowerCase();
            baseLocStandard = baseLocStandard.toLowerCase();
        }
        if (homeLocStandard.length() > 0 && homeLocStandard.charAt(homeLocStandard.length() - 1) != '/') {
            homeLocStandard = homeLocStandard + "/";
        }
        if ((oBase = new File(baseLocStandard)).compareTo(oHome = new File(homeLocStandard)) == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_BASE_SAME_AS_ORACLE_HOME, new Object[0]));
        }
        bHomeInBase = homeLocStandard.startsWith(baseLocStandard);
        Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("ACFS.waitingPanel.text", "Retrieving ACFS information...", new Object[0]));
        if (CRSInfo.getInstance().getCRSHome() != null) {
            bHomeOnACFS = ACFSUtil.getInstance().isPathOnACFS(homeLocStandard);
        }
        if (!bHomeOnACFS) {
            if (whetherLocInBase && !bHomeInBase) {
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_NOT_IN_BASE_WRN, Severity.WARNING, new Object[0]));
            } else if (!whetherLocInBase && bHomeInBase) {
                ErrorCode errCode = this.getCustomErrorCode();
                errCode = errCode == null ? CommonErrorCode.INSTALL_COMMON_HOME_IN_BASE_ERR : errCode;
                messages.add((StatusMessage)new ValidationStatusMessage(errCode, new Object[0]));
            }
        }
        Application.hideStatus();
        return messages;
    }

    public void setCustomErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    protected Severity setCustomSeverity(ErrorCode errorCode, Severity severity) {
        return this.errorCodeSeverityMap.put(errorCode, severity);
    }

    protected Severity getCustomSeverity(ErrorCode errorCode) {
        return this.errorCodeSeverityMap.get(errorCode);
    }

    protected ErrorCode getCustomErrorCode() {
        return this.errorCode;
    }

    private static void validateForBadChars(String strToValidate, String badChars, String relatedTo) throws ValidationException {
        if (!GenericValidation.isFilenameValid(strToValidate, badChars)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_BADCHARS_ERR, new Object[]{relatedTo});
        }
    }

    public static void validateForWritePermission(String dirPath) throws ValidationException {
        if (!GenericValidation.isDirWritable(dirPath)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_DIRECTORY_CREATION_ERR, new Object[]{dirPath});
        }
    }

    private static void validateForEmptyLocation(String homeLoc) throws ValidationException {
        String[] dirList;
        File fLoc = new File(homeLoc);
        if (fLoc.isDirectory() && null != (dirList = fLoc.list()) && 0 < dirList.length && !OFAWrapper.getInstance().isHomeWithLocationExist(homeLoc)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_NON_EMPTY_DIRECTORY_WRN, new Object[0]);
        }
    }

    public static StatusMessages<ValidationStatusMessage> checkSpaceAvailForSoftware(String oracleHomeLoc, long requiredBytes) {
        StatusMessages messages = new StatusMessages();
        String oraLocText = BaseInstallLocationValidator.getCommonLabel("INSTALL_COMMON_ORACLE_HOME_LOCATION_LABEL");
        try {
            BaseInstallLocationValidator.validateLocation(oracleHomeLoc, oraLocText);
        }
        catch (ValidationException e) {
            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
            return messages;
        }
        long result = 0L;
        try {
            result = GenericValidation.validateForFreeSpace(requiredBytes, oracleHomeLoc);
        }
        catch (InstallException e) {
            ExceptionManager.getInstance().reportException((Throwable)((Object)e));
        }
        if (result < 0L) {
            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{oracleHomeLoc, FunctionsUtil.getReadableSize(requiredBytes, FunctionsUtil.Unit.MB)})));
        }
        return messages;
    }

    static String getExistingDir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File file = new File(dirPath);
        if (file.exists() && file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return BaseInstallLocationValidator.getExistingDir(file.getParent());
    }

    public static String getCommonLabel(String key) {
        return Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.common.resource.CommonDialogLabelResID", (String)key), new Object[0]);
    }

    public static String getBadCharsForLocation() {
        String badChars = null;
        badChars = PlatformInfo.getInstance().isWindows() ? "!@%^&*()+=|/`[{]};'\",<>?" : "!@%^&*()+=|`~[{]};:'\",<>?\\";
        return badChars;
    }

    private void doesHomeNameConflict(String location) {
        String key = "ORACLE_HOME_NAME";
        OFAWrapper ofa = OFAWrapper.getInstance();
        if (ofa.isPreset(key)) {
            String HOME_NAME = OFAWrapper.props.getProperty(key.toLowerCase());
            String ORACLE_HOME = InventoryInfo.getInstance().getOracleHomeForName(HOME_NAME);
            if (ORACLE_HOME != null && !ORACLE_HOME.equals(location)) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_NAME_ALREADY_EXISTS, new Object[]{HOME_NAME}));
            }
        }
    }

    public static void validateForFolderNameLength(String path, String label) throws ValidationException {
        StringTokenizer tokenizer = new StringTokenizer(path, File.separator);
        while (tokenizer.hasMoreTokens()) {
            if (tokenizer.nextToken().length() <= 255) continue;
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_FOLDER_NAME_LENGTH_EXCEEDED_ERR, new Object[]{label, "255"});
        }
    }

    public void checkWindowsOracleInventory() throws ValidationException {
        File invFile;
        String invLoc;
        File file;
        if (!InventoryInfo.getInstance().isInventoryExist() && (file = new File(invLoc = InventoryInfo.getInstance().getDefaultInventoryLoc())).isDirectory() && (invFile = new File(invLoc, "\\ContentsXML\\inventory.xml")).exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_WINDOWS_INVENTORY_LOC_DIRTY, new Object[]{invLoc});
        }
    }
}

