/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.util.FileInfo;

public class NodeScalerValidationHelper {
    private static Logger logger = Logger.getLogger(NodeScalerValidationHelper.class.getName());
    private static NodeScalerValidationHelper instance = null;
    private static final boolean isWindows = PlatformInfo.getInstance().isWindows();

    private NodeScalerValidationHelper() {
    }

    public static NodeScalerValidationHelper getInstance() {
        if (instance == null) {
            instance = new NodeScalerValidationHelper();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public ValidationStatusMessage validateNonReadableFilesInOracleHome(String oracleHome, String excludeFile) {
        ValidationStatusMessage msg = null;
        Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
        Application.showStatus((String)resource.getString("validate.home.nonreadable.files.text", "Validating Oracle home for inaccessible files...", new Object[0]));
        ArrayList<String> excludeFiles = FileInfo.getFileContentLines(excludeFile);
        ArrayList<String> excludePathList = null;
        ArrayList<String> excludePathPatterns = null;
        if (excludeFiles != null && excludeFiles.size() > 0) {
            excludePathList = new ArrayList<String>();
            excludePathPatterns = new ArrayList<String>();
            for (String string : excludeFiles) {
                void var9_9;
                String absExcludePath;
                if (string == null) continue;
                if (isWindows) {
                    String string2 = string.replace('/', '\\');
                }
                if (this.isPotentialRegularExpression(absExcludePath = new String(oracleHome + File.separator + (String)var9_9))) {
                    excludePathPatterns.add(absExcludePath);
                    continue;
                }
                excludePathList.add(absExcludePath);
            }
        }
        if (excludePathPatterns != null && !excludePathPatterns.isEmpty()) {
            logger.info("ExcludePathPatterns : " + ((Object)excludePathPatterns).toString());
        }
        if (excludePathList != null && !excludePathList.isEmpty()) {
            logger.info("ExcludePathList : " + ((Object)excludePathList).toString());
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        if (excludePathPatterns != null && !excludePathPatterns.isEmpty()) {
            for (String excludePathPattern : excludePathPatterns) {
                if (isWindows) {
                    excludePathPattern = excludePathPattern.replace("\\", "\\\\");
                }
                Pattern excludePattern = Pattern.compile(excludePathPattern);
                excludePatterns.add(excludePattern);
            }
        }
        File file = new File(oracleHome);
        List<String> nonReadableFileList = null;
        try {
            nonReadableFileList = FileInfo.getNonReadableFilesInDir(file, excludePathList, excludePatterns);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not get the non readable files from the source home " + oracleHome, ex);
        }
        if (nonReadableFileList != null && !nonReadableFileList.isEmpty()) {
            ArrayList<String> relPathNonReadableFiles = new ArrayList<String>();
            for (String string : nonReadableFileList) {
                relPathNonReadableFiles.add(string.substring(oracleHome.length() + 1));
            }
            StringBuilder strBuilder = new StringBuilder();
            for (String relPathNonReadableFile : relPathNonReadableFiles) {
                strBuilder.append(relPathNonReadableFile).append(",");
            }
            if (strBuilder.lastIndexOf(",") == strBuilder.length() - 1) {
                strBuilder.deleteCharAt(strBuilder.length() - 1);
            }
            logger.info("Following files are not readable: " + strBuilder.toString());
            String string = System.getProperty("user.name");
            msg = new ValidationStatusMessage((ErrorCode)CommonErrorCode.ORACLE_HOME_NON_READABLE_FILES, new Object[]{strBuilder, string});
        }
        Application.hideStatus();
        return msg;
    }

    private boolean isPotentialRegularExpression(String path) {
        return path != null && path.contains("*");
    }
}

