/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.CRSNodeRemoveActionableValidationStatusMessage;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;

public class WizardValidationHelper {
    private static WizardValidationHelper instance;
    private static boolean isWindows;
    private static final Logger logger;

    private WizardValidationHelper() {
    }

    public static WizardValidationHelper getInstance() {
        if (instance == null) {
            instance = new WizardValidationHelper();
        }
        return instance;
    }

    public List<ValidationStatusMessage> validateRemoteHome(String home, List<String> nodes, boolean actionableValidation) {
        ArrayList<ValidationStatusMessage> errMsgs = new ArrayList<ValidationStatusMessage>();
        List nodesWithNonregisteredHome = null;
        Object nodesWithMismatchingHome = null;
        ArrayList<String> nodesWithInvalidHomeRegistration = new ArrayList<String>();
        for (String node : nodes) {
            if (!this.isHomeRegisteredOnNode(home, node)) {
                nodesWithNonregisteredHome = nodesWithNonregisteredHome == null ? new ArrayList() : nodesWithNonregisteredHome;
                nodesWithNonregisteredHome.add(node);
                continue;
            }
            boolean isHomeRegistered = true;
            FileInfo fileInfo = FileInfo.getInstance();
            if (isWindows) {
                String oracleKey = home + File.separator + "bin" + File.separator + "oracle.key";
                if (!fileInfo.doesRemoteFileExists(node, oracleKey)) {
                    isHomeRegistered = false;
                }
            } else {
                String oraInstLoc = home + File.separator + "oraInst.loc";
                if (!fileInfo.doesRemoteFileExists(node, oraInstLoc)) {
                    isHomeRegistered = false;
                }
            }
            if (!isHomeRegistered) {
                nodesWithInvalidHomeRegistration.add(node);
                continue;
            }
            StatusMessages<ValidationStatusMessage> messages = this.isRemoteHomeSameAsLocalHome(home, node);
            if (messages == null || messages.isEmpty()) continue;
            errMsgs.addAll((Collection<ValidationStatusMessage>)messages);
        }
        if (!nodesWithInvalidHomeRegistration.isEmpty()) {
            if (actionableValidation) {
                errMsgs.add((ValidationStatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_INSTALL_COMMON_INVALID_REMOTE_HOME_REGISTERED, nodesWithInvalidHomeRegistration, new Object[]{((Object)nodesWithInvalidHomeRegistration).toString()}));
            } else {
                errMsgs.add(new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVALID_REMOTE_HOME_REGISTERED, new Object[]{((Object)nodesWithInvalidHomeRegistration).toString()}));
            }
        }
        if (nodesWithNonregisteredHome != null && nodesWithNonregisteredHome.size() > 0) {
            if (actionableValidation) {
                errMsgs.add((ValidationStatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_INSTALL_COMMON_REMOTEHOME_NOT_REGISTERED, nodesWithNonregisteredHome, new Object[]{nodesWithNonregisteredHome}));
            } else {
                errMsgs.add(new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_REMOTEHOME_NOT_REGISTERED, new Object[]{nodesWithNonregisteredHome}));
            }
        }
        return errMsgs;
    }

    private boolean isHomeRegisteredOnNode(String home, String node) {
        return RemoteInventoryInfo.getInstance((String)node).isHomeWithLocationExist(home);
    }

    private StatusMessages<ValidationStatusMessage> isRemoteHomeSameAsLocalHome(String homeLoc, String node) {
        return RemoteInventoryInfo.getInstance((String)node).compareToLocalHome(homeLoc, node);
    }

    public StatusMessages<ValidationStatusMessage> validateRemoteWritablePermission(String location, String[] nodes) {
        StatusMessages errorMessages = new StatusMessages();
        ArrayList<String> nonWritableNodes = new ArrayList<String>();
        if (!PlatformInfo.getInstance().isWindows()) {
            for (String node : nodes) {
                if (MachineInfo.getInstance().isLocalHost(node)) {
                    String localParent = FileInfo.getLastExistingParent(location);
                    boolean isLocalLocationWritable = new File(localParent).canWrite();
                    if (isLocalLocationWritable) continue;
                    nonWritableNodes.add(node);
                    continue;
                }
                String oracleHomeRoot = FileInfo.getInstance().getLastExistingRemoteParent(node, location);
                if (FileInfo.getInstance().isRemoteDirWriatble(node, oracleHomeRoot)) continue;
                nonWritableNodes.add(node);
            }
            if (nonWritableNodes.size() > 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.DIRECTORY_NOT_WRITABLE_ON_NODE, new Object[]{location, ((Object)nonWritableNodes).toString()}));
            }
        }
        return errorMessages;
    }

    public boolean isOracleHomeShared(String[] nodelist, String oracleHome) {
        boolean isShared = false;
        String localnode = MachineInfo.getInstance().getFullHostName();
        ArrayList<String> nodesForSharednessCheck = new ArrayList<String>();
        if (nodelist != null && nodelist.length > 0) {
            nodesForSharednessCheck.addAll(Arrays.asList(nodelist));
        }
        nodesForSharednessCheck.add(localnode);
        try {
            isShared = FileSystemInfo.getInstance().isLocationOnCFS(new File(oracleHome, "cfgtoollogs").getAbsolutePath(), nodesForSharednessCheck);
        }
        catch (InstallException e) {
            logger.log(Level.INFO, "Error while checking for sharedness", (Throwable)((Object)e));
        }
        logger.log(Level.INFO, "Sharedness check for Oracle Home :" + oracleHome + " returned: " + isShared);
        return isShared;
    }

    static {
        isWindows = PlatformInfo.getInstance().isWindows();
        logger = Logger.getLogger(WizardValidationHelper.class.getName());
    }
}

