/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.util.logging.Logger;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.util.SetupSummary;
import oracle.install.ivw.common.view.FinishPane;

public class NodeScalerFinishPane
extends FinishPane {
    private static final Logger logger = Logger.getLogger(NodeScalerFinishPane.class.getName());
    private static Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    private String endOfInstallMessage;

    @Override
    public String calculateSessionStatus(Summary summary) {
        String status = SESSION_SUCCESS;
        boolean instSuccess = summary.isSuccessfullInstall();
        boolean instRemoteSuccess = summary.isSuccessfullRemoteInstall();
        logger.info("Install Succeeded: " + instSuccess);
        logger.info("Remote Install Succeeded: " + instRemoteSuccess);
        if (!instSuccess || !instRemoteSuccess) {
            status = SESSION_FAILURE;
        }
        return status;
    }

    public void setEndOfInstallMessage(String message) {
        this.endOfInstallMessage = message;
    }

    @Override
    public void reloadText() {
        StringBuffer endMsg = new StringBuffer();
        String msg = SetupSummary.getInstance().getText();
        if (msg != null && msg.length() > 0) {
            endMsg.append(msg);
        }
        if (this.endOfInstallMessage != null && this.endOfInstallMessage.length() > 0) {
            endMsg.append(this.endOfInstallMessage);
        }
        if (endMsg.toString() != null && endMsg.toString().length() > 0) {
            super.setTextArea(endMsg.toString());
        }
    }
}

