/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.asm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.PlatformInfo;

public class ACFSUtil {
    private static final Logger logger = Logger.getLogger(ACFSUtil.class.getName());
    private static ACFSUtil instance = null;
    private ClusterwareInfo clusterwareInfo = null;
    private static String acfsutilPath = "";

    protected ACFSUtil() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
        this.initACFSUtilPath();
    }

    private void initACFSUtilPath() {
        if (PlatformInfo.getInstance().isWindows()) {
            String crshome = CRSInfo.getInstance().getCRSHome();
            if (crshome != null && crshome.length() > 0) {
                acfsutilPath = crshome + File.separator + "bin";
            }
        } else {
            try {
                acfsutilPath = this.clusterwareInfo.getOFSUtilDirectory();
            }
            catch (InstallException e) {
                logger.log(Level.INFO, "Error while getting acfsutil path", e);
            }
        }
    }

    public static ACFSUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ACFSUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(ACFSUtil.class)) == null) {
            instance = new ACFSUtil();
        }
        return instance;
    }

    public boolean isACFSDriversConfigured() {
        if (this.isACFSDriversInstalled()) {
            try {
                return this.clusterwareInfo.isOFSDriversConfigured(acfsutilPath);
            }
            catch (InstallException e) {
                logger.log(Level.FINEST, e.getMessage());
                return false;
            }
        }
        return false;
    }

    public boolean isACFSDriversInstalled() {
        try {
            if (acfsutilPath.length() > 0 && acfsutilPath != null) {
                return this.clusterwareInfo.isOFSDriversInstalled(acfsutilPath);
            }
            return false;
        }
        catch (InstallException e) {
            logger.log(Level.FINEST, e.getMessage());
            return false;
        }
    }

    public List<String> getACFSMountPoints() {
        if (this.isACFSDriversConfigured()) {
            try {
                if (acfsutilPath.length() > 0 && acfsutilPath != null) {
                    return this.clusterwareInfo.getOFSMountPoints(acfsutilPath);
                }
            }
            catch (InstallException e) {
                logger.log(Level.FINEST, e.getMessage());
                return null;
            }
        }
        return null;
    }

    public List<String> getRegisteredACFSMountPoints() {
        if (this.isACFSDriversConfigured()) {
            List<String> allValidMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getACFSMountPoints());
            ArrayList<String> registeredMountPoints = null;
            if (allValidMountPoints != null) {
                ListIterator<String> li = allValidMountPoints.listIterator();
                while (li.hasNext()) {
                    String path = li.next();
                    path = path.replaceAll("\\n", "");
                    try {
                        if (!this.clusterwareInfo.isACFSPath(acfsutilPath, path)) continue;
                        if (registeredMountPoints == null) {
                            registeredMountPoints = new ArrayList<String>();
                        }
                        registeredMountPoints.add(path);
                    }
                    catch (InstallException e) {
                        logger.log(Level.FINEST, e.getMessage());
                    }
                }
            }
            return registeredMountPoints;
        }
        return null;
    }

    private static List<String> getListWithValidElemsOnly(List<String> list) {
        if (list != null && list.size() > 0) {
            ArrayList<String> newlist = new ArrayList<String>(list);
            ListIterator iter = newlist.listIterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (s != null && s.trim().length() != 0) continue;
                iter.remove();
            }
            return newlist;
        }
        return list;
    }

    public boolean isPathOnACFS(String path) {
        List<String> allValidMountPoints;
        if (this.isACFSDriversConfigured() && (allValidMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getACFSMountPoints())) != null) {
            ListIterator<String> li = allValidMountPoints.listIterator();
            while (li.hasNext()) {
                String mountpoint = li.next();
                if (PlatformInfo.getInstance().isWindows() && path.toLowerCase().startsWith(mountpoint.toLowerCase())) {
                    return true;
                }
                if (!PlatformInfo.getInstance().isUnix() || !path.startsWith(mountpoint) || path.length() != mountpoint.length() && path.charAt(mountpoint.length()) != File.separatorChar) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathOnRegisteredACFS(String path) {
        List<String> allValidRegisteredMountPoints;
        if (this.isACFSDriversConfigured() && (allValidRegisteredMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getRegisteredACFSMountPoints())) != null) {
            ListIterator<String> li = allValidRegisteredMountPoints.listIterator();
            while (li.hasNext()) {
                String mountpoint = li.next();
                if (!path.startsWith(mountpoint) && (!PlatformInfo.getInstance().isWindows() || !path.toLowerCase().startsWith(mountpoint.toLowerCase())) || path.length() != mountpoint.length() && path.charAt(mountpoint.length()) != File.separatorChar) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAcfsPathRegisteredWithSrvctl(String crshome, String path) {
        List<String> mountpoints = this.getRegisteredACFSMountPoints();
        String acfspath = "";
        for (String mountpoint : mountpoints) {
            if (!path.startsWith(mountpoint) && (!PlatformInfo.getInstance().isWindows() || !path.toLowerCase().startsWith(mountpoint.toLowerCase()))) continue;
            acfspath = mountpoint;
            break;
        }
        if (acfspath.length() > 0) {
            try {
                return this.clusterwareInfo.isACFSPathRegistered(crshome, acfspath);
            }
            catch (InstallException e) {
                logger.log(Level.INFO, "Error While checking if given path on acfs is registered to srvctl", e);
            }
        }
        return false;
    }

    public long getFreeSpace(String mountPoint) {
        long freeSpace = 0L;
        if (mountPoint != null) {
            OFSUtil ofsUtil = null;
            try {
                ofsUtil = new OFSUtil();
            }
            catch (CmdToolUtilException e) {
                logger.warning("could not instantiate ofsutil.\nException: " + e.toString());
            }
            if (ofsUtil != null) {
                try {
                    freeSpace = ofsUtil.getOFSFreeSpace(mountPoint);
                }
                catch (CmdToolUtilException e) {
                    logger.warning("could not get the free space of acfs mountpoint: " + mountPoint + "\nException: " + e.toString());
                }
            }
        }
        return freeSpace;
    }
}

