/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.partition;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.SharedStorageInfo;
import oracle.cluster.verification.SharedStorageResultSet;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.message.Content;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.library.partition.DiskManager;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cvu.CVUHelper;

public class PartitionInfoUnix {
    private static Logger logger = Logger.getLogger(PartitionInfoUnix.class.getName());
    private static List<SharedStorageInfo> storageInfo = null;
    private static String NATIVE_LIB_PATH = System.getProperty("oracle.installer.scratchPath");
    public static final int platID = PlatformInfo.getInstance().getCurrentPlatform();

    public static List<String> getSharedPartitionList(List<String> nodeList) throws UnhandledDriverException {
        String[] nodeListArray = new String[nodeList.size()];
        nodeList.toArray(nodeListArray);
        List<String> partitions = PartitionInfoUnix.getSharedPartitionListCVU(nodeList);
        return partitions;
    }

    public static List<String> getSharedFSList(List<String> nodeList) throws InstallException {
        List<String> partitions = PartitionInfoUnix.getSharedPartitionList(nodeList);
        ArrayList<String> validpartitions = null;
        if (partitions != null && partitions.size() > 0) {
            for (int i = 0; i < partitions.size(); ++i) {
                if (partitions.get(i) == null || partitions.get(i).length() <= 0 || PartitionInfoUnix.isPartitionRaw(partitions.get(i))) continue;
                validpartitions = validpartitions == null ? new ArrayList<String>() : validpartitions;
                validpartitions.add(partitions.get(i));
            }
        }
        return validpartitions;
    }

    public static boolean isPartitionRaw(String partitionName) throws InstallException {
        return DiskManager.getInstance().isPartitionRaw(partitionName);
    }

    public static String getPartitionFormatType(String partitionName) throws InstallException {
        return PartitionInfoUnix.isPartitionRaw(partitionName) ? "raw" : PartitionInfoUnix.getFileSystemType(partitionName);
    }

    public static long getPartitionFreeSpace(String partitionName) throws InstallException {
        return PartitionInfoUnix.getPartitionFreeSizeFS(partitionName);
    }

    public static long getPartitionSizeRaw(String partitionName) throws InstallException {
        long result = 0L;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        try {
            if (!NATIVE_LIB_PATH.endsWith(File.separator)) {
                NATIVE_LIB_PATH = NATIVE_LIB_PATH + File.separatorChar;
            }
            processBuilder.command(NATIVE_LIB_PATH + "srawutl");
            processBuilder.command().add("-s");
            processBuilder.command().add(partitionName);
            RawDiskLineProcessor lineProcessor = new RawDiskLineProcessor();
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, null);
            ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            String line = lineProcessor.output;
            if (line != null) {
                long bsize = Long.parseLong(line);
                result = bsize / 0x100000L;
            }
        }
        catch (Exception ioex) {
            throw new InstallException((Throwable)ioex, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_GET_RAW_PARTITION_SIZE, new Object[0]);
        }
        return result;
    }

    public static long getPartitionSizeFS(String partitionName) throws InstallException {
        long result = 0L;
        partitionName = PartitionInfoUnix.getLastExistingParent(partitionName);
        String cmd = "df -k " + partitionName;
        try {
            result = Long.parseLong(PartitionInfoUnix.getDFCommandColumn(cmd, 1));
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_GET_FS_PARTITION_SIZE, new Object[0]);
        }
        return result;
    }

    public static long getPartitionFreeSizeFS(String partitionName) throws InstallException {
        return DiskManager.getInstance().getFreeSpace(partitionName);
    }

    public static String getFileSystemType(String partitionName) throws InstallException {
        partitionName = PartitionInfoUnix.getLastExistingParent(partitionName);
        String cmd = "df -T " + partitionName;
        String result = "NA";
        try {
            result = PartitionInfoUnix.getDFCommandColumn(cmd, 1);
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_COMMON_UNABLE_TO_GET_FILESYSTEM_TYPE, new Object[0]);
        }
        return result;
    }

    private static String getDFCommandColumn(String command, int thisColumn) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String[] strings = command.split("\\s");
        processBuilder.command(strings);
        DFLineProcessor lineProcessor = new DFLineProcessor();
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, null);
        ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        String output = lineProcessor.output;
        output = output.replaceAll("\\s+", " ");
        String[] result = output.split("\\s");
        return result[thisColumn];
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return PartitionInfoUnix.getLastExistingParent(f.getParent().toString());
    }

    public static List<String> getSharedPartitionListCVU(List<String> nodeList) throws UnhandledDriverException {
        ArrayList<String> sharedPartionList = new ArrayList<String>();
        if (DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.getSharedPartitionList")) {
            SharedStorageResultSet resultSet = null;
            try {
                resultSet = CVUHelper.getInstance().checkSharedStorageAccessibility(nodeList.toArray(new String[0]));
            }
            catch (Throwable t) {
                throw new UnhandledDriverException(t, (ErrorCode)CommonErrorCode.SHARED_PARTITION_LIST_CHECK_FAILED, new Object[0]);
            }
            if (resultSet == null) {
                throw new UnhandledDriverException((ErrorCode)CommonErrorCode.SHARED_PARTITION_LIST_CHECK_FAILED, new Object[0]);
            }
            if (resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                storageInfo = resultSet.getSharedStorage();
                if (storageInfo != null) {
                    for (SharedStorageInfo info : storageInfo) {
                        String sharedPath = info.getStoragePath();
                        StorageType storageType = info.getStorageType();
                        sharedPartionList.add(sharedPath);
                        logger.log(Level.FINEST, "\nShared Path is {0}", sharedPath);
                        logger.log(Level.FINEST, "\nStorage Type is {0}", storageType);
                    }
                }
            } else if (resultSet.getOverallStatus() == OverallStatus.OPERATION_FAILED) {
                throw new UnhandledDriverException((Content)UnhandledDriverException.createExtraDetails((VerificationResultSet)resultSet), (ErrorCode)CommonErrorCode.SHARED_PARTITION_LIST_CHECK_FAILED, new Object[0]);
            }
        } else {
            logger.info("Value specified for property oracle.install.cvu.getSharedPartitionList:" + Boolean.getBoolean("oracle.install.cvu.getSharedPartitionList"));
        }
        return sharedPartionList;
    }

    public static boolean isOCFS2Partition(String location, List<String> nodes) {
        return StorageType.OCFS2 == PartitionInfoUnix.getStorageType(location, nodes);
    }

    public static StorageType getStorageType(String location, List<String> nodes) {
        StorageType storageType = StorageType.UNKNOWN;
        if (storageInfo == null) {
            PartitionInfoUnix.getSharedPartitionListCVU(nodes);
        }
        if (storageInfo != null) {
            for (SharedStorageInfo info : storageInfo) {
                String sharedPath = info.getStoragePath();
                if (!location.startsWith(sharedPath)) continue;
                storageType = info.getStorageType();
                break;
            }
        }
        return storageType;
    }

    public static boolean isSupportedFileSystem(String[] nodes, String location, OracleFileType type) {
        boolean overallStatus;
        VerificationResultSet resultSet = PartitionInfoUnix.checkForSupportedFileSystem(nodes, location, type);
        if (resultSet == null) {
            return true;
        }
        boolean bl = overallStatus = resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL;
        if (overallStatus) {
            return true;
        }
        logger.warning("The file system " + location + " failed with the overall result: " + overallStatus);
        return false;
    }

    public static VerificationResultSet checkForSupportedFileSystem(String[] nodes, String location, OracleFileType type) {
        VerificationResultSet resultSet = null;
        if (DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkSharedStorageFileSystemType")) {
            try {
                resultSet = CVUHelper.getInstance().checkSharedStorageAccessibility(nodes, location, type);
            }
            catch (VerificationException e) {
                throw new UnhandledDriverException((Throwable)e, (ErrorCode)CommonErrorCode.FILE_SYSTEM_TYPE_CHECK_FAILED, new Object[0]);
            }
            catch (InvalidPathException e) {
                throw new UnhandledDriverException((Throwable)e, (ErrorCode)CommonErrorCode.FILE_SYSTEM_TYPE_CHECK_FAILED, new Object[0]);
            }
            catch (Throwable e) {
                throw new UnhandledDriverException(e, (ErrorCode)CommonErrorCode.FILE_SYSTEM_TYPE_CHECK_FAILED, new Object[0]);
            }
            if (resultSet == null) {
                throw new UnhandledDriverException((ErrorCode)CommonErrorCode.FILE_SYSTEM_TYPE_CHECK_FAILED, new Object[0]);
            }
        }
        return resultSet;
    }

    private static class RawDiskLineProcessor
    extends AbstractLineProcessor {
        private String output;

        RawDiskLineProcessor() {
            logger.info("output of srawutl invocation:");
        }

        public void processLine(String line, int lineNumber) {
            logger.info(lineNumber + ": " + line);
            if (this.output == null) {
                this.output = line;
            }
        }
    }

    private static class DFLineProcessor
    extends AbstractLineProcessor {
        private String output;

        private DFLineProcessor() {
        }

        public void processLine(String line, int lineNumber) {
            if (lineNumber == 2) {
                this.output = line;
                return;
            }
        }
    }
}

