/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.util.FileInfo;

public class GoldImageInfo {
    private static Logger logger = Logger.getLogger(GoldImageInfo.class.getName());
    private static GoldImageInfo instance = null;
    private String oracleHome = System.getProperty("ORACLE_HOME");
    private String filesLstPath = this.oracleHome + File.separator + "install" + File.separator + "files.lst";
    private Boolean isFresh = null;
    private Boolean isCloned = null;
    private Boolean isRecreated = null;
    private Boolean isFilesListAvailable = null;
    private List<String> filesList = null;
    private List<String> filesLstContent = null;

    public static GoldImageInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (GoldImageInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(GoldImageInfo.class)) == null) {
            instance = new GoldImageInfo();
        }
        return instance;
    }

    public String getFilesLstPath() {
        return this.filesLstPath;
    }

    public boolean isFresh() {
        if (this.isFresh == null) {
            this.isFresh = this.isFilesListAvailable() && !this.isCloned();
            logger.log(Level.INFO, "The goldimage from " + this.oracleHome + " fresh value: " + this.isFresh);
        }
        return this.isFresh;
    }

    public boolean isCloned() {
        if (this.isCloned == null) {
            this.isCloned = false;
            List<String> lines = this.getFilesLstContent();
            if (lines != null && !lines.isEmpty()) {
                for (int i = lines.size() - 1; i >= 0; --i) {
                    String line = lines.get(i);
                    if (!line.equalsIgnoreCase("# cloned")) continue;
                    this.isCloned = true;
                    break;
                }
            }
            logger.log(Level.INFO, "The goldimage from " + this.oracleHome + " clone value: " + this.isCloned);
        }
        return this.isCloned;
    }

    public boolean isRecreated() {
        if (this.isRecreated == null) {
            this.isRecreated = false;
            List<String> lines = this.getFilesLstContent();
            if (lines != null && !lines.isEmpty()) {
                for (int i = lines.size() - 1; i >= 0; --i) {
                    String line = lines.get(i);
                    if (!line.equalsIgnoreCase("# recreated")) continue;
                    this.isRecreated = true;
                    break;
                }
            }
            logger.log(Level.INFO, "The goldimage from " + this.oracleHome + " recreated value: " + this.isRecreated);
        }
        return this.isRecreated;
    }

    public boolean isFilesListAvailable() {
        if (this.isFilesListAvailable == null) {
            this.isFilesListAvailable = false;
            if (new File(this.filesLstPath).exists()) {
                this.isFilesListAvailable = true;
            }
            logger.log(Level.INFO, "The goldimage from " + this.oracleHome + " files list available value: " + this.isFilesListAvailable);
        }
        return this.isFilesListAvailable;
    }

    public List<String> getFilesList() {
        if (this.filesList == null) {
            this.filesList = new ArrayList<String>();
            List<String> filesLstContent = this.getFilesLstContent();
            for (String line : filesLstContent) {
                if (line == null || line.isEmpty() || line.startsWith("#")) continue;
                this.filesList.add(line);
            }
        }
        return this.filesList;
    }

    private List<String> getFilesLstContent() {
        if (this.filesLstContent == null) {
            this.filesLstContent = new ArrayList<String>();
            if (this.isFilesListAvailable()) {
                this.filesLstContent = FileInfo.getFileContentLines(this.filesLstPath);
            }
        }
        return this.filesLstContent;
    }
}

