/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.GoldImageInfo;

public class GoldImageUtil {
    private static Logger logger = Logger.getLogger(GoldImageUtil.class.getName());
    private static GoldImageUtil instance = null;
    private GoldImageInfo goldImageInfo = GoldImageInfo.getInstance();

    public static GoldImageUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (GoldImageUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(GoldImageUtil.class)) == null) {
            instance = new GoldImageUtil();
        }
        return instance;
    }

    private GoldImageUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean markAsCloned() {
        if (this.goldImageInfo.isFilesListAvailable()) {
            if (!this.goldImageInfo.isCloned()) {
                String filesLstPath = this.goldImageInfo.getFilesLstPath();
                File filesLstFile = new File(filesLstPath);
                if (filesLstFile != null && filesLstFile.canWrite()) {
                    if (FileInfo.appendTextToFile(filesLstPath, "\n# cloned")) return true;
                    logger.warning("Could not mark goldimage as cloned");
                    return false;
                } else {
                    logger.warning("Could not mark goldimage as cloned, files list file is not writable.");
                }
                return false;
            } else {
                logger.log(Level.INFO, "Gold image was already marked as cloned.");
            }
            return false;
        } else {
            logger.log(Level.INFO, "Cannot mark goldimage as cloned, files list does not exist.");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean markAsRecreated(String filesLstPath) {
        File filesLstFile = new File(filesLstPath);
        if (filesLstFile != null && filesLstFile.canWrite()) {
            if (FileInfo.appendTextToFile(filesLstPath, "\n# recreated")) return true;
            logger.warning("Could not mark goldimage as recreated");
            return false;
        } else {
            logger.warning("Could not mark goldimage as recreated, files list file is not writable.");
        }
        return false;
    }
}

