/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.library.util.GenericValidation;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;

public class UIUtil {
    public static void registerInlineValidator(Component view, final JPasswordField txtPasswordField, final JPasswordField confirmPasswordField, final String passwdDesc, Validator inlineValidator, Object validationType) {
        InlineValidationHelper.registerInlineValidator((Component)view, (Component)txtPasswordField, (Validator)inlineValidator, (Object)validationType);
        InlineValidationHelper.registerInlineValidator((Component)view, (Component)confirmPasswordField, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                ValidationStatusMessage message = null;
                if (confirmPasswordField.hasFocus()) {
                    String confirmPasswd = data.toString();
                    char[] passwd = txtPasswordField.getPassword();
                    String passwordText = new String(passwd);
                    message = GenericValidation.validatePasswdMatch(passwordText, confirmPasswd, passwdDesc);
                }
                return message;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        txtPasswordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    String password = e.getDocument().getText(0, e.getDocument().getLength());
                    if (password != null) {
                        confirmPasswordField.setText(null);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    String password = e.getDocument().getText(0, e.getDocument().getLength());
                    if (password != null) {
                        confirmPasswordField.setText(null);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public static void setCursor(int cursor, Component component) {
        OiifmCursorUtil.setCursor((int)cursor, (Component)component);
    }

    public static void setCursor(Cursor cursor, Component component) {
        OiifmCursorUtil.setCursor((Cursor)cursor, (Component)component);
    }
}

