/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class WalletUtil {
    private static final Logger logger = Logger.getLogger(WalletUtil.class.getName());
    private static WalletUtil instance;

    private WalletUtil() {
    }

    public static WalletUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (WalletUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(WalletUtil.class)) == null) {
            instance = new WalletUtil();
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPasswordFromWallet(String walletLocation, String walletPassword, String alias) throws InstallException {
        String entryPassword = null;
        if (walletLocation != null && !walletLocation.isEmpty()) {
            logger.log(Level.INFO, "Wallet location: " + walletLocation);
            if (walletPassword == null || walletPassword.isEmpty()) {
                logger.log(Level.INFO, "Wallet password is empty. Will attempt to open an auto login wallet");
            }
            try {
                OracleWallet wallet = new OracleWallet();
                if (walletPassword != null && !walletPassword.isEmpty()) {
                    wallet.open(walletLocation, walletPassword.toCharArray());
                } else {
                    wallet.open(walletLocation, null);
                }
                OracleSecretStore store = wallet.getSecretStore();
                if (store != null) {
                    char[] charEntryPassword = store.getSecret(alias);
                    if (charEntryPassword == null) return entryPassword;
                    if (charEntryPassword.length <= 0) return entryPassword;
                    return new String(charEntryPassword);
                }
                logger.log(Level.WARNING, "Wallet store is empty, unable to read passwords from wallet");
                throw new InstallException((ErrorCode)CommonErrorCode.WALLET_NO_PASSWORDS_FOUND, walletLocation);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Exception opening wallet - " + e.getMessage());
                throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.WALLET_IOEXCEPTION_OCCURRED, walletLocation);
            }
            catch (OracleSecretStoreException se) {
                logger.log(Level.WARNING, "Exception reading passwords from wallet - " + se.getMessage());
                throw new InstallException((Throwable)se, (ErrorCode)CommonErrorCode.WALLET_PKI_EXCEPTION, walletLocation);
            }
        }
        logger.log(Level.WARNING, "Wallet location is empty. Unable to read passwords from Wallet.");
        throw new InstallException((ErrorCode)CommonErrorCode.WALLET_FILE_NOT_FOUND, walletLocation);
    }
}

