/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.util.Bean;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;
import oracle.install.library.util.cluster.MultiClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;

@BeanDef(value="ClusterConfig")
public class ClusterConfig
extends Bean {
    private ClusterwareType clusterwareType = ClusterwareType.UNKNOWN;
    private String clusterName;
    private List<ClusterNode> nodeList = new ArrayList<ClusterNode>();
    private ClusterType clusterType = ClusterType.BIG;

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    @PropertyDef(value="ClusterwareType")
    public ClusterwareType getClusterwareType() {
        return this.clusterwareType;
    }

    public void setClusterwareType(ClusterwareType type) {
        this.clusterwareType = type;
    }

    @PropertyDef(value="ClusterwareName")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClusterNodes(List<ClusterNode> clusterNodes) {
        this.nodeList = clusterNodes;
    }

    public ClusterNode getClusterNode(String nodeName, boolean fqn) {
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            for (ClusterNode clusterNode : clusterNodes) {
                String pubNodeName;
                if (!(clusterNode instanceof SingleClusterNode) || !(pubNodeName = ((SingleClusterNode)clusterNode).getPublicNodeName(false)).equalsIgnoreCase(nodeName)) continue;
                return clusterNode;
            }
        }
        return null;
    }

    @PropertyDef(value="ClusterNodes")
    public List<ClusterNode> getClusterNodes() {
        return this.nodeList;
    }

    public List<ClusterNode> getAllClusterNodes(int[] indices) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (int index : indices) {
            nodes.add(this.nodeList.get(index));
        }
        return nodes;
    }

    public List<SingleClusterNode> getExpandedListOfNodes() {
        return this.getExpandedListOfNodes(false);
    }

    public List<SingleClusterNode> getExpandedListOfNodes(boolean isDHCP) {
        ArrayList<SingleClusterNode> clusterNodeList = new ArrayList<SingleClusterNode>();
        if (this.nodeList != null && this.nodeList.size() > 0) {
            for (ClusterNode n : this.nodeList) {
                if (n instanceof SingleClusterNode) {
                    clusterNodeList.add((SingleClusterNode)n);
                    continue;
                }
                if (!(n instanceof MultiClusterNode)) continue;
                clusterNodeList.addAll(((MultiClusterNode)n).getExpandedClusterNodeList(isDHCP));
            }
        }
        return clusterNodeList;
    }

    public ClusterNode getClusterNodeAt(int index) {
        ClusterNode clusterNode = null;
        if (this.nodeList != null && index < this.nodeList.size()) {
            clusterNode = this.nodeList.get(index);
        }
        return clusterNode;
    }

    public int addClusterNode(ClusterNode clusterNode) {
        int index = -1;
        if (clusterNode != null && this.nodeList.add(clusterNode)) {
            index = this.nodeList.size() - 1;
        }
        return index;
    }

    public List<ClusterNode> getClusterNodes(int[] indices) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (int index : indices) {
            nodes.add(this.nodeList.get(index));
        }
        return nodes;
    }

    public boolean removeClusterNodes(List<ClusterNode> trashableNodes) {
        boolean deleted = false;
        block0: for (ClusterNode trashNode : trashableNodes) {
            for (int i = 0; i < this.nodeList.size(); ++i) {
                if (this.nodeList.get(i) != trashNode) continue;
                this.nodeList.remove(i);
                deleted = true;
                continue block0;
            }
        }
        return deleted;
    }

    public void removeClusterNodes(int[] indices) {
        List<ClusterNode> trashableNodes = this.getAllClusterNodes(indices);
        this.removeClusterNodes(trashableNodes);
    }

    public List<String> getPublicNodeNames(boolean fqcn) {
        ArrayList<String> publicNodeNames = null;
        publicNodeNames = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            for (ClusterNode clusterNode : clusterNodes) {
                if (clusterNode instanceof SingleClusterNode) {
                    publicNodeNames.add(((SingleClusterNode)clusterNode).getPublicNodeName(fqcn));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                publicNodeNames.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(fqcn));
            }
        }
        return publicNodeNames;
    }

    public List<String> getVirtualHostNames(boolean fqcn) {
        return this.getVirtualHostNames(fqcn, false);
    }

    public List<String> getVirtualHostNames(boolean fqcn, boolean isDHCP) {
        ArrayList<String> virtualHostNames = null;
        virtualHostNames = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            for (ClusterNode clusterNode : clusterNodes) {
                if (clusterNode instanceof SingleClusterNode) {
                    virtualHostNames.add(((SingleClusterNode)clusterNode).getVirtualHostName(fqcn));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                if (isDHCP) {
                    virtualHostNames.add("AUTO");
                    continue;
                }
                if (clusterNode.getNodeType() == ClusterNode.NodeType.RIM) {
                    virtualHostNames.add("");
                    continue;
                }
                virtualHostNames.addAll(((MultiClusterNode)clusterNode).getAllVirtualHostNames(fqcn));
            }
        }
        return virtualHostNames;
    }

    public List<String> getVirtualHostNameForNodeType(ClusterNode.NodeType nodeType, boolean fqcn) {
        ArrayList<String> virtualHostNames = null;
        virtualHostNames = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            for (ClusterNode clusterNode : clusterNodes) {
                if (clusterNode.getNodeType() != nodeType) continue;
                if (clusterNode instanceof SingleClusterNode) {
                    virtualHostNames.add(((SingleClusterNode)clusterNode).getVirtualHostName(fqcn));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                virtualHostNames.addAll(((MultiClusterNode)clusterNode).getAllVirtualHostNames(fqcn));
            }
        }
        return virtualHostNames;
    }

    public List<String> getHubNodes() {
        return this.getHubNodes(true);
    }

    public List<String> getHubNodes(boolean fqn) {
        ArrayList<String> hubNodes = null;
        hubNodes = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            for (ClusterNode clusterNode : clusterNodes) {
                if (clusterNode.getNodeType() != ClusterNode.NodeType.HUB) continue;
                if (clusterNode instanceof SingleClusterNode) {
                    hubNodes.add(((SingleClusterNode)clusterNode).getName(fqn));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                hubNodes.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(fqn));
            }
        }
        return hubNodes;
    }

    public List<String> getAutoNodes() {
        return this.getAutoNodes(true);
    }

    public List<String> getAutoNodes(boolean fqn) {
        ArrayList<String> autoNodes = null;
        autoNodes = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        for (ClusterNode clusterNode : clusterNodes) {
            if (clusterNode.getNodeType() != ClusterNode.NodeType.AUTO) continue;
            if (clusterNode instanceof SingleClusterNode) {
                autoNodes.add(((SingleClusterNode)clusterNode).getName(fqn));
                continue;
            }
            if (!(clusterNode instanceof MultiClusterNode)) continue;
            autoNodes.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(fqn));
        }
        return autoNodes;
    }

    public List<String> getRimNodes() {
        return this.getRimNodes(true);
    }

    public List<String> getRimNodes(boolean fqn) {
        ArrayList<String> rimNodes = null;
        rimNodes = new ArrayList<String>();
        List<ClusterNode> clusterNodes = this.getClusterNodes();
        for (ClusterNode clusterNode : clusterNodes) {
            if (clusterNode.getNodeType() != ClusterNode.NodeType.RIM) continue;
            if (clusterNode instanceof SingleClusterNode) {
                rimNodes.add(((SingleClusterNode)clusterNode).getName(fqn));
                continue;
            }
            if (!(clusterNode instanceof MultiClusterNode)) continue;
            rimNodes.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(fqn));
        }
        return rimNodes;
    }

    public String toString() {
        String clusterConfigString = null;
        List<ClusterNode> clusterNodeList = this.getClusterNodes();
        clusterConfigString = new String();
        switch (this.getClusterType()) {
            case BIG: {
                if (clusterNodeList == null) break;
                for (ClusterNode c : clusterNodeList) {
                    ClusterNode node;
                    String entry = null;
                    if (c instanceof SingleClusterNode) {
                        node = (SingleClusterNode)c;
                        entry = String.format("%s:%s:%s", new Object[]{((SingleClusterNode)node).getPublicNodeName(false), ((SingleClusterNode)node).getVirtualHostName(false), node.getNodeType()});
                    } else if (c instanceof MultiClusterNode) {
                        node = (MultiClusterNode)c;
                        entry = String.format("%s:%s-%s:%s:%s:%s", new Object[]{((MultiClusterNode)node).getHostPrefix(), ((MultiClusterNode)node).getLowerBound(), ((MultiClusterNode)node).getHigherBound(), ((MultiClusterNode)node).getHostSuffix(), ((MultiClusterNode)node).getVipSuffix(), node.getNodeType()});
                    }
                    clusterConfigString = clusterConfigString + entry + ",";
                }
                break;
            }
            case TRADITIONAL: {
                if (clusterNodeList == null) break;
                for (ClusterNode c : clusterNodeList) {
                    ClusterNode node;
                    String entry = null;
                    if (c instanceof SingleClusterNode) {
                        node = (SingleClusterNode)c;
                        entry = String.format("%s:%s", ((SingleClusterNode)node).getPublicNodeName(false), ((SingleClusterNode)node).getVirtualHostName(false));
                    } else if (c instanceof MultiClusterNode) {
                        node = (MultiClusterNode)c;
                        entry = String.format("%s:%s-%s:%s:%s", ((MultiClusterNode)node).getHostPrefix(), ((MultiClusterNode)node).getLowerBound(), ((MultiClusterNode)node).getHigherBound(), ((MultiClusterNode)node).getHostSuffix(), ((MultiClusterNode)node).getVipSuffix());
                    }
                    clusterConfigString = clusterConfigString + entry + ",";
                }
                break;
            }
            case APPLICATION: {
                if (clusterNodeList == null) break;
                for (ClusterNode c : clusterNodeList) {
                    ClusterNode node;
                    String entry = null;
                    if (c instanceof SingleClusterNode) {
                        node = (SingleClusterNode)c;
                        entry = String.format("%s", ((SingleClusterNode)node).getPublicNodeName(false));
                    } else if (c instanceof MultiClusterNode) {
                        node = (MultiClusterNode)c;
                        entry = String.format("%s:%s-%s:%s", ((MultiClusterNode)node).getHostPrefix(), ((MultiClusterNode)node).getLowerBound(), ((MultiClusterNode)node).getHigherBound(), ((MultiClusterNode)node).getHostSuffix());
                    }
                    clusterConfigString = clusterConfigString + entry + ",";
                }
                break;
            }
        }
        if (clusterConfigString.endsWith(",")) {
            clusterConfigString = clusterConfigString.substring(0, clusterConfigString.length() - 1);
        }
        return clusterConfigString;
    }

    protected Object clone() {
        ClusterConfig clusterConfig = new ClusterConfig();
        clusterConfig.setClusterwareType(this.getClusterwareType());
        clusterConfig.setClusterType(this.getClusterType());
        clusterConfig.setClusterName(this.getClusterName());
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (ClusterNode node : this.getClusterNodes()) {
            if (node instanceof SingleClusterNode) {
                SingleClusterNode tmpNode = new SingleClusterNode(((SingleClusterNode)node).getPublicNodeName(), ((SingleClusterNode)node).getVirtualHostName());
                tmpNode.setOracle9iRACDetected(node.isOracle9iRACDetected());
                nodes.add(tmpNode);
                continue;
            }
            if (!(node instanceof MultiClusterNode)) continue;
            MultiClusterNode nodeRange = new MultiClusterNode();
            nodeRange.setHostPrefix(((MultiClusterNode)node).getHostPrefix());
            nodeRange.setHostSuffix(((MultiClusterNode)node).getHostSuffix());
            nodeRange.setHigherBound(((MultiClusterNode)node).getHigherBound());
            nodeRange.setLowerBound(((MultiClusterNode)node).getLowerBound());
            nodeRange.setVipSuffix(((MultiClusterNode)node).getVipSuffix());
            nodeRange.setOracle9iRACDetected(node.isOracle9iRACDetected());
            nodes.add(nodeRange);
        }
        clusterConfig.setClusterNodes(nodes);
        return clusterConfig;
    }

    public static enum ClusterType {
        BIG,
        TRADITIONAL,
        APPLICATION,
        EXTENDED;

    }
}

