/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.library.db.RAC92Info;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.VendorClusterwareInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterConfigException;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;
import oracle.install.library.util.cluster.MultiClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;

public class ClusterSupport {
    private static final Logger logger = Logger.getLogger(ClusterSupport.class.getName());
    private static ClusterSupport instance = null;
    private ClusterConfig clusterConfig = null;
    private Set<String> badClusterNodes;
    private Set<String> upgradePendingNodes;
    private String referenceSeparator;
    private SingleClusterNode localClusterNode;

    public static ClusterSupport getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ClusterSupport)(proxyFactory = ProxyFactory.getInstance()).createProxy(ClusterSupport.class)) == null) {
            instance = new ClusterSupport();
        }
        return instance;
    }

    protected ClusterSupport() {
    }

    public ClusterConfig createClusterConfig(boolean isAutoVIPEnabled, CRSInstallSettings.ClusterType clusterType) {
        ClusterConfig clusterConfig = new ClusterConfig();
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        clusterConfig.setClusterNodes(clusterNodes);
        clusterConfig.setClusterType(clusterType.getValue());
        clusterNodes.add(this.getLocalClusterNode(isAutoVIPEnabled));
        return clusterConfig;
    }

    public SingleClusterNode getLocalClusterNode(boolean isAutoVIPEnabled) {
        if (this.localClusterNode == null) {
            String localHostName = null;
            MachineInfo machineInfo = MachineInfo.getInstance();
            String oracleHostname = InstallHelper.getValueAlt("ORACLE_HOSTNAME");
            localHostName = oracleHostname != null ? oracleHostname : machineInfo.getFullHostName();
            this.localClusterNode = new SingleClusterNode();
            this.localClusterNode.setLocalNode(true);
            this.localClusterNode.setNodeType(ClusterNode.NodeType.HUB);
            this.localClusterNode.setPublicNodeName(machineInfo.getDefPubName(localHostName));
            if (!isAutoVIPEnabled) {
                this.localClusterNode.setVirtualHostName(machineInfo.getDefVIPName(localHostName));
            } else {
                this.localClusterNode.setVirtualHostName("AUTO");
            }
        }
        return this.localClusterNode;
    }

    public ClusterConfig getDefaultClusterConfig() {
        if (this.clusterConfig == null) {
            VendorClusterwareInfo vendorClusterwareInfo = VendorClusterwareInfo.getInstance();
            if (vendorClusterwareInfo.isVendorClusterware()) {
                logger.info("Found Vendor Clusterware. Fetching Cluster Configuration");
                this.clusterConfig = vendorClusterwareInfo.getClusterConfig();
            } else {
                RAC92Info rac92Info = RAC92Info.getInstance();
                if (rac92Info.is92RACPresent()) {
                    logger.info("Found Oracle 9i RAC. Fetching Cluster Configuration");
                    this.clusterConfig = rac92Info.getClusterConfig();
                }
            }
        }
        return this.clusterConfig == null ? null : (ClusterConfig)((Object)this.clusterConfig.clone());
    }

    public ClusterConfig loadClusterConfiguration(File ccf, ClusterConfig.ClusterType clusterType, boolean isBigClusterMode) throws ClusterConfigException {
        ClusterConfig clusterConfig = null;
        FileInputStream ccfIn = null;
        try {
            ccfIn = new FileInputStream(ccf);
            clusterConfig = this.loadClusterConfiguration(ccfIn, clusterType, isBigClusterMode);
            clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        }
        catch (FileNotFoundException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        finally {
            if (ccfIn != null) {
                try {
                    ccfIn.close();
                }
                catch (IOException e) {
                    throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
                }
            }
        }
        return clusterConfig;
    }

    public ClusterConfig loadClusterConfiguration(InputStream ccfIn, ClusterConfig.ClusterType clusterType, boolean isBigClusterMode) throws ClusterConfigException {
        ClusterConfig clusterConfig = new ClusterConfig();
        String line = null;
        String[] data = null;
        int ccfLineNumber = 0;
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterNodes(clusterNodes);
        clusterConfig.setClusterType(clusterType);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(ccfIn));
            this.referenceSeparator = "";
            while ((line = in.readLine()) != null) {
                ++ccfLineNumber;
                line = line.trim().replaceAll("\\t", " ").replaceAll("\\s{2,}", " ");
                logger.log(Level.FINEST, "Processing line: {0}", line);
                if (line.length() == 0 || line.startsWith("#")) continue;
                String currentSeparator = this.calculateCCFSeparator(line);
                data = line.split(currentSeparator);
                SingleClusterNode clusterNode = new SingleClusterNode();
                if (data.length == 1) {
                    clusterNode.setPublicNodeName(data[0]);
                } else if (data.length == 2) {
                    clusterNode.setPublicNodeName(data[0]);
                    if (data[1].startsWith("/")) {
                        clusterNode.setVirtualHostName("");
                        if (data[1].substring(1).trim().length() > 0) {
                            clusterNode.setNodeType(this.getNodeType(data[1].substring(1).trim(), clusterType == ClusterConfig.ClusterType.BIG, String.valueOf(ccfLineNumber)));
                        }
                    } else {
                        clusterNode.setVirtualHostName(data[1]);
                    }
                } else if (data.length == 3 || data.length == 4) {
                    clusterNode.setPublicNodeName(data[0]);
                    if (data[2].startsWith("/")) {
                        if (data[2].substring(1).trim().length() > 0) {
                            clusterNode.setNodeType(this.getNodeType(data[2].substring(1).trim(), clusterType == ClusterConfig.ClusterType.BIG, String.valueOf(ccfLineNumber)));
                        }
                        clusterNode.setVirtualHostName(data[1]);
                    } else {
                        clusterNode.setVirtualHostName(data[2]);
                    }
                    if (data.length == 4) {
                        clusterNode.setSite(data[3]);
                    }
                } else {
                    throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_FORMAT, new Object[0]);
                }
                this.validateClusterNode(clusterNode, isBigClusterMode, String.valueOf(ccfLineNumber));
                clusterNodes.add(clusterNode);
            }
        }
        catch (IOException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            logger.severe("Exception occurred while reading from cluster config file" + e);
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        ClusterNode localClusterNode = this.getLocalClusterNode(false);
        int index = clusterNodes.indexOf(localClusterNode);
        if (index != -1) {
            localClusterNode = clusterNodes.get(index);
            localClusterNode.setLocalNode(true);
        }
        return clusterConfig;
    }

    private String calculateCCFSeparator(String rawLine) throws ClusterConfigException {
        String currentSeparator = null;
        if (rawLine.contains(":") && !rawLine.contains(" ")) {
            currentSeparator = ":";
        } else if (rawLine.contains(" ") && !rawLine.contains(":")) {
            currentSeparator = " ";
        } else if (rawLine.split(" ").length == 1 && rawLine.split(":").length == 1) {
            currentSeparator = " ";
        } else {
            logger.log(Level.SEVERE, "Non-supported separator was found on the cluster configuration file @ line: {0}", rawLine);
            throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_FORMAT, new Object[0]);
        }
        if (this.referenceSeparator.isEmpty()) {
            this.referenceSeparator = currentSeparator;
            logger.log(Level.INFO, "Reference separator found on cluster configuration file: {0}", this.referenceSeparator);
        } else if (!this.referenceSeparator.equalsIgnoreCase(currentSeparator)) {
            logger.log(Level.SEVERE, "Incosistent separation syntax found on cluster configuration file @ line : {0}", rawLine);
            throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_FORMAT, new Object[0]);
        }
        return currentSeparator;
    }

    private void validateClusterNode(SingleClusterNode clusterNode, boolean isBigCluster, String ccfLineNumber) throws ClusterConfigException {
        if (isBigCluster) {
            if (clusterNode.getNodeType() == null) {
                clusterNode.setNodeType(ClusterNode.NodeType.HUB);
            }
        } else if (clusterNode.getNodeType() != null) {
            clusterNode.setNodeType(null);
        }
        this.validatePublicHostName(clusterNode.getPublicNodeName(), ccfLineNumber);
        if (isBigCluster) {
            this.validatePrivateHostName(clusterNode.getVirtualHostName(), clusterNode.getNodeType(), ccfLineNumber);
        }
    }

    private void validatePublicHostName(String nodeHostName, String ccfLineNumber) throws ClusterConfigException {
        String strBadCharsFound = GenericValidation.validateBadCharGetString(" !@%^&*()+=\\|`~[{]};'\",<>/?#$:", nodeHostName);
        if (!GenericValidation.validateForEmptiness(strBadCharsFound)) {
            throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_HOSTNAME_BADCHAR, nodeHostName, ccfLineNumber);
        }
    }

    private void validatePrivateHostName(String nodeHostName, ClusterNode.NodeType nodeType, String ccfLineNumber) throws ClusterConfigException {
        if (nodeType != ClusterNode.NodeType.RIM || !GenericValidation.validateForEmptiness(nodeHostName)) {
            if (GenericValidation.validateForEmptiness(nodeHostName)) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_PRIVATE_HOSTNAME_BLANK, ccfLineNumber);
            }
            String strBadCharsFound = GenericValidation.validateBadCharGetString(" !@%^&*()+=\\|`~[{]};'\",<>/?#$:", nodeHostName);
            if (!GenericValidation.validateForEmptiness(strBadCharsFound)) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_NODE_HOSTNAME_BADCHAR, nodeHostName, ccfLineNumber);
            }
        }
    }

    private ClusterNode.NodeType getNodeType(String nodeTypeStr, boolean isBigCluster, String ccfLineNumber) throws ClusterConfigException {
        if (nodeTypeStr != null && nodeTypeStr.length() > 0) {
            if (nodeTypeStr.equalsIgnoreCase("HUB")) {
                return ClusterNode.NodeType.HUB;
            }
            if (nodeTypeStr.equalsIgnoreCase("LEAF")) {
                return ClusterNode.NodeType.RIM;
            }
            if (nodeTypeStr.equalsIgnoreCase("AUTO")) {
                return ClusterNode.NodeType.AUTO;
            }
            if (isBigCluster) {
                throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_NODE_TYPE, nodeTypeStr, ccfLineNumber);
            }
        }
        return null;
    }

    public static ClusterConfig updateClusterConfig(ClusterConfig clusterCfgFromClusterSupport, ClusterConfig clusterConfig) {
        if (clusterCfgFromClusterSupport != null && clusterConfig != null) {
            List<ClusterNode> nodeList = clusterCfgFromClusterSupport.getClusterNodes();
            HashMap<String, ClusterNode> map = new HashMap<String, ClusterNode>();
            for (ClusterNode clusterNode : nodeList) {
                if (!(clusterNode instanceof SingleClusterNode)) continue;
                map.put(((SingleClusterNode)clusterNode).getPublicNodeName(), clusterNode);
            }
            for (ClusterNode nodeFromTable : clusterConfig.getClusterNodes()) {
                ClusterNode node;
                if (nodeFromTable == null || !(nodeFromTable instanceof SingleClusterNode)) continue;
                String pubNodeName = ((SingleClusterNode)nodeFromTable).getPublicNodeName();
                if (pubNodeName.indexOf(".") != -1) {
                    pubNodeName = pubNodeName.substring(0, pubNodeName.indexOf("."));
                }
                if ((node = (ClusterNode)map.get(pubNodeName)) != null || (node = (ClusterNode)map.get(((SingleClusterNode)nodeFromTable).getPublicNodeName())) != null) {
                    if (node instanceof SingleClusterNode) {
                        ((SingleClusterNode)node).setVirtualHostName(((SingleClusterNode)nodeFromTable).getVirtualHostName());
                        ((SingleClusterNode)node).setPublicNodeName(((SingleClusterNode)nodeFromTable).getPublicNodeName());
                        ((SingleClusterNode)node).setNodeType(((SingleClusterNode)nodeFromTable).getNodeType());
                    }
                } else {
                    nodeList.add(nodeFromTable);
                }
                map.remove(pubNodeName);
                map.remove(((SingleClusterNode)nodeFromTable).getPublicNodeName());
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                nodeList.remove(map.get(iterator.next()));
            }
            clusterCfgFromClusterSupport.setClusterNodes(nodeList);
        }
        return clusterCfgFromClusterSupport;
    }

    public static List<String> getPublicRemoteNodeNames(List<ClusterNode> clusterNodes, boolean fqcn) {
        ArrayList<String> publicNodeNames = null;
        publicNodeNames = new ArrayList<String>();
        if (clusterNodes != null && !clusterNodes.isEmpty()) {
            String localNodeName = MachineInfo.getInstance().getLocalMachineName();
            for (ClusterNode clusterNode : clusterNodes) {
                if (clusterNode.getName(false).equalsIgnoreCase(localNodeName)) continue;
                if (clusterNode instanceof SingleClusterNode) {
                    publicNodeNames.add(((SingleClusterNode)clusterNode).getPublicNodeName(fqcn));
                    continue;
                }
                if (!(clusterNode instanceof MultiClusterNode)) continue;
                publicNodeNames.addAll(((MultiClusterNode)clusterNode).getAllPublicNodeNames(fqcn));
            }
        }
        return publicNodeNames;
    }

    public Set<String> getBadClusterNodes() {
        return this.badClusterNodes;
    }

    public void setBadClusterNodes(Set<String> badClusterNodes) {
        this.badClusterNodes = badClusterNodes;
    }

    public void addBadClusterNodes(List<String> badClusterNodes) {
        if (this.badClusterNodes == null) {
            this.badClusterNodes = new LinkedHashSet<String>();
        }
        this.badClusterNodes.addAll(badClusterNodes);
    }

    public Set<String> getUpgradePendingNodes() {
        return this.upgradePendingNodes;
    }

    public void setUpgradePendingNodes(Collection<String> upgradePendingNodes) {
        this.upgradePendingNodes = new LinkedHashSet<String>(upgradePendingNodes);
    }

    public void addUpgradePendingNodes(List<String> upgradePendingNodes) {
        if (this.upgradePendingNodes == null) {
            this.upgradePendingNodes = new LinkedHashSet<String>();
        }
        this.upgradePendingNodes.addAll(upgradePendingNodes);
    }
}

