/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchDECOS;
import oracle.sysman.oip.oipc.oipch.OipchDECPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchDECPatch;
import oracle.sysman.oip.oipc.oipch.OipchDECVersion;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchVendor;

class OipchDECOSCreator
extends OipchOSCreator {
    private static final String OSINFO_FILE = "osinfo.txt";
    private static final String SIZER = "/usr/sbin/sizer -v";
    private static final String SETLD_PRODUCT_FILE = "setld_product.txt";
    private static final String SETLD_PRODUCT_SCRIPT = "/usr/sbin/setld -i 2>/dev/null";
    private static final String PATCHINFO_FILE = "patchinfo.txt";
    private static final String PATCHINFO_SCRIPT = "/usr/bin/grep NAME= /usr/.smdb./*PAT*.ctrl | sed 's|.*(||' | sed 's|,.*||' |uniq";
    private static final String KERNELINFO_FILE = "kernelinfo.txt";
    private static final String KERNELINFO_SCRIPT = "/sbin/sysconfig -q ";
    private static final String[] KERNELINFO_SCRIPT_OPTIONS = new String[]{"ipc", "proc", "vm", "inet"};
    private OipchDECOS m_oDECOS;

    protected OipchDECOSCreator(int iPlatID) {
        super(iPlatID);
    }

    @Override
    protected OipchOS createOS() {
        this.m_oDECOS = new OipchDECOS();
        this.updateOSInfo();
        this.updateKernelInfo();
        this.updatePackageInfo();
        this.updatePatchInfo();
        return this.m_oDECOS;
    }

    protected void updateOSInfo() {
        this.m_oDECOS.setPlatformID(OiixPlatform.getCurrentPlatform());
        this.m_oDECOS.setOSName(OiixPlatform.getCurrentPlatformOSName());
        OipchDECVersion curVer = new OipchDECVersion(this.getDECOSVersion());
        this.m_oDECOS.setOSVersion(curVer);
        this.m_oDECOS.setOSVendor(new OipchVendor(System.getProperty("java.vendor")));
        this.m_oDECOS.setOSArch(OiixPlatform.getCurrentPlatformArch());
    }

    protected String getDECOSVersion() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)OSINFO_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/sbin/sizer -v>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        if (result != 0) {
            return "";
        }
        String currentLine = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sFile));
            currentLine = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException reader) {
        }
        catch (IOException reader) {
            // empty catch block
        }
        StringTokenizer strtok = new StringTokenizer(currentLine);
        if (strtok.countTokens() < 4) {
            return "Unknown";
        }
        for (int i = 0; i < 3; ++i) {
            strtok.nextToken();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strtok.nextToken();
    }

    private void updateKernelInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE);
        File oFile = new File(sFile);
        if (oFile.exists()) {
            oFile.delete();
            try {
                oFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        int result = 0;
        try {
            for (int i = 0; i < KERNELINFO_SCRIPT_OPTIONS.length; ++i) {
                String sCommand = KERNELINFO_SCRIPT + KERNELINFO_SCRIPT_OPTIONS[i] + " >> " + sFile;
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
        }
        catch (OiilNativeException i) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
        }
        catch (FileNotFoundException sCommand) {
            // empty catch block
        }
        OipchKernelInfo oOSKernelInfo = this.m_oDECOS.getKernel();
        while (true) {
            String currentLine = null;
            try {
                currentLine = reader.readLine();
            }
            catch (IOException e) {
                return;
            }
            if (currentLine == null) break;
            StringTokenizer parmstrtok = new StringTokenizer(currentLine, "=");
            if (parmstrtok.countTokens() < 2) continue;
            String word = parmstrtok.nextToken().trim();
            String value = parmstrtok.nextToken().trim();
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                continue;
            }
            OipchNumKernelProperty cur_prop = new OipchNumKernelProperty(word, new Long(value));
            oOSKernelInfo.addProperty(cur_prop);
        }
        try {
            reader.close();
        }
        catch (IOException currentLine) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePackageInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)SETLD_PRODUCT_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = "/usr/sbin/setld -i 2>/dev/null>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        try {
            Collection oPackages = null;
            oPackages = OipchDECPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                this.m_oDECOS.addPackage((OipchPackage)iter.next());
            }
        }
        catch (IOException oPackages) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePatchInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PATCHINFO_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand22 = "/usr/bin/grep NAME= /usr/.smdb./*PAT*.ctrl | sed 's|.*(||' | sed 's|,.*||' |uniq>" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand22);
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
        }
        catch (FileNotFoundException sCommand22) {
            // empty catch block
        }
        while (true) {
            String currentLine = null;
            try {
                currentLine = reader.readLine();
            }
            catch (IOException e) {
                return;
            }
            if (currentLine == null) break;
            OipchDECPatch opatch = new OipchDECPatch(currentLine);
            this.m_oDECOS.addPatch(opatch);
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

