/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIComparable;
import oracle.sysman.oip.oipc.oipch.OipchICompatComparable;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;

public class OipchSolarisVersion
implements OipchIComparable,
OipchICompatComparable {
    private long m_lMajor;
    private long m_lMinor;
    private String m_sVersion;
    private String m_sExtVersion;
    static final char VERSION_SEPARATOR = '-';

    public OipchSolarisVersion(String ver) throws OipchIncorrectVersionFormatException {
        this.setVersion(ver);
    }

    private void setVersion(String ver) throws OipchIncorrectVersionFormatException {
        if (ver == null) {
            throw new OipchIncorrectVersionFormatException("OUI-11031", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11031"));
        }
        int idx = (ver = ver.trim()).indexOf(45);
        if (idx == -1) {
            Object[] args = new String[]{ver};
            throw new OipchIncorrectVersionFormatException("OUI-11032", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11032", (Object[])args));
        }
        String sMajor = ver.substring(0, idx);
        String sMinor = ver.substring(idx + 1);
        try {
            this.m_lMajor = Long.parseLong(sMajor);
            this.m_lMinor = Long.parseLong(sMinor);
            this.m_sVersion = ver;
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{ver, e.getMessage()};
            throw new OipchIncorrectVersionFormatException("OUI-11033", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11033", (Object[])args), e);
        }
    }

    @Override
    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            OipchSolarisVersion v2;
            if (other == this) {
                iResult = 1;
            } else if (other instanceof OipchSolarisVersion && this.m_lMajor == (v2 = (OipchSolarisVersion)other).getMajorVersion()) {
                iResult = this.m_lMinor == v2.getMinorVersion() ? 1 : (this.m_lMinor < v2.getMinorVersion() ? 2 : 4);
            }
        }
        return iResult;
    }

    private long getMajorVersion() {
        return this.m_lMajor;
    }

    private long getMinorVersion() {
        return this.m_lMinor;
    }

    @Override
    public boolean isCompatible(Object obj) {
        int iCompare = this.compare(obj);
        return iCompare == 1 || iCompare == 4;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public String getDisplayName() {
        return this.m_sExtVersion == null ? this.m_sVersion : this.m_sExtVersion;
    }

    void setDisplayName(String sExtVer) {
        this.m_sExtVersion = sExtVer;
    }

    public boolean equals(Object obj) {
        return this.compare(obj) == 1;
    }

    public int hashCode() {
        return this.m_sVersion.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void setParameter(String sParam) {
        try {
            this.setVersion(sParam);
        }
        catch (OipchIncorrectVersionFormatException e) {
            OiiolTextLogger.appendException((Throwable)((Object)e));
        }
    }
}

