/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchAIXSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchClusterDetails;
import oracle.sysman.oip.oipc.oipch.OipchDECSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchHPSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchLinuxSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchNIC;
import oracle.sysman.oip.oipc.oipch.OipchNetworkDetails;
import oracle.sysman.oip.oipc.oipch.OipchRefHostReader;
import oracle.sysman.oip.oipc.oipch.OipchSolarisSystemReader;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchWindowsSystemReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OipchSystemReader {
    private OipchSystem m_oSystem;
    private Node m_oSystemNode;
    private int m_iPlatID;

    protected OipchSystemReader(Node oNode, int iPlatID) {
        this.m_oSystemNode = oNode;
        this.m_iPlatID = iPlatID;
    }

    static OipchSystemReader getReader(Node oNode, int iPlatID) {
        OipchSystemReader oSystemReader = null;
        switch (iPlatID) {
            case 173: 
            case 453: {
                oSystemReader = new OipchSolarisSystemReader(oNode, iPlatID);
                break;
            }
            case 46: 
            case 110: 
            case 211: 
            case 525: {
                oSystemReader = new OipchLinuxSystemReader(oNode, iPlatID);
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oSystemReader = new OipchWindowsSystemReader(oNode, iPlatID);
                break;
            }
            case 2: 
            case 197: {
                oSystemReader = new OipchHPSystemReader(oNode, iPlatID);
                break;
            }
            case 610: {
                oSystemReader = new OipchAIXSystemReader(oNode, iPlatID);
                break;
            }
            case 87: {
                oSystemReader = new OipchDECSystemReader(oNode, iPlatID);
            }
        }
        return oSystemReader;
    }

    final OipchSystem getSystem() throws OixdInvalidDocumentException {
        if (this.m_oSystem == null) {
            this.m_oSystem = this.createSystem();
        }
        return this.m_oSystem;
    }

    protected OipchSystem createSystem() throws OixdInvalidDocumentException {
        this.m_oSystem = new OipchSystem();
        NodeList oSystemNodes = this.m_oSystemNode.getChildNodes();
        if (oSystemNodes != null) {
            int nSystemNodes = oSystemNodes.getLength();
            Object oAttrib = null;
            Object oSystemNodeAttribs = null;
            for (int i = 0; i < nSystemNodes; ++i) {
                Node oSystemNode = oSystemNodes.item(i);
                if (oSystemNode.getNodeType() != 1) continue;
                if (oSystemNode.getNodeName().equalsIgnoreCase("USERS_GROUPS")) {
                    this.addUsersGroupsDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("CPU")) {
                    this.addCPUDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("MEMORY")) {
                    this.addMemoryDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("NETWORK")) {
                    this.addNetworkDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("ENVIRONMENT")) {
                    this.addEnvVarsDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("DISPLAY")) {
                    this.addDisplayDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("CLUSTER")) {
                    this.addClusterDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("PARTITIONS")) {
                    this.addPartitionDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (oSystemNode.getNodeName().equalsIgnoreCase("DEVICES")) {
                    this.addDeviceDetails(this.m_oSystem, oSystemNode);
                    continue;
                }
                if (!oSystemNode.getNodeName().equalsIgnoreCase("RUNLEVEL")) continue;
                this.addRunlevelDetails(this.m_oSystem, oSystemNode);
            }
        }
        return this.m_oSystem;
    }

    abstract void addPartitionDetails(OipchSystem var1, Node var2) throws OixdInvalidDocumentException;

    abstract void addDeviceDetails(OipchSystem var1, Node var2) throws OixdInvalidDocumentException;

    private void addRunlevelDetails(OipchSystem oSystem, Node oRunlevelNode) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oRunlevelNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            String defaultRunlevel;
            String currentRunlevel;
            boolean bVerify;
            oAttrib = oNodeAttribs.getNamedItem("CURRENT");
            if (oAttrib != null && !(bVerify = oSystem.setCurrentRunlevel(currentRunlevel = oAttrib.getNodeValue()))) {
                Object[] args = new String[]{"Current runlevel"};
                throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
            }
            oAttrib = oNodeAttribs.getNamedItem("DEFAULT");
            if (oAttrib != null && !(bVerify = oSystem.setDefaultRunlevel(defaultRunlevel = oAttrib.getNodeValue()))) {
                Object[] args = new String[]{"Default runlevel"};
                throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
            }
        }
    }

    private void addCPUDetails(OipchSystem oSystem, Node oCPUNode) throws OixdInvalidDocumentException {
        NodeList oCPUDetails = oCPUNode.getChildNodes();
        OipchCPU oCPU = new OipchCPU();
        if (oCPUDetails != null) {
            int nCPUs = oCPUDetails.getLength();
            for (int i = 0; i < nCPUs; ++i) {
                Node oCPUDetailNode = oCPUDetails.item(i);
                Node oAttrib = null;
                NamedNodeMap oNodeAttribs = null;
                if (oCPUDetailNode.getNodeType() != 1) continue;
                if (oCPUDetailNode.getNodeName().equalsIgnoreCase("VENDOR")) {
                    oNodeAttribs = oCPUDetailNode.getAttributes();
                    if (oNodeAttribs == null) continue;
                    oAttrib = oNodeAttribs.getNamedItem("VALUE");
                    if (oAttrib == null) {
                        Object[] args = new String[]{"VENDOR", "VALUE"};
                        throw new OixdInvalidDocumentException("OUI-11201", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11201", (Object[])args));
                    }
                    oCPU.setVendor(oAttrib.getNodeValue());
                    continue;
                }
                if (!oCPUDetailNode.getNodeName().equalsIgnoreCase("SPEED") || (oNodeAttribs = oCPUDetailNode.getAttributes()) == null) continue;
                long lSpeed = 0L;
                String sUnit = "Mhz";
                oAttrib = oNodeAttribs.getNamedItem("VALUE");
                if (oAttrib == null) {
                    Object[] args = new String[]{"SPEED", "VALUE"};
                    throw new OixdInvalidDocumentException("OUI-11201", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11201", (Object[])args));
                }
                lSpeed = Integer.parseInt(oAttrib.getNodeValue());
                oAttrib = oNodeAttribs.getNamedItem("UNIT");
                if (oAttrib != null) {
                    sUnit = oAttrib.getNodeValue();
                    if (sUnit.equalsIgnoreCase("Ghz")) {
                        oCPU.setSpeedInGhz(lSpeed);
                        continue;
                    }
                    if (sUnit.equalsIgnoreCase("Mhz")) {
                        oCPU.setSpeedInMhz(lSpeed);
                        continue;
                    }
                    Object[] args = new String[]{"SPEED", "UNIT"};
                    throw new OixdInvalidDocumentException("OUI-11105", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11105", (Object[])args));
                }
                oCPU.setSpeedInMhz(lSpeed);
            }
            oSystem.addCPU(oCPU);
        }
    }

    private void addEnvVarsDetails(OipchSystem oSystem, Node oEnvVars) throws OixdInvalidDocumentException {
    }

    private void addDisplayDetails(OipchSystem oSystem, Node oDisplay) throws OixdInvalidDocumentException {
    }

    private void addClusterDetails(OipchSystem oSystem, Node oClusterNode) throws OixdInvalidDocumentException {
        OipchClusterDetails oClusterDetails = new OipchClusterDetails();
        NamedNodeMap oNodeAttribs = oClusterNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("CRS");
            if (oAttrib != null) {
                String sCrs = oAttrib.getNodeValue();
                if (sCrs != null && sCrs.equalsIgnoreCase("TRUE")) {
                    oClusterDetails.setCRS(true);
                } else {
                    oClusterDetails.setCRS(false);
                }
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("VENDOR")) != null) {
                String sVendor = oAttrib.getNodeValue();
                if (sVendor != null && sVendor.equalsIgnoreCase("TRUE")) {
                    oClusterDetails.setVendorClusterware(true);
                } else {
                    oClusterDetails.setVendorClusterware(false);
                }
            }
            ArrayList<String> oNodesList = new ArrayList<String>();
            NodeList oClusterChildren = oClusterNode.getChildNodes();
            if (oClusterChildren != null) {
                int nClusterChildren = oClusterChildren.getLength();
                for (int i = 0; i < nClusterChildren; ++i) {
                    String sName;
                    Node oNode = oClusterChildren.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("NODE")) continue;
                    NamedNodeMap oAtts = oNode.getAttributes();
                    Node oAtt = null;
                    oAtt = oNodeAttribs.getNamedItem("NAME");
                    if (oAtt == null || (sName = oAtt.getNodeValue()) == null) continue;
                    oNodesList.add(sName);
                }
            }
            if (oNodesList != null && oNodesList.size() > 0) {
                oClusterDetails.setNodes(OiixVectorOps.list2StrArr(oNodesList));
            }
        } else {
            Object[] args = new String[]{"CLUSTER"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        if (oClusterDetails != null) {
            oSystem.setClusterDetails(oClusterDetails);
        }
    }

    private void addMemoryDetails(OipchSystem oSystem, Node oMemoryNode) throws OixdInvalidDocumentException {
        NodeList oMemoryDetails = oMemoryNode.getChildNodes();
        OipchMemory oMemory = null;
        if (oMemoryDetails != null) {
            int nMemoryDetails = oMemoryDetails.getLength();
            for (int i = 0; i < nMemoryDetails; ++i) {
                Node oMemoryDetailNode = oMemoryDetails.item(i);
                Object oAttrib = null;
                Object oNodeAttribs = null;
                if (oMemoryDetailNode.getNodeType() != 1) continue;
                if (oMemoryDetailNode.getNodeName().equalsIgnoreCase("AVAILABLE_MEMORY")) {
                    oMemory = this.getMemory(oMemoryDetailNode);
                    oSystem.setAvailableMemory(oMemory);
                    continue;
                }
                if (oMemoryDetailNode.getNodeName().equalsIgnoreCase("PHYSICAL_MEMORY")) {
                    oMemory = this.getMemory(oMemoryDetailNode);
                    oSystem.setPhysicalMemory(oMemory);
                    continue;
                }
                if (!oMemoryDetailNode.getNodeName().equalsIgnoreCase("SWAP_SIZE") || Boolean.getBoolean(OipchRefHostReader.S_IF_REFHOST)) continue;
                oMemory = this.getMemory(oMemoryDetailNode);
                oSystem.setSwapSpace(oMemory);
            }
        }
    }

    private OipchMemory getMemory(Node oMemoryDetailNode) throws OixdInvalidDocumentException {
        OipchMemory oMemory = new OipchMemory();
        long lSize = 0L;
        int iUnit = 0;
        String sMemoryType = oMemoryDetailNode.getNodeName();
        NamedNodeMap oNodeAttribs = oMemoryDetailNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            if (oAttrib == null) {
                Object[] args = new String[]{sMemoryType, "VALUE"};
                throw new OixdInvalidDocumentException("OUI-11201", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11201", (Object[])args));
            }
            lSize = Long.parseLong(oAttrib.getNodeValue());
            oAttrib = oNodeAttribs.getNamedItem("UNIT");
            if (oAttrib != null) {
                String sUnit = oAttrib.getNodeValue();
                if (sUnit.equalsIgnoreCase("GB")) {
                    iUnit = 1;
                } else if (sUnit.equalsIgnoreCase("MB")) {
                    iUnit = 0;
                } else {
                    Object[] args = new String[]{"UNIT", "UNIT"};
                    throw new OixdInvalidDocumentException("OUI-11106", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11106", (Object[])args));
                }
            }
            oMemory.setSize(lSize, iUnit);
        }
        return oMemory;
    }

    private void addNetworkDetails(OipchSystem oSystem, Node oNetworkNode) throws OixdInvalidDocumentException {
        OipchNetworkDetails oNetworkDetails = new OipchNetworkDetails();
        NamedNodeMap oNodeAttribs = oNetworkNode.getAttributes();
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("HOSTNAME");
            if (oAttrib != null) {
                oNetworkDetails.setHostName(oAttrib.getNodeValue());
            }
            if ((oAttrib = oNodeAttribs.getNamedItem("IP")) != null) {
                oNetworkDetails.setHostAddress(oAttrib.getNodeValue());
            }
            ArrayList<OipchNIC> oNICsList = new ArrayList<OipchNIC>();
            NodeList oNetworkChildren = oNetworkNode.getChildNodes();
            if (oNetworkChildren != null) {
                int nNetworkChildren = oNetworkChildren.getLength();
                for (int i = 0; i < nNetworkChildren; ++i) {
                    Node oNode = oNetworkChildren.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("NIC")) continue;
                    String sNICName = null;
                    String sNICSubnet = null;
                    String sNICSubnetMask = null;
                    String sNICType = null;
                    NamedNodeMap oAtts = oNode.getAttributes();
                    Node oAtt = null;
                    oAtt = oAtts.getNamedItem("NAME");
                    if (oAtt != null) {
                        sNICName = oAtt.getNodeValue();
                    }
                    if ((oAtt = oAtts.getNamedItem("SUBNET")) != null) {
                        sNICSubnet = oAtt.getNodeValue();
                    }
                    if ((oAtt = oAtts.getNamedItem("SUBNET_MASK")) != null) {
                        sNICSubnetMask = oAtt.getNodeValue();
                    }
                    if ((oAtt = oAtts.getNamedItem("TYPE")) != null) {
                        sNICType = oAtt.getNodeValue();
                    }
                    OipchNIC oNIC = new OipchNIC();
                    oNIC.setName(sNICName);
                    oNIC.setType(sNICType);
                    oNIC.setSubnet(sNICSubnet);
                    oNIC.setMask(sNICSubnetMask);
                    oNICsList.add(oNIC);
                }
            }
            if (oNICsList != null && oNICsList.size() > 0) {
                oNetworkDetails.setHostNICs(oNICsList);
            }
        } else {
            Object[] args = new String[]{"NETWORK"};
            throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
        }
        if (oNetworkDetails != null) {
            oSystem.setNetworkDetails(oNetworkDetails);
        }
    }

    abstract void addUsersGroupsDetails(OipchSystem var1, Node var2) throws OixdInvalidDocumentException;
}

