/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchUnixBooleanMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixDevice;
import oracle.sysman.oip.oipc.oipch.OipchUnixGroup;
import oracle.sysman.oip.oipc.oipch.OipchUnixMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixNumberMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixPartition;
import oracle.sysman.oip.oipc.oipch.OipchUnixStringMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixUser;
import oracle.sysman.oip.oipc.oipch.OipchUser;

public abstract class OipchUnixSystemCreator
extends OipchSystemCreator {
    public static final String CPUINFO_FILE = "cpuinfo.txt";
    public static final String SWAP_FILE = "swapinfo.txt";
    private static final String USR_GRP_FILE = "usrgrpinfo.txt";
    private static final String FSTAB_FILE = "fstab.txt";
    private static final String KFOD_FILE = "kfod.txt";
    private static final String MOUNT_FILE = "mount.txt";
    private static final String DF_FILE = "dfinfo.txt";
    private static final String LS_DEVICES_FILE = "devices.txt";
    private static final String MOUNT_PARAMS_DEFAULTS = "defaults";
    private static final String MOUNT_PARAMS_DEFAULTS_VALUE = "rw,suid,dev,exec,auto,nouser,async";
    private static final String INITTAB_FILE = "/etc/inittab";
    private static final String INITDEFAULT_STRING = ":initdefault";
    private static final String CURRENT_RUNLEVEL_CMD = "/usr/bin/who -r";
    private static final String USERNAME_SCRIPT = "/usr/bin/id -u -n ";
    private static final String USERID_SCRIPT = "/usr/bin/id -u ";
    private static final String ACTIVE_GRP_SCRIPT = "/usr/bin/id -g -n ";
    private static final String ACTIVE_GRP_ID_SCRIPT = "/usr/bin/id -g ";
    private static final String GRPS_SCRIPT = "/usr/bin/id -G -n ";
    private static final String GRPS_ID_SCRIPT = "/usr/bin/id -G ";
    private static final String USER_NOBODY = "nobody ";
    private static final String GROUP_ONLY_SCRIPT = "/bin/cat /etc/group";
    private static final String FSTAB_SCRIPT = "/bin/cat /etc/fstab";
    private static final String DF_SCRIPT = "/bin/df";
    private static final String LS_DEVICES_SCRIPT = "ls -lL /dev/";
    private static final String MOUNT_SCRIPT = "/bin/mount";
    private static final String KFOD_SCRIPT = "kfod n=true disks=all status=true";

    OipchUnixSystemCreator(int iPlatID) {
        super(iPlatID);
    }

    @Override
    public OipchSystem createSystem() {
        OipchSystem oSystem = new OipchSystem();
        this.updateCPUInfo(oSystem);
        this.updateMemoryInfo(oSystem);
        this.updateSwapSpaceInfo(oSystem);
        this.updateDisplayInfo(oSystem);
        this.updateRunlevelInfo(oSystem);
        this.updateEnvVarsInfo(oSystem);
        if (Boolean.getBoolean("oracle.installer.advancedHostDB")) {
            this.updateShellDetails(oSystem);
        }
        if (Boolean.getBoolean("oracle.installer.advancedHost")) {
            this.updateClusterInfo(oSystem);
            this.updateGroupsAndUsersInfo(oSystem);
            this.updateGroups(oSystem);
            this.updateDeviceDetails(oSystem);
            this.updatePartitionDetails(oSystem);
            this.updateNetworkDetails(oSystem);
        }
        if (Boolean.getBoolean("oracle.installer.asmHost")) {
            this.updateDeviceDetailsFromKfod(oSystem);
        }
        return oSystem;
    }

    abstract void updateCPUInfo(OipchSystem var1);

    private void updateDisplayInfo(OipchSystem oSystem) {
    }

    private void updateSwapSpaceInfo(OipchSystem oSystem) {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)SWAP_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = this.getSwapScript() + ">" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        if (result != 0) {
            return;
        }
        try {
            long lSwapSpace = this.getSwapSpaceFromFile(sFile);
            OipchMemory oSwap = new OipchMemory();
            oSwap.setSize(lSwapSpace, 0);
            oSystem.setSwapSpace(oSwap);
        }
        catch (IOException oSwap) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract long getSwapSpaceFromFile(String var1) throws IOException;

    abstract String getSwapScript();

    private void updatePartitionDetails(OipchSystem oSystem) {
        this.updatePartitionDetailsFromMountCmd(oSystem);
        this.updatePartitionDetailsFromFstab(oSystem);
    }

    private void updateDeviceDetails(OipchSystem oSystem) {
        this.updateDeviceDetailsFromDfCmd(oSystem);
        this.updateDeviceDetailsFromLsCmd(oSystem);
    }

    private void updateDeviceDetailsFromLsCmd(OipchSystem oSystem) {
        String sCmd = LS_DEVICES_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)LS_DEVICES_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        if (result != 0) {
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            retStr = reader.readLine();
            Map oDeviceHash = oSystem.getDeviceDetails();
            while (retStr != null) {
                StringTokenizer stDeviceInfo = new StringTokenizer(retStr);
                if (stDeviceInfo != null && stDeviceInfo.hasMoreTokens()) {
                    OipchUnixDevice oDevice = null;
                    String sPerms = stDeviceInfo.nextToken();
                    stDeviceInfo.nextToken();
                    String sUser = stDeviceInfo.nextToken();
                    String sGrp = stDeviceInfo.nextToken();
                    String sName = null;
                    while (stDeviceInfo.hasMoreTokens()) {
                        sName = "/dev/" + stDeviceInfo.nextToken();
                    }
                    if (oDeviceHash != null && (oDevice = (OipchUnixDevice)oDeviceHash.get(sName)) == null) {
                        oDevice = new OipchUnixDevice();
                        oDevice.setName(sName);
                    }
                    oDevice.setPermissions(sPerms);
                    oDevice.setUser(sUser);
                    oDevice.setGroup(sGrp);
                    oSystem.addDevice(oDevice);
                }
                retStr = reader.readLine();
                stDeviceInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateDeviceDetailsFromKfod(OipchSystem oSystem) {
        String discoveryPath;
        String sCmd = KFOD_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KFOD_FILE);
        String prereqConfigLoc = this.getPrereqConfigLoc();
        if (prereqConfigLoc != null && !prereqConfigLoc.equals("")) {
            sCmd = OiixPathOps.directorify((String)this.getPrereqConfigLoc()) + sCmd;
        }
        if ((discoveryPath = System.getProperty("oracle.installer.asmDiscoveryPath", "")) != null && !discoveryPath.equals("")) {
            String discArg = null;
            discArg = discoveryPath.startsWith("'") ? " asm_diskstring=" + discoveryPath.trim() : " asm_diskstring='" + discoveryPath.trim() + "'";
            sCmd = sCmd + discArg;
        }
        String sCommand = sCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            Map oDeviceHash = oSystem.getDeviceDetails();
            while (retStr != null) {
                StringTokenizer stDeviceInfo = new StringTokenizer(retStr);
                if (stDeviceInfo != null && stDeviceInfo.hasMoreTokens()) {
                    OipchUnixDevice oDevice = null;
                    stDeviceInfo.nextToken();
                    String sType = stDeviceInfo.nextToken();
                    String sName = stDeviceInfo.nextToken();
                    if (oDeviceHash != null && (oDevice = (OipchUnixDevice)oDeviceHash.get(sName)) == null) {
                        oDevice = new OipchUnixDevice();
                        oDevice.setName(sName);
                    }
                    if (sType.equalsIgnoreCase("CANDIDATE")) {
                        oDevice.setASMCandidacy(true);
                    } else if (sType.equalsIgnoreCase("MEMBER")) {
                        oDevice.setASMStamped(true);
                    }
                    oSystem.addDevice(oDevice);
                }
                retStr = reader.readLine();
                stDeviceInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getPrereqConfigLoc() {
        return System.getProperty("oracle.installer.prereqConfigLoc", "");
    }

    private void updateDeviceDetailsFromDfCmd(OipchSystem oSystem) {
        String sCmd = DF_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)DF_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        if (result != 0) {
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            retStr = reader.readLine();
            Map oDeviceHash = oSystem.getDeviceDetails();
            while (retStr != null) {
                StringTokenizer stDeviceInfo = new StringTokenizer(retStr);
                if (stDeviceInfo != null && stDeviceInfo.hasMoreTokens()) {
                    OipchUnixDevice oDevice = null;
                    String sName = stDeviceInfo.nextToken();
                    if (oDeviceHash != null && (oDevice = (OipchUnixDevice)oDeviceHash.get(sName)) == null) {
                        oDevice = new OipchUnixDevice();
                        oDevice.setName(sName);
                    }
                    if (!stDeviceInfo.hasMoreTokens()) {
                        stDeviceInfo = null;
                        retStr = reader.readLine();
                        stDeviceInfo = new StringTokenizer(retStr);
                    }
                    try {
                        String sLong = stDeviceInfo.nextToken();
                        Long oTotal = new Long(sLong);
                        oDevice.setTotalMem(oTotal);
                    }
                    catch (NumberFormatException sLong) {
                        // empty catch block
                    }
                    stDeviceInfo.nextToken();
                    try {
                        Long oAvail = new Long(stDeviceInfo.nextToken());
                        oDevice.setAvailMem(oAvail);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    stDeviceInfo.nextToken();
                    oDevice.setMount(stDeviceInfo.nextToken());
                    oSystem.addDevice(oDevice);
                }
                retStr = reader.readLine();
                stDeviceInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePartitionDetailsFromMountCmd(OipchSystem oSystem) {
        String sCmd = MOUNT_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)MOUNT_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        if (result != 0) {
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            while (retStr != null) {
                StringTokenizer stPartitionInfo = new StringTokenizer(retStr);
                if (stPartitionInfo != null && stPartitionInfo.hasMoreTokens()) {
                    OipchUnixPartition oPartition = new OipchUnixPartition();
                    oPartition.setDevice(stPartitionInfo.nextToken());
                    stPartitionInfo.nextToken();
                    oPartition.setMount(stPartitionInfo.nextToken());
                    stPartitionInfo.nextToken();
                    oPartition.setType(stPartitionInfo.nextToken());
                    String sMountParams = stPartitionInfo.nextToken();
                    sMountParams = sMountParams.substring(1, sMountParams.length() - 1);
                    oPartition.setParams(OipchUnixSystemCreator.constructMountParameters(sMountParams));
                    oSystem.addPartition(oPartition);
                }
                retStr = reader.readLine();
                stPartitionInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePartitionDetailsFromFstab(OipchSystem oSystem) {
        String sCmd = FSTAB_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)FSTAB_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        String comment = "#";
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        if (result != 0) {
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            StringTokenizer stPartitionInfo = null;
            while (retStr != null) {
                if (!retStr.startsWith("#") && (stPartitionInfo = new StringTokenizer(retStr)) != null && stPartitionInfo.hasMoreTokens()) {
                    OipchUnixPartition oPartition = new OipchUnixPartition();
                    String sDev = stPartitionInfo.nextToken();
                    int idx = sDev.indexOf("=");
                    if (idx != -1) {
                        sDev = sDev.substring(idx + 1);
                    }
                    oPartition.setDevice(sDev);
                    oPartition.setMount(stPartitionInfo.nextToken());
                    oPartition.setType(stPartitionInfo.nextToken());
                    String sMountParams = stPartitionInfo.nextToken();
                    oPartition.setParams(OipchUnixSystemCreator.constructMountParameters(sMountParams));
                    oSystem.addPartition(oPartition);
                }
                retStr = reader.readLine();
                stPartitionInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List constructMountParameters(String sMountParams) {
        ArrayList<OipchUnixMountParameter> oMtParams = null;
        if (sMountParams != null && sMountParams.equals(MOUNT_PARAMS_DEFAULTS)) {
            oMtParams = OipchUnixSystemCreator.constructMountParameters(MOUNT_PARAMS_DEFAULTS_VALUE);
        } else {
            StringTokenizer stMtParams = new StringTokenizer(sMountParams, ",");
            if (stMtParams != null) {
                oMtParams = new ArrayList<OipchUnixMountParameter>();
                while (stMtParams.hasMoreTokens()) {
                    String sParam = stMtParams.nextToken();
                    int iIdx = sParam.indexOf("=");
                    if (iIdx != -1) {
                        OipchUnixMountParameter oParam;
                        String sName = sParam.substring(0, iIdx);
                        String sVal = sParam.substring(iIdx + 1);
                        try {
                            Long oVal = new Long(sVal);
                            oParam = new OipchUnixNumberMountParameter();
                            oParam.setName(sName);
                            ((OipchUnixNumberMountParameter)oParam).setValue(oVal);
                            oMtParams.add(oParam);
                        }
                        catch (NumberFormatException e) {
                            oParam = new OipchUnixStringMountParameter();
                            oParam.setName(sName);
                            ((OipchUnixStringMountParameter)oParam).setValue(sVal);
                            oMtParams.add(oParam);
                        }
                        continue;
                    }
                    OipchUnixBooleanMountParameter oParam = new OipchUnixBooleanMountParameter();
                    oParam.setName(sParam);
                    oParam.setValue(Boolean.TRUE);
                    oMtParams.add(oParam);
                }
            }
        }
        return oMtParams;
    }

    private void updateGroupsAndUsersInfo(OipchSystem oSystem) {
        this.updateUserAndGroup(oSystem, null);
    }

    @Override
    public OipchUser updateUserAndGroup(OipchSystem oSystem, String sUser) {
        String sUserName;
        OipchUnixUser oUser = null;
        String sUsernameCmd = USERNAME_SCRIPT;
        String sUserIDCmd = USERID_SCRIPT;
        String sActiveGrpCmd = ACTIVE_GRP_SCRIPT;
        String sActiveGrpIDCmd = ACTIVE_GRP_ID_SCRIPT;
        String sGrpsCmd = GRPS_SCRIPT;
        String sGrpsIDCmd = GRPS_ID_SCRIPT;
        if (sUser != null) {
            sUsernameCmd = sUsernameCmd + sUser;
            sUserIDCmd = sUserIDCmd + sUser;
            sActiveGrpCmd = sActiveGrpCmd + sUser;
            sActiveGrpIDCmd = sActiveGrpIDCmd + sUser;
            sGrpsCmd = sGrpsCmd + sUser;
            sGrpsIDCmd = sGrpsIDCmd + sUser;
        }
        if ((sUserName = this.invokeCommand(sUsernameCmd)) != null) {
            oUser = new OipchUnixUser();
            oUser.setName(sUserName);
            Integer oUserID = new Integer(this.invokeCommand(sUserIDCmd));
            oUser.setID(oUserID);
            OipchUnixGroup oActGrp = new OipchUnixGroup();
            oActGrp.setName(this.invokeCommand(sActiveGrpCmd));
            Integer oActGrpId = new Integer(this.invokeCommand(sActiveGrpIDCmd));
            oActGrp.setID(oActGrpId);
            oUser.setActiveGroup(oActGrp);
            StringTokenizer stGroupNames = new StringTokenizer(this.invokeCommand(sGrpsCmd));
            StringTokenizer stGroupIDs = new StringTokenizer(this.invokeCommand(sGrpsIDCmd));
            ArrayList<OipchUnixGroup> oGrpsList = new ArrayList<OipchUnixGroup>(stGroupNames.countTokens());
            while (stGroupNames.hasMoreTokens() && stGroupIDs.hasMoreTokens()) {
                String sGrp = stGroupNames.nextToken();
                String sGrpID = stGroupIDs.nextToken();
                Integer oGrpID = new Integer(sGrpID);
                OipchUnixGroup oGrp = new OipchUnixGroup();
                oGrp.setName(sGrp);
                oGrp.setID(oGrpID);
                oSystem.addGroup(oGrp);
                oGrpsList.add(oGrp);
            }
            oUser.setGroups(oGrpsList);
            oSystem.addUser(oUser);
        }
        return oUser;
    }

    private void updateRunlevelInfo(OipchSystem oSystem) {
        this.updateDefaultRunlevelInfo(oSystem);
        this.updateCurrentRunlevelInfo(oSystem);
    }

    private void updateCurrentRunlevelInfo(OipchSystem oSystem) {
        String returnString = this.invokeCommand(CURRENT_RUNLEVEL_CMD);
        if (returnString != null) {
            String currentRunlevel;
            String currentRunlevelString;
            StringTokenizer st = new StringTokenizer(returnString);
            int numTokens = st.countTokens();
            if (numTokens < 2) {
                System.err.println("/usr/bin/who -r failed or gave unexpected result. Unable to fetch current runlevel.");
            }
            if (!(currentRunlevelString = st.nextToken()).equalsIgnoreCase("run-level")) {
                currentRunlevelString = st.nextToken();
            }
            if (!oSystem.setCurrentRunlevel(currentRunlevel = st.nextToken())) {
                System.err.println("/usr/bin/who -r failed or gave unexpected result. Unable to fetch current runlevel.");
            }
        } else {
            System.err.println("/usr/bin/who -r failed or gave unexpected result. Unable to fetch current runlevel.");
        }
    }

    private void updateDefaultRunlevelInfo(OipchSystem oSystem) {
        BufferedReader inittabReader = null;
        String line = "";
        boolean flag = false;
        try {
            inittabReader = new BufferedReader(new FileReader(INITTAB_FILE));
            while ((line = inittabReader.readLine()) != null) {
                if (line.indexOf(INITDEFAULT_STRING) == -1 || line.startsWith("#")) continue;
                flag = true;
                StringTokenizer st = new StringTokenizer(line, ":");
                int numTokens = st.countTokens();
                if (numTokens < 2) {
                    System.err.println("/etc/inittab does not seem to contain default runlevel information.");
                } else {
                    String idString = st.nextToken();
                    String defaultRunlevel = st.nextToken();
                    if (!oSystem.setDefaultRunlevel(defaultRunlevel)) {
                        System.err.println("/etc/inittab seems to be corrupted.");
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("/etc/inittab seems to be corrupted or not-readable.");
        }
        if (!flag) {
            System.err.println("/etc/inittab does not seem to contain default runlevel information.");
        }
    }

    private void updateGroups(OipchSystem oSystem) {
        String sGrpCmd = GROUP_ONLY_SCRIPT;
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)USR_GRP_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sGrpCmd + " >" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return;
        }
        if (result != 0) {
            return;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            while (retStr != null) {
                StringTokenizer stGroupInfo = new StringTokenizer(retStr, ":");
                if (stGroupInfo != null && stGroupInfo.hasMoreTokens()) {
                    OipchUnixGroup oGrp = new OipchUnixGroup();
                    oGrp.setName(stGroupInfo.nextToken());
                    if (stGroupInfo.hasMoreTokens()) {
                        stGroupInfo.nextToken();
                        if (stGroupInfo.hasMoreTokens()) {
                            try {
                                Integer oID = new Integer(stGroupInfo.nextToken());
                                oGrp.setID(oID);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    oSystem.addGroup(oGrp);
                }
                retStr = reader.readLine();
                stGroupInfo = null;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String invokeCommand(String sCmd) {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)USR_GRP_FILE);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = sCmd + ">" + sFile;
        int result = 0;
        try {
            OiiolTextLogger.appendText((String)("Invoking command: " + sCommand));
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            OiiolTextLogger.appendText((String)("Return Code of the command: " + result));
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
            return null;
        }
        if (result != 0) {
            return null;
        }
        String retStr = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            retStr = reader.readLine();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retStr;
    }

    abstract void updateShellDetails(OipchSystem var1);
}

