/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMInstanceType;
import oracle.install.asm.util.ASMType;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.ExadataDisk;
import oracle.install.asm.util.impl.DefaultASMUtility;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.util.ProxyFactory;

public abstract class ASMUtility {
    private static final Logger logger = Logger.getLogger(DefaultASMUtility.class.getName());
    private static ASMUtility instance = null;

    public static ASMUtility getInstance() throws ASMUtilityException {
        if (instance == null) {
            ProxyFactory proxyFactory = ProxyFactory.getInstance();
            instance = (ASMUtility)proxyFactory.createProxy(ASMUtility.class);
            if (instance == null) {
                instance = new DefaultASMUtility();
            }
            instance.init();
        }
        return instance;
    }

    protected ASMUtility() {
    }

    public void init() throws ASMUtilityException {
    }

    public abstract String getDefaultDiscoveryString() throws ASMUtilityException;

    public abstract int shallowFindDisks(String ... var1) throws ASMUtilityException;

    public abstract List<Disk> findDisks(String ... var1) throws ASMUtilityException;

    public abstract List<String> findDiskgroupsFromHeader(String var1) throws ASMUtilityException;

    public abstract ASMInstance getASMInstance() throws ASMUtilityException;

    public abstract List<DiskGroup> getDiskGroups(ASMInstance var1) throws ASMUtilityException;

    public abstract List<DiskGroup> getDiskGroups(String var1) throws ASMUtilityException;

    public abstract List<Disk> getDisks(ASMInstance var1, DiskGroup var2) throws ASMUtilityException;

    public abstract boolean isAlive(ASMInstance var1) throws ASMUtilityException;

    public abstract boolean isAccessible(ASMInstance var1) throws ASMUtilityException;

    public abstract List<OracleService> getClientServices(ASMInstance var1) throws ASMUtilityException;

    public abstract List<String> getActiveASMClients(ASMInstance var1) throws ASMUtilityException;

    public void stampDisk(Disk ... disks) throws ASMUtilityException {
        throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
    }

    public ASMInstance getDetails(ASMInstance asmInstance) throws ASMUtilityException {
        return asmInstance;
    }

    public abstract List<ASMInstance> getASMInstances(String ... var1) throws ASMUtilityException;

    public List<String> detectASM(boolean isUpgrade, String ... nodes) throws ASMUtilityException {
        logger.info("ASMUtility.detectASM(): default method called...");
        return null;
    }

    public List<String> detectASM(String ... nodes) throws ASMUtilityException {
        ArrayList<String> list = new ArrayList<String>();
        List<ASMInstance> asmInstances = this.getASMInstances(nodes);
        for (ASMInstance instance : asmInstances) {
            String node = instance.getHostName();
            list.add(node);
        }
        return list;
    }

    public abstract List<String> getAllowedASMVersionsForRollingUpgrade() throws ASMUtilityException;

    public abstract ASMInstanceType getASMInstanceType(ASMInstance var1) throws ASMUtilityException;

    public ASMType detectASMType() throws ASMUtilityException {
        return ASMType.LOCAL;
    }

    public abstract List<Disk> findDisks(boolean var1, String ... var2) throws ASMUtilityException;

    public abstract List<ExadataDisk> findExadataDisks(String[] var1) throws ASMUtilityException;
}

