/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.ArrayList;
import java.util.List;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.ExadataDisk;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.commons.bean.TypeTranslator;

class ExadataDiskOpOutputParser
extends KFODOpOutputParser {
    private List<ExadataDisk> disks = new ArrayList<ExadataDisk>();

    @Override
    public void parseLine(String line) {
        ExadataDisk disk = this.parseDisk(line);
        if (disk != null) {
            this.disks.add(disk);
        }
    }

    public List<ExadataDisk> getDisks() {
        return this.disks;
    }

    private ExadataDisk parseDisk(String line) {
        ExadataDisk disk = null;
        String[] tokens = Helper.tokenize(line);
        if (tokens.length == 6 || tokens.length == 8) {
            try {
                long size = Long.parseLong(tokens[0].trim());
                DiskHeaderStatus headerStatus = (DiskHeaderStatus)((Object)TypeTranslator.translate((String)tokens[1].trim(), DiskHeaderStatus.class));
                String path = tokens[2].trim();
                String cellName = tokens[3].trim();
                String siteName = tokens[4].trim();
                disk = new ExadataDisk(path, size, headerStatus, cellName, siteName);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return disk;
    }
}

