/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util.autoupdates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;

public class ApplyUpdatesJob
extends Job
implements Callable<Void>,
Retriable {
    private ArrayList oneOffPatchList;
    private String downloadLoc;
    private static Logger logger = Logger.getLogger(ApplyUpdatesJob.class.getName());
    private HashMap sessionHashMap;
    UpdateManager updateManager = UpdateManager.getInstance();

    public ApplyUpdatesJob(ArrayList oneOffs, HashMap hashMap) {
        String[] nodes;
        Object val;
        this.oneOffPatchList = oneOffs;
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        String desc = resource.getString("AUTOUPDATES_APPLY_JOB", "Apply Software Updates", new Object[0]);
        this.setDescription(desc);
        if (hashMap != null) {
            this.sessionHashMap = hashMap;
        }
        boolean isRequired = false;
        if (hashMap != null && hashMap.containsKey("CLUSTER_NODES") && hashMap.get("CLUSTER_NODES") != null && (val = hashMap.get("CLUSTER_NODES")) != null && val instanceof String[] && ((nodes = (String[])val).length > 1 || nodes.length == 1 && !nodes[0].isEmpty())) {
            isRequired = true;
        }
        this.setWeightage(0.2f);
        this.setRequired(isRequired);
        this.setRetryEnabled(true);
        this.setRetriable(this);
    }

    public void setDownloadLoc(String loc) {
        this.downloadLoc = loc;
    }

    public String getDownloadLoc() {
        return this.downloadLoc;
    }

    public Callable<?> getWork() {
        return this;
    }

    public void apply() throws Exception {
        boolean applied = false;
        if (this.updateManager.getOPatchUpdate() != null && this.updateManager.getOPatchUpdate().getPatchBugNumber() != -1) {
            logger.log(Level.INFO, "Applying new opatch...");
            applied = this.updateManager.applyOPatch(this.sessionHashMap, this.getDownloadLoc(), this.updateManager.getOPatchUpdate().getPatchBugNumber());
        }
        if (this.oneOffPatchList != null && this.oneOffPatchList.size() > 0) {
            applied = this.updateManager.applyOneOffs(this.sessionHashMap, this.getDownloadLoc(), this.oneOffPatchList);
            if (applied) {
                logger.log(Level.INFO, "Applied oneoffs");
            } else {
                logger.log(Level.INFO, "Did not apply oneoffs");
            }
        }
        if (applied) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            this.setStatus(Status.FAILED);
        }
    }

    public void retry() throws Exception {
        this.setStatus(Status.INPROGRESS);
        logger.log(Level.INFO, "Retrying to apply updates...");
        this.apply();
    }

    @Override
    public Void call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        logger.log(Level.INFO, "Applying updates...");
        this.apply();
        return null;
    }

    public List getRetriableJobs() {
        ArrayList<ApplyUpdatesJob> jobList = new ArrayList<ApplyUpdatesJob>();
        jobList.add(this);
        return jobList;
    }
}

