/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.bean.RootConfigurationSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationStatusMessage;

public class RootConfigValidationHelper {
    private static Logger logger = Logger.getLogger(RootConfigValidationHelper.class.getName());

    public StatusMessages<ValidationStatusMessage> validate(RootConfigurationSettings configSettings) {
        logger.log(Level.INFO, "Node list is empty. So considering local node for validation");
        String localNode = MachineInfo.getInstance().getLocalMachineName();
        return this.validate(configSettings, Arrays.asList(localNode));
    }

    public StatusMessages<ValidationStatusMessage> validate(RootConfigurationSettings configSettings, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        RootConfigurationSettings.ConfigMethod configMethod = configSettings.getConfigMethod();
        if (configSettings.isExecuteRootScript()) {
            switch (configMethod) {
                case ROOT: {
                    messages.addAll(this.validateRootPassword(configSettings.getRootPassword(), nodes));
                    break;
                }
                case SUDO: {
                    messages.addAll(this.validateSudoOption(configSettings.getSudoProgramPath(), configSettings.getSudoUserName(), configSettings.getSudoPassword(), nodes));
                    break;
                }
                case PB: {
                    messages.addAll(this.validatePBRunOption(configSettings.getPowerBrokerPath(), configSettings.getPowerBrokerUserName(), configSettings.getPbPassword(), nodes));
                }
            }
        }
        return messages;
    }

    public StatusMessages<ValidationStatusMessage> validateRootPassword(String password, List<String> nodes) {
        ValidationStatusMessage cvuValidationMsg;
        StatusMessages messages = new StatusMessages();
        if (password == null || password.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_CONFIG_ROOT_USER_PASSWORD_EMPTY, new Object[0]));
            return messages;
        }
        boolean isLocalNodeSpecified = false;
        ArrayList<String> remoteNodes = new ArrayList<String>();
        if (nodes != null && !nodes.isEmpty()) {
            for (String node : nodes) {
                if (!MachineInfo.getInstance().isLocalHost(node)) {
                    remoteNodes.add(node);
                    continue;
                }
                isLocalNodeSpecified = true;
            }
        }
        if (isLocalNodeSpecified) {
            String localNode = MachineInfo.getInstance().getLocalMachineName();
            CVUHelper instance = CVUHelper.getInstance();
            if (!instance.checkRootUserPassword(new String[]{localNode}, password)) {
                messages.add((StatusMessage)new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_USER_PASSWORD_INVALID, new Object[0]));
                return messages;
            }
        }
        if (!remoteNodes.isEmpty() && (cvuValidationMsg = this.validateRootUserPassword(password, remoteNodes, false)) != null) {
            messages.add((StatusMessage)cvuValidationMsg);
        }
        return messages;
    }

    public void validateConfigMethod(RootConfigurationSettings rootConfigSettings) throws ValidationException {
        RootConfigurationSettings.ConfigMethod configMethod;
        boolean isExecuteScripts;
        if (rootConfigSettings != null && (isExecuteScripts = rootConfigSettings.isExecuteRootScript()) && (configMethod = rootConfigSettings.getConfigMethod()) == null) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CONFIG_TOOLS_COMMON_NO_ROOT_CONFIG_METHOD, new Object[0]);
        }
    }

    protected ValidationStatusMessage validateRootUserPassword(String password, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkRootUserPassword(nodes.toArray(new String[0]), password)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_USER_PASSWORD_INVALID, new Object[0]);
        }
        return null;
    }

    public StatusMessages<ValidationStatusMessage> validateSudoOption(String sudoLocation, String userName, String password, List<String> nodes) {
        StatusMessages<ValidationStatusMessage> localNodeValidationMsgs;
        StatusMessages messages = new StatusMessages();
        if (sudoLocation == null || sudoLocation.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_LOCATION_EMPTY, new Object[0]));
        }
        if (messages.size() > 0) {
            return messages;
        }
        if (password == null || password.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_CONFIG_PASSWORD_EMPTY, new Object[0]));
        }
        if (messages.size() > 0) {
            return messages;
        }
        if (!sudoLocation.startsWith(File.separator)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_LOCATION_ABSOLUTE_PATH_NOT_SPECIFIED, new Object[]{sudoLocation}));
        }
        if (userName == null || userName.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USER_NAME_EMPTY, new Object[0]));
            return messages;
        }
        boolean isLocalNodeSpecified = false;
        ArrayList<String> remoteNodes = new ArrayList<String>();
        if (nodes != null && !nodes.isEmpty()) {
            for (String node : nodes) {
                if (!MachineInfo.getInstance().isLocalHost(node)) {
                    remoteNodes.add(node);
                    continue;
                }
                isLocalNodeSpecified = true;
            }
        }
        if (isLocalNodeSpecified && !(localNodeValidationMsgs = this.validateSudoOptionOnLocalNode(sudoLocation, userName, password)).isEmpty()) {
            messages.addAll(localNodeValidationMsgs);
            return messages;
        }
        if (!remoteNodes.isEmpty()) {
            messages.addAll(this.validateSudoOptionOnRemoteNodes(sudoLocation, userName, password, remoteNodes));
        }
        return messages;
    }

    protected StatusMessages<ValidationStatusMessage> validateSudoOptionOnLocalNode(String sudoLocation, String userName, String password) {
        StatusMessages messages = new StatusMessages();
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkUserExistenceOnLocalNode(userName)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USERNAME_EXISTANCE_CHECK_ERROR, new Object[]{userName}));
            return messages;
        }
        String localNode = MachineInfo.getInstance().getLocalMachineName();
        List<String> nodeList = Arrays.asList(localNode);
        ValidationStatusMessage cvuValidationMsg = this.validateSudoExistence(sudoLocation, userName, password, nodeList, true);
        if (cvuValidationMsg != null) {
            messages.add((StatusMessage)cvuValidationMsg);
            return messages;
        }
        ValidationStatusMessage validationMsg = this.validateSudoExecution(sudoLocation, userName, password, nodeList, true);
        if (validationMsg != null) {
            messages.add((StatusMessage)validationMsg);
        }
        return messages;
    }

    protected StatusMessages<ValidationStatusMessage> validateSudoOptionOnRemoteNodes(String sudoLocation, String userName, String password, List<String> remoteNodes) {
        StatusMessages messages = new StatusMessages();
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkUserExistance(userName, remoteNodes)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USERNAME_EXISTANCE_CHECK_ERROR, new Object[]{userName}));
            return messages;
        }
        ValidationStatusMessage cvuValidationMsg = this.validateSudoExistence(sudoLocation, userName, password, remoteNodes, false);
        if (cvuValidationMsg != null) {
            messages.add((StatusMessage)cvuValidationMsg);
            return messages;
        }
        ValidationStatusMessage validationMsg = this.validateSudoExecution(sudoLocation, userName, password, remoteNodes, false);
        if (validationMsg != null) {
            messages.add((StatusMessage)validationMsg);
        }
        return messages;
    }

    protected ValidationStatusMessage validateSudoUserExistence(String userName, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkUserExistance(userName, nodes)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_USERNAME_EXISTANCE_CHECK_ERROR, userName);
        }
        return null;
    }

    protected ValidationStatusMessage validateSudoExecution(String sudoLocation, String userName, String password, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkSudoExecution(nodes.toArray(new String[0]), sudoLocation, userName, password)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_EXCECUTION_PERMISSION_ERROR, userName);
        }
        return null;
    }

    protected ValidationStatusMessage validateSudoExistence(String sudoLocation, String userName, String password, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkSudoExistance(nodes.toArray(new String[0]), sudoLocation, userName, password)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.SUDO_CONFIG_DETAILS_INVALID, new Object[0]);
        }
        return null;
    }

    public StatusMessages<ValidationStatusMessage> validatePBRunOption(String pbRunLocation, String userName, String password, List<String> nodes) {
        StatusMessages<ValidationStatusMessage> localNodeValidationMsgs;
        StatusMessages messages = new StatusMessages();
        if (pbRunLocation == null || pbRunLocation.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_LOCATION_EMPTY, new Object[0]));
        }
        if (messages.size() > 0) {
            return messages;
        }
        if (password == null || password.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ROOT_CONFIG_PASSWORD_EMPTY, Severity.WARNING, new Object[]{"Power Broker"}));
            password = "";
        }
        if (!pbRunLocation.startsWith(File.separator)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_LOCATION_ABSOLUTE_PATH_NOT_SPECIFIED, new Object[]{pbRunLocation}));
        }
        if (userName == null || userName.length() == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_USER_NAME_EMPTY, new Object[0]));
            return messages;
        }
        boolean isLocalNodeSpecified = false;
        ArrayList<String> remoteNodes = new ArrayList<String>();
        if (nodes != null && !nodes.isEmpty()) {
            for (String node : nodes) {
                if (!MachineInfo.getInstance().isLocalHost(node)) {
                    remoteNodes.add(node);
                    continue;
                }
                isLocalNodeSpecified = true;
            }
        }
        if (isLocalNodeSpecified && !(localNodeValidationMsgs = this.validatePBRunOptionOnLocalNode(pbRunLocation, userName, password)).isEmpty()) {
            messages.addAll(localNodeValidationMsgs);
        }
        if (!remoteNodes.isEmpty()) {
            messages.addAll(this.validatePBRunOptionOnRemoteNodes(pbRunLocation, userName, password, remoteNodes));
        }
        return messages;
    }

    protected StatusMessages<ValidationStatusMessage> validatePBRunOptionOnRemoteNodes(String pbRunLocation, String userName, String password, List<String> nodes) {
        StatusMessages messages = new StatusMessages();
        ValidationStatusMessage validationMsg = this.validatePBUserExistence(userName, nodes, false);
        if (validationMsg != null) {
            messages.add((StatusMessage)validationMsg);
            return messages;
        }
        ValidationStatusMessage cvuValidationMsg = this.validatePBRunExistence(pbRunLocation, userName, password, nodes, false);
        if (cvuValidationMsg != null) {
            messages.add((StatusMessage)cvuValidationMsg);
            return messages;
        }
        validationMsg = this.validatePBRunExecution(pbRunLocation, userName, password, nodes, false);
        if (validationMsg != null) {
            messages.add((StatusMessage)validationMsg);
        }
        return messages;
    }

    protected StatusMessages<ValidationStatusMessage> validatePBRunOptionOnLocalNode(String pbRunLocation, String userName, String password) {
        CVUHelper instance = CVUHelper.getInstance();
        StatusMessages messages = new StatusMessages();
        if (!instance.checkUserExistenceOnLocalNode(userName)) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_USERNAME_EXISTANCE_CHECK_ERROR, new Object[]{userName}));
            return messages;
        }
        String localNode = MachineInfo.getInstance().getLocalMachineName();
        List<String> nodeList = Arrays.asList(localNode);
        ValidationStatusMessage cvuValidationMsg = this.validatePBRunExistence(pbRunLocation, userName, password, nodeList, true);
        if (cvuValidationMsg != null) {
            messages.add((StatusMessage)cvuValidationMsg);
            return messages;
        }
        ValidationStatusMessage validationMsg = this.validatePBRunExecution(pbRunLocation, userName, password, nodeList, true);
        if (validationMsg != null) {
            messages.add((StatusMessage)validationMsg);
        }
        return messages;
    }

    protected ValidationStatusMessage validatePBRunExecution(String pbRunLocation, String userName, String password, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkPBRunExecution(nodes.toArray(new String[0]), pbRunLocation, userName, password)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_EXCECUTION_PERMISSION_ERROR, userName);
        }
        return null;
    }

    protected ValidationStatusMessage validatePBRunExistence(String pbRunLocation, String userName, String password, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkPBRunExistance(nodes.toArray(new String[0]), pbRunLocation, userName, password)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_CONFIG_DETAILS_INVALID, new Object[0]);
        }
        return null;
    }

    protected ValidationStatusMessage validatePBUserExistence(String userName, List<String> nodes, boolean isLocalNodeValidation) {
        CVUHelper instance = CVUHelper.getInstance();
        if (!instance.checkUserExistance(userName, nodes)) {
            return new CVUValidationStatusMessage((ErrorCode)CommonErrorCode.PBRUN_USERNAME_EXISTANCE_CHECK_ERROR, userName);
        }
        return null;
    }
}

