/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.AbstractActionableStatusMessage;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.ivw.common.validator.ActionableValidationHelper;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.MachineInfo;

public class SSHActionableValidationStatusMessage
extends AbstractActionableStatusMessage<SSHConnectivityDetails, CRSInstallSettings> {
    private static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final Logger logger = Logger.getLogger(SSHActionableValidationStatusMessage.class.getName());

    public SSHActionableValidationStatusMessage(ErrorCode errorCode, Severity severity, SSHConnectivityDetails result, Object ... messageArgs) {
        super(errorCode, severity, (Object)result, messageArgs);
        this.updateExtraDetails(result);
    }

    public SSHActionableValidationStatusMessage(ErrorCode errorCode, SSHConnectivityDetails result, Object ... messageArgs) {
        super(errorCode, (Object)result, messageArgs);
        this.updateExtraDetails(result);
    }

    public SSHActionableValidationStatusMessage(String message, Severity severity, SSHConnectivityDetails result) {
        super(message, severity, (Object)result);
        this.updateExtraDetails(result);
    }

    public SSHActionableValidationStatusMessage(String message, SSHConnectivityDetails result) {
        super(message, (Object)result);
        this.updateExtraDetails(result);
    }

    public SSHActionableValidationStatusMessage(Throwable cause, SSHConnectivityDetails result) {
        super(cause, (Object)result);
        this.updateExtraDetails(result);
    }

    protected void updateExtraDetails(SSHConnectivityDetails result) {
        ErrorInfo errInfo = this.getErrorInfo();
        if (errInfo != null) {
            errInfo.setExtraDetails(this.computeExtraDetails(result));
        }
    }

    protected Content computeExtraDetails(SSHConnectivityDetails result) {
        if (result != null) {
            Set unConfiguredNodes = result.getUnconfiguredNodes();
            String localNode = MachineInfo.getInstance().getLocalMachineName();
            StringBuilder extraDetails = new StringBuilder();
            if (unConfiguredNodes != null && !unConfiguredNodes.isEmpty()) {
                extraDetails.append("<b>" + resource.getString("ErrorMessage.extraDetails.nodeSpecificErrors", "Summary of the failed nodes", new Object[0]) + "</b><br>");
                for (String node : unConfiguredNodes) {
                    if (node.equalsIgnoreCase(localNode)) continue;
                    extraDetails.append("<b>" + node + "</b><br>");
                    StatusMessages messages = result.getStatusMessages(node);
                    for (int i = 0; i < messages.size(); ++i) {
                        String msg = ((StatusMessage)messages.get(i)).getMessage();
                        if (msg == null || msg.length() <= 0) continue;
                        extraDetails.append("&nbsp;-&nbsp;");
                        extraDetails.append(StringUtils.textToHtml((String)msg) + "<br>");
                    }
                }
            }
            PlainContent content = new PlainContent(extraDetails.toString());
            ContentType contentType = ContentType.HTML;
            content.setContentType(contentType);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            return content;
        }
        return null;
    }

    public StatusMessages<ValidationStatusMessage> performAction(CRSInstallSettings bean) {
        SSHConnectivityDetails result;
        logger.entering(SSHActionableValidationStatusMessage.class.getName(), "performAction");
        if (bean != null && (result = (SSHConnectivityDetails)this.getResult()) != null) {
            ArrayList<String> badNodeList = new ArrayList<String>(result.getUnconfiguredNodes());
            ActionableValidationHelper.removeBadNodes(badNodeList, bean);
        }
        logger.exiting(SSHActionableValidationStatusMessage.class.getName(), "performAction");
        return null;
    }
}

