/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.HttpProxySettings;
import oracle.install.ivw.common.bean.MyOracleSupportSettings;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.view.AutoUpdatesOptionsPane;

@ViewDef(id="AutoUpdatesOptionsUI")
public class AutoUpdatesOptionsUI
extends JPanel
implements View {
    private static final long serialVersionUID = 1L;
    AutoUpdatesOptionsPane autoUpdatesOptionsPane;
    private static Logger logger = Logger.getLogger(AutoUpdatesOptionsUI.class.getName());
    private Application app = Application.getInstance();

    public AutoUpdatesOptionsUI() {
        this.autoUpdatesOptionsPane = new AutoUpdatesOptionsPane();
    }

    public Component getView() {
        return this.autoUpdatesOptionsPane;
    }

    public void localize(FlowContext flowContext) {
        if (this.app.getArguments() != null) {
            for (String a : this.app.getArguments()) {
                if (!a.equalsIgnoreCase("-downloadUpdates")) continue;
                Resource resource = this.app.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
                String text = resource.getString("AUTOUPDATES_PROMPT_FOR_UTILITY", "Download software updates for this installation. Software updates consist of recommended updates to the installer system requirement checks, PatchSet Updates (PSUs), and other recommended patches. You can download software updates by providing the following details.", new Object[0]);
                this.autoUpdatesOptionsPane.setPromptMessage(text);
            }
        }
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        if (eventType == EventType.INIT) {
            OracleInstaller installer;
            AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
            this.autoUpdatesOptionsPane.setDownloadType(PatchDownloadType.SKIP_UPDATES);
            if (autoBean != null && (autoBean.getMyoracleSupportDetails() != null || autoBean.getHttpProxySettings() != null || autoBean.getDownloadType() != null)) {
                this.autoUpdatesOptionsPane.setAutoUpdateSettings(autoBean);
            }
            if ((installer = (OracleInstaller)Application.getInstance()) != null && installer.getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
                this.autoUpdatesOptionsPane.setDownloadType(PatchDownloadType.MYORACLESUPPORT_DOWNLOAD);
                this.autoUpdatesOptionsPane.setHideOfflineAndSkipOptions(true);
            }
        }
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
        if (autoBean == null) {
            logger.log(Level.INFO, "AutoUpdates bean is null ");
        }
        autoBean.setDownloadType(this.autoUpdatesOptionsPane.getDownloadType());
        if (this.autoUpdatesOptionsPane.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
            MyOracleSupportSettings myoracleSupportDetails = this.autoUpdatesOptionsPane.getMyOracleSupportDetails();
            autoBean.setMyoracleSupportDetails(myoracleSupportDetails);
            HttpProxySettings proxySettings = this.autoUpdatesOptionsPane.getHttpProxySettings();
            autoBean.setHttpProxySettings(proxySettings);
        } else if (this.autoUpdatesOptionsPane.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
            String downloadLoc = this.autoUpdatesOptionsPane.getPatchDownloadLocation();
            logger.log(Level.INFO, "Pre-downloaded updates location provided : " + downloadLoc);
            autoBean.setPatchDownloadLocation(downloadLoc);
        } else if (this.autoUpdatesOptionsPane.getDownloadType() == PatchDownloadType.SKIP_UPDATES) {
            autoBean.setApplyUpdates(false);
        }
    }
}

