/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.PrivilegedOSGroup;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;

public class PrivilegedOSGroupsPane
extends JPanel {
    private PrivilegedOSGroup[] privilegedOSGroups;
    private String[] osGroups;
    private String title;
    Resource resource = Application.getInstance().getResource(CommonDialogLabelResID.class.getName());
    private MultiLineLabel lblTitle;
    private JPanel pnlGroups;
    private JPanel pnlListenerUser;
    private JLabel lblListnerName;
    private JTextField txtListenerName;
    private MultiLineLabel multiLblListerUser;
    private Map<PrivilegedOSGroup, String> helpIdMap;

    public PrivilegedOSGroupsPane() {
        this.buildUI();
        this.localize();
        this.helpIdMap = new HashMap<PrivilegedOSGroup, String>();
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        this.lblTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.pnlGroups = new JPanel();
        this.pnlGroups.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblTitle, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.pnlGroups, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 0, 0));
        this.pnlListenerUser = this.getListenerUserPanel();
        LayoutUtils.addComponent((Component)this.pnlListenerUser, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(15, 0, 0, 0));
        this.pnlListenerUser.setVisible(false);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)3, (int)1, (int)1, (int)1, (int)11, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
    }

    private JPanel getListenerUserPanel() {
        JPanel listerUserPanel = new JPanel();
        listerUserPanel.setLayout(new GridBagLayout());
        this.lblListnerName = new JLabel();
        this.txtListenerName = new JTextField();
        this.multiLblListerUser = new MultiLineLabel();
        LayoutUtils.addComponent((Component)this.multiLblListerUser, (Container)listerUserPanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblListnerName, (Container)listerUserPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.txtListenerName, (Container)listerUserPanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 15));
        Dimension preferredSize = this.txtListenerName.getPreferredSize();
        preferredSize.width += 170;
        this.txtListenerName.setPreferredSize(preferredSize);
        this.lblListnerName.setLabelFor(this.txtListenerName);
        ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
        activeHelpManager.register((JComponent)this.txtListenerName, "PrivilegedOSGroupsPane.txtListenerName");
        return listerUserPanel;
    }

    private void localize() {
        this.multiLblListerUser.setText(this.resource.getString("PrivilegedOSGroupsPane.multiLblListenerName.text", "User name needs to be specified for the node listener to start on the node.*", new Object[0]));
        this.lblListnerName.setText(this.resource.getString("PrivilegedOSGroupsPane.lblListenerName.text", "Enter the user name for node listener:*", new Object[0]));
    }

    public void associateHelpId(PrivilegedOSGroup priviledgedOSGroup, String helpId) {
        this.helpIdMap.put(priviledgedOSGroup, helpId);
        if (this.pnlGroups.getComponentCount() > 0) {
            Component[] components;
            for (Component component : components = this.pnlGroups.getComponents()) {
                if (!(component instanceof PriviledgedOSGroupComboBox)) continue;
                PriviledgedOSGroupComboBox comboBox = (PriviledgedOSGroupComboBox)component;
                if (comboBox.getPrivilegedOSGroup() != priviledgedOSGroup) break;
                ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
                activeHelpManager.register((JComponent)comboBox, helpId);
                break;
            }
        }
    }

    public String[] getOsGroups() {
        return this.osGroups;
    }

    public void setOsGroups(String[] osGroups) {
        if (osGroups != null) {
            String[] oldValue = this.osGroups;
            this.osGroups = osGroups;
            this.firePropertyChange("PrivilegedOSGroupsPane.osGroups", oldValue, this.osGroups);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
            this.lblTitle.setText(title);
        }
    }

    public PrivilegedOSGroup[] getPrivilegedOSGroups() {
        return this.privilegedOSGroups;
    }

    public void setPrivilegedOSGroups(PrivilegedOSGroup[] osGroups) {
        this.privilegedOSGroups = osGroups;
        if (!this.helpIdMap.isEmpty()) {
            this.helpIdMap.keySet().retainAll(Arrays.asList(osGroups));
        }
        this.layoutGroupsUI();
    }

    public void setListenerUser(String userName) {
        this.txtListenerName.setText(userName);
    }

    public String getListenerUser() {
        return this.txtListenerName.getText();
    }

    private void layoutGroupsUI() {
        if (this.privilegedOSGroups != null) {
            this.pnlGroups.removeAll();
            int gridy = 0;
            for (PrivilegedOSGroup priviledgedOSGroup : this.privilegedOSGroups) {
                PriviledgedOSGroupLabel lblName = new PriviledgedOSGroupLabel(priviledgedOSGroup);
                PriviledgedOSGroupComboBox cbxGroup = new PriviledgedOSGroupComboBox(priviledgedOSGroup, this.osGroups);
                this.addPropertyChangeListener("PrivilegedOSGroupsPane.osGroups", cbxGroup);
                lblName.setLabelFor(cbxGroup);
                String helpId = this.helpIdMap.get((Object)priviledgedOSGroup);
                if (helpId != null) {
                    ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
                    activeHelpManager.register((JComponent)cbxGroup, helpId);
                }
                LayoutUtils.addComponent((Component)lblName, (Container)this.pnlGroups, (int)0, (int)gridy, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
                LayoutUtils.addComponent((Component)cbxGroup, (Container)this.pnlGroups, (int)1, (int)gridy, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 15));
                if (gridy == 0) {
                    cbxGroup.grabFocus();
                }
                ++gridy;
            }
            this.pnlGroups.validate();
            this.validate();
        }
    }

    public void enableListenerUserPane(boolean arg) {
        this.pnlListenerUser.setVisible(arg);
    }

    private static class PriviledgedOSGroupComboBox
    extends JComboBox
    implements ItemListener,
    PropertyChangeListener {
        private PrivilegedOSGroup privilegedOSGroup;
        private DefaultComboBoxModel osGroupsModel;

        public PriviledgedOSGroupComboBox(PrivilegedOSGroup privilegedOSGroup, String[] osGroups) {
            this.privilegedOSGroup = privilegedOSGroup;
            this.addItemListener(this);
            this.osGroupsModel = new DefaultComboBoxModel();
            if (privilegedOSGroup.getPrivilege().isOptional()) {
                this.setEditable(true);
            }
            this.setModel(this.osGroupsModel);
            this.resetOSGroups(osGroups);
        }

        public PrivilegedOSGroup getPrivilegedOSGroup() {
            return this.privilegedOSGroup;
        }

        public void setPrivilegedOSGroup(PrivilegedOSGroup priviledgedOSGroup) {
            this.privilegedOSGroup = priviledgedOSGroup;
        }

        private void resetOSGroups(String[] osGroups) {
            if (osGroups != null) {
                String defaultGroup = this.privilegedOSGroup.getGroupName();
                this.osGroupsModel.removeAllElements();
                for (String group : osGroups) {
                    this.osGroupsModel.addElement(group);
                    if (!group.equalsIgnoreCase(defaultGroup)) continue;
                    this.osGroupsModel.setSelectedItem(group);
                }
                if (this.privilegedOSGroup.getPrivilege().isOptional()) {
                    List<String> osGroupsList = Arrays.asList(osGroups);
                    if (defaultGroup != null && !osGroupsList.contains(defaultGroup)) {
                        this.osGroupsModel.addElement(defaultGroup);
                        this.osGroupsModel.setSelectedItem(defaultGroup);
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.privilegedOSGroup.setGroupName((String)this.getSelectedItem());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("PrivilegedOSGroupPane.osGroups")) {
                this.resetOSGroups((String[])evt.getNewValue());
            }
        }
    }

    private static class PriviledgedOSGroupLabel
    extends JLabel
    implements PropertyChangeListener {
        private PrivilegedOSGroup privilegedOSGroup;

        public PriviledgedOSGroupLabel(PrivilegedOSGroup priviledgedOSGroup) {
            this.privilegedOSGroup = priviledgedOSGroup;
            this.privilegedOSGroup.addPropertyChangeListener(this);
            String text = this.privilegedOSGroup.getDescription();
            SwingUtils.setText((JLabel)this, (String)text);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("PriviledgedOSGroup.description")) {
                this.setText((String)evt.getNewValue());
            }
        }
    }
}

