/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID;
import oracle.install.ivw.common.resource.AutoUpdatesErrorCode;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.autoupdates.DownloadUpdateJob;
import oracle.install.ivw.common.util.autoupdates.DownloadUpdateJobEvent;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesRestartManager;
import oracle.install.ivw.common.view.DownloadUpdateJobListener;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;

public class UpdatesListPane
extends JPanel
implements DownloadUpdateJobListener {
    private JLabel lblDescription;
    private JTable tblUpdatesList;
    private UpdatesModel updatesModel;
    private JCheckBox chxApplyUpdates;
    private String applyUpdatesText;
    private String downloadAndApplyText;
    private String downloadText;
    private String savedDownloadLocation;
    private String[] columnHeader;
    private Logger logger = Logger.getLogger(UpdatesListPane.class.getName());
    private JTextField txtFileLocation;
    private JLabel lblFileLocation;
    private JButton btnBrowse;
    private Resource resource;
    private DownloadUpdateJob downloadJob;
    private DownloadProgressDialog dialog;
    Frame frame = (Frame)SwingUtilities.windowForComponent(this);
    UpdateManager updateManager = UpdateManager.getInstance();
    private JPanel downloadPanel;
    private long totalDownloadSize;
    private JLabel lblDownloadSize;
    private JLabel lblDownloadSizeInfo;
    private PatchDownloadType downloadType = PatchDownloadType.MYORACLESUPPORT_DOWNLOAD;

    public UpdatesListPane() {
        this.buildUI();
    }

    public void update(DownloadUpdateJobEvent e) {
        switch ((DownloadUpdateJobEvent.Type)e.getType()) {
            case JOB_STARTED: {
                this.downloadJob = e.getDownloadUpdateJob();
                this.dialog = new DownloadProgressDialog();
                this.logger.log(Level.FINEST, "UpdatesListPane: Download job has started");
                break;
            }
            case JOB_CANCELLED: {
                this.dialog.dispose();
                this.downloadJob.cancelAllDownloads();
                break;
            }
            case JOB_INTERRUPTED: {
                this.dialog.dispose();
                this.downloadJob.cancelAllDownloads();
                break;
            }
            case JOB_FINISHED: {
                this.dialog.dispose();
                break;
            }
            case STANDALONE_DOWNLOAD_FAILED: {
                Application application2 = Application.getInstance();
                application2.pause(true);
                ErrorInfo err = ErrorInfo.getInstance((ErrorCode)AutoUpdatesErrorCode.UPDATES_DOWNLOAD_FAILED, (Object[])new Object[0]);
                String quitPrompt2 = err.getDescription();
                StandardDialog.showError((Component)this, (String)quitPrompt2);
                break;
            }
            case RESTART_INSTALL: {
                boolean shiphomeUpdateRestart;
                OiiiPatchMetadata opatchBugUpdate;
                int ouiBug = -1;
                int opatchBug = -1;
                OiiiPatchMetadata ouiBugUpdate = this.updateManager.getOUIUpdate();
                if (ouiBugUpdate != null && ouiBugUpdate.getPatchBugNumber() != 0) {
                    ouiBug = ouiBugUpdate.getPatchBugNumber();
                }
                if ((opatchBugUpdate = this.updateManager.getOPatchUpdate()) != null && opatchBugUpdate.getPatchBugNumber() != 0) {
                    opatchBug = opatchBugUpdate.getPatchBugNumber();
                }
                if (!(shiphomeUpdateRestart = this.updateManager.getRestartInstall())) {
                    this.logger.log(Level.FINEST, "No shiphome updates which require restart are found.");
                }
                if (!this.isApplyUpdatesSelected() || !shiphomeUpdateRestart) break;
                Application application = Application.getInstance();
                application.pause(true);
                Resource res = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
                String quitPrompt = res.getString("RESTART_CONFIRMATION", "Some shiphome updates to be applied require a restart of the install.Do you want to restart?", new Object[0]);
                if (!StandardDialog.promptQuestion((Component)this, (String)quitPrompt)) {
                    application.pause(false);
                    break;
                }
                UpdatesRestartManager restartManager = UpdatesRestartManager.getInstance();
                AutoUpdatesInstallSettings autoBean = new AutoUpdatesInstallSettings();
                autoBean.setApplyUpdates(this.applyUpdatesSelected());
                if (this.getPatchDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
                    autoBean.setPatchDownloadLocation(this.savedDownloadLocation);
                } else {
                    autoBean.setPatchDownloadLocation(this.getPatchDownloadLocation());
                }
                autoBean.setDownloadType(this.getPatchDownloadType());
                this.hideUI();
                restartManager.prepareForRestart(autoBean);
                restartManager.restartInstaller(autoBean.getPatchDownloadLocation(), ouiBug, opatchBug);
            }
        }
    }

    public void hideUI() {
        if (Application.isCommandLineSwitchEnabled((String)"-waitForCompletion") && this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().setVisible(false);
        }
    }

    public void setPatchDownloadType(PatchDownloadType e) {
        this.downloadType = e;
    }

    public PatchDownloadType getPatchDownloadType() {
        return this.downloadType;
    }

    public void setListOfPatches(List<OiiiPatchMetadata> patches) {
        this.updatesModel.setPatchesDownloaded(patches);
    }

    public void setPatchDownloadLocation(String location) {
        if (this.txtFileLocation != null) {
            this.txtFileLocation.setText(location);
        }
    }

    public void setStoredDownloadLocation(String savedLocation) {
        this.savedDownloadLocation = savedLocation;
    }

    public void setTotalDownloadSize(long downloadSize) {
        this.totalDownloadSize = downloadSize;
        if (this.lblDownloadSizeInfo != null) {
            String s = Long.toString(downloadSize) + " bytes";
            if (downloadSize > 1024L && downloadSize < 0x100000L) {
                s = Long.toString(downloadSize /= 1024L) + " KB";
            } else if (downloadSize > 0x100000L && downloadSize < 0x40000000L) {
                s = Long.toString(downloadSize /= 0x100000L) + " MB";
            } else if (downloadSize >= 0x40000000L) {
                s = Long.toString(downloadSize /= 0x40000000L) + " GB";
            }
            this.lblDownloadSizeInfo.setText(s);
        }
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public String getPatchDownloadLocation() {
        return this.txtFileLocation.getText();
    }

    public boolean isApplyUpdatesSelected() {
        return this.chxApplyUpdates.isSelected();
    }

    public void setApplyUpdatesSelected(boolean selected) {
        if (this.chxApplyUpdates != null) {
            this.chxApplyUpdates.setSelected(selected);
        }
    }

    public void setApplyUpdatesText(String text) {
        if (text != null && text.length() > 0) {
            SwingUtils.setText((AbstractButton)this.chxApplyUpdates, (String)text);
        }
    }

    public List<OiiiPatchMetadata> getPatchesList() {
        return this.updatesModel.getPatchesList();
    }

    public void buildUI() {
        this.tblUpdatesList = new JTable();
        this.chxApplyUpdates = new JCheckBox();
        this.lblDescription = new JLabel();
        this.lblDownloadSize = new JLabel();
        this.lblDownloadSizeInfo = new JLabel();
        this.lblFileLocation = new JLabel();
        this.txtFileLocation = new JTextField();
        this.btnBrowse = new JButton();
        this.columnHeader = new String[3];
        this.localize();
        this.updatesModel = new UpdatesModel();
        this.tblUpdatesList.setSelectionMode(2);
        this.tblUpdatesList.setModel(this.updatesModel);
        this.tblUpdatesList.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.tblUpdatesList);
        TableColumnModel cmodel = this.tblUpdatesList.getColumnModel();
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        cmodel.getColumn(1).setCellRenderer(textAreaRenderer);
        TextAreaEditor textEditor = new TextAreaEditor();
        cmodel.getColumn(1).setCellEditor(textEditor);
        TableColumn col1 = this.tblUpdatesList.getColumnModel().getColumn(1);
        col1.setPreferredWidth(250);
        TableColumn col2 = this.tblUpdatesList.getColumnModel().getColumn(0);
        col2.setPreferredWidth(25);
        TableColumn col3 = this.tblUpdatesList.getColumnModel().getColumn(2);
        col3.setPreferredWidth(25);
        col3.setCellRenderer(new HyperLinkCellRenderer());
        this.tblUpdatesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 32) {
                    String id_value;
                    JTable tbl = (JTable)e.getComponent();
                    int col = tbl.getSelectedColumn();
                    int row = tbl.getSelectedRow();
                    if (col != 2 || (id_value = (String)tbl.getValueAt(row, col)) == null || !id_value.equalsIgnoreCase("")) {
                        // empty if block
                    }
                }
            }
        });
        this.tblUpdatesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String value;
                JTable table = (JTable)e.getComponent();
                int col = table.columnAtPoint(e.getPoint());
                int row = table.rowAtPoint(e.getPoint());
                if (col != 2 || (value = (String)table.getValueAt(row, col)) == null || !value.equalsIgnoreCase("")) {
                    // empty if block
                }
            }
        });
        this.tblUpdatesList.getTableHeader().setResizingAllowed(false);
        this.tblUpdatesList.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDescription, (Container)this, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)scrollPane, (Container)this, (int)0, (int)1, (int)3, (int)1, (int)1, (int)18, (double)1.0, (double)0.2f);
        LayoutUtils.addComponent((Component)this.lblDownloadSize, (Container)this, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblDownloadSizeInfo, (Container)this, (int)1, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        this.chxApplyUpdates.setSelected(true);
        this.downloadPanel = this.getDownloadLocationPanel();
        TogglePane downloadPane = new TogglePane((JToggleButton)this.chxApplyUpdates, (Component)this.downloadPanel);
        downloadPane.setContentDisabledOnDeselect(true);
        LayoutUtils.addComponent((Component)downloadPane, (Container)this, (int)0, (int)4, (int)3, (int)1, (int)1, (int)18, (double)1.0, (double)0.0);
        this.updateManager.addDownloadUpdateJobListener(this);
        ActiveHelpManager.registerComponent((JComponent)this.chxApplyUpdates, (String)"UpdatesListPane.chxApplyUpdates");
        ActiveHelpManager.registerComponent((JComponent)this.txtFileLocation, (String)"UpdatesListPane.txtDownloadLocation");
    }

    public void setShowDownloadLocationPanel(boolean flag, boolean standAlone) {
        if (this.downloadPanel != null) {
            this.downloadPanel.setVisible(flag);
        }
        if (this.lblDownloadSizeInfo != null && this.lblDownloadSize != null) {
            this.lblDownloadSizeInfo.setVisible(flag);
            this.lblDownloadSize.setVisible(flag);
        }
        if (flag && !standAlone) {
            this.setApplyUpdatesText(this.downloadAndApplyText);
        } else if (flag && standAlone) {
            this.setApplyUpdatesText(this.downloadText);
        } else {
            this.setApplyUpdatesText(this.applyUpdatesText);
        }
    }

    private JPanel getDownloadLocationPanel() {
        JPanel downloadLocPanel = new JPanel();
        downloadLocPanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblFileLocation, (Container)downloadLocPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtFileLocation, (Container)downloadLocPanel, (int)1, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.btnBrowse, (Container)downloadLocPanel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0);
        final UpdatesListPane rootPanel = this;
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                JFileChooser filechooser = new JFileChooser();
                filechooser.setFileSelectionMode(1);
                String title = UpdatesListPane.this.resource.getString("OFFLINEMODE_BROWSE_PROMPT1", "Select Location", new Object[0]);
                String btnText = UpdatesListPane.this.resource.getString("OFFLINEMODE_BROWSE_PROMPT2", "Select", new Object[0]);
                filechooser.setDialogTitle(title);
                filechooser.setApproveButtonText(btnText);
                if (UpdatesListPane.this.txtFileLocation.getText() != null && !UpdatesListPane.this.txtFileLocation.getText().equals("")) {
                    filechooser.setCurrentDirectory(new File(UpdatesListPane.this.txtFileLocation.getText()));
                }
                if ((returnVal = filechooser.showOpenDialog(rootPanel)) == 0) {
                    UpdatesListPane.this.txtFileLocation.setText(filechooser.getSelectedFile().getPath());
                }
            }
        });
        return downloadLocPanel;
    }

    public void localize() {
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        String text = this.resource.getString("AUTOUPDATES_DOWNLOAD_PROMPT", "The following updates are available:", new Object[0]);
        this.lblDescription.setText(text);
        this.columnHeader[0] = this.resource.getString("UPDATES_LIST_COLUMN1", "Patch Number", new Object[0]);
        this.columnHeader[1] = this.resource.getString("UPDATES_LIST_COLUMN2", "Description", new Object[0]);
        this.columnHeader[2] = this.resource.getString("UPDATES_LIST_COLUMN3", "Related Notes", new Object[0]);
        text = this.resource.getString("OFFLINEMODE_BROWSE", "B&rowse...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowse, (String)text);
        text = this.resource.getString("DOWNLOAD_LOC_LABEL", "Downlo&ad location: ", new Object[0]);
        SwingUtils.setText((JLabel)this.lblFileLocation, (String)text);
        this.lblFileLocation.setLabelFor(this.txtFileLocation);
        text = this.resource.getString("DOWNLOAD_SIZE_LABEL", "Total Download Size: ", new Object[0]);
        SwingUtils.setText((JLabel)this.lblDownloadSize, (String)text);
        text = this.resource.getString("OFFLINEMODE_BROWSE", "B&rowse...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowse, (String)text);
        this.applyUpdatesText = text = this.resource.getString("AUTOUPDATES_APPLY_OPTION", "Apply all &updates", new Object[0]);
        this.downloadAndApplyText = text = this.resource.getString("AUTOUPDATES_DOWNLOAD_AND_APPLY_OPTION", "Download and apply all &updates", new Object[0]);
        this.downloadText = text = this.resource.getString("AUTOUPDATES_DOWNLOAD_OPTION", "Download all &updates", new Object[0]);
    }

    public boolean applyUpdatesSelected() {
        boolean apply = false;
        if (this.chxApplyUpdates != null) {
            apply = this.chxApplyUpdates.isSelected();
        }
        this.logger.log(Level.INFO, "Applyupdates selected from UpdatesListPane: " + apply);
        return apply;
    }

    class DownloadProgressDialog
    extends JDialog
    implements ActionListener {
        ProgressMonitor pbar = new ProgressMonitor(this, null, "Connecting...", 0, 100);
        long counter = 0L;
        Timer timer;
        long percentageDownload = 0L;
        long previousPercentDwld = 0L;
        Application app = Application.getInstance();
        Resource resource = this.app.getResource(AutoUpdatesDialogLabelResID.class.getName());

        public DownloadProgressDialog() {
            String progress = this.resource.getString("ProgressMonitor.progressText", "Downloading updates*...", new Object[0]);
            UIManager.put(progress, "Downloading updates*...");
            this.pbar.setMillisToDecideToPopup(0);
            this.pbar.setMillisToPopup(0);
            this.pbar.setProgress(0);
            this.setModal(true);
            this.timer = new Timer(100, this);
            this.timer.start();
            this.timer.setInitialDelay(0);
            this.setAlwaysOnTop(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.runUpdates();
        }

        public void runUpdates() {
            if (this.pbar != null && this.pbar.isCanceled()) {
                this.pbar.close();
                if (UpdatesListPane.this.downloadJob != null) {
                    UpdatesListPane.this.downloadJob.cancelAllDownloads();
                }
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
            }
            if (UpdatesListPane.this.downloadJob.getStatus() != Status.INPROGRESS && this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
                this.pbar.close();
            }
            if (UpdatesListPane.this.downloadJob != null && UpdatesListPane.this.downloadJob.getStatus() == Status.INPROGRESS) {
                this.counter = UpdatesListPane.this.downloadJob.getBytesDownloaded();
                String dwldMsg = this.resource.getString("DOWNLOAD_PROGRESS", "Downloaded", new Object[0]);
                if (this.counter != 0L) {
                    this.percentageDownload = this.counter * 100L / UpdatesListPane.this.totalDownloadSize;
                    this.pbar.setNote(dwldMsg + " " + this.percentageDownload + " %");
                    this.pbar.setProgress((int)this.percentageDownload);
                    if (this.percentageDownload - this.previousPercentDwld == 5L) {
                        UpdatesListPane.this.logger.log(Level.INFO, "DOWNLOADPROGRESSDIALOG.. Downloaded " + this.counter + " bytes");
                        UpdatesListPane.this.logger.log(Level.INFO, "PROGRESSDIALOG.. setting to " + this.percentageDownload + "%");
                        this.previousPercentDwld = this.percentageDownload;
                    }
                }
            }
        }
    }

    class HyperLinkCellRenderer
    extends DefaultTableCellRenderer {
        HyperLinkCellRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value != null) {
                if (value != null && !value.toString().equalsIgnoreCase("")) {
                    String link = "<html><a href=\"x\">" + value.toString() + "</a></html>";
                    this.setText(link);
                } else {
                    this.setText(value.toString());
                }
            }
        }
    }

    class TextAreaEditor
    extends DefaultCellEditor {
        public TextAreaEditor() {
            super(new JTextField());
            final JTextArea textArea = new JTextArea();
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setBorder(null);
            this.editorComponent = scrollPane;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    textArea.setText(value != null ? value.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return textArea.getText();
                }
            };
        }
    }

    class TextAreaRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private final Map cellSizes = new HashMap();
        private JTextArea textArea = new JTextArea();

        public TextAreaRenderer() {
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.textArea.setForeground(component.getForeground());
            this.textArea.setBackground(component.getBackground());
            this.textArea.setFont(component.getFont());
            if (component instanceof JComponent) {
                JComponent c = (JComponent)component;
                this.textArea.setBorder(c.getBorder());
            }
            if (value instanceof String) {
                this.textArea.setText((String)value);
            }
            TableColumnModel columnModel = table.getColumnModel();
            this.textArea.setSize(columnModel.getColumn(column).getWidth(), table.getRowHeight(row));
            int height_wanted = (int)this.textArea.getPreferredSize().getHeight();
            this.addSize(table, row, column, height_wanted);
            height_wanted = this.findTotalMaximumRowSize(table, row, column);
            if (height_wanted != table.getRowHeight(row)) {
                table.setRowHeight(row, height_wanted);
            }
            return this.textArea;
        }

        private void addSize(JTable table, int row, int column, int height) {
            HashMap<Integer, Integer> rowheights;
            HashMap<Integer, HashMap<Integer, Integer>> rows = (HashMap<Integer, HashMap<Integer, Integer>>)this.cellSizes.get(table);
            if (rows == null) {
                rows = new HashMap<Integer, HashMap<Integer, Integer>>();
                this.cellSizes.put(table, rows);
            }
            if ((rowheights = (HashMap<Integer, Integer>)rows.get(new Integer(row))) == null) {
                rowheights = new HashMap<Integer, Integer>();
                rows.put(new Integer(row), rowheights);
            }
            rowheights.put(new Integer(column), new Integer(height));
        }

        private int findTotalMaximumRowSize(JTable table, int row, int column) {
            int maximum_height = 0;
            TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
            if (cellRenderer instanceof TextAreaRenderer) {
                TextAreaRenderer tar = (TextAreaRenderer)cellRenderer;
                maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
            }
            return maximum_height;
        }

        private int findMaximumRowSize(JTable table, int row) {
            Map rows = (Map)this.cellSizes.get(table);
            if (rows == null) {
                return 0;
            }
            Map rowheights = (Map)rows.get(new Integer(row));
            if (rowheights == null) {
                return 0;
            }
            int maximum_height = 0;
            for (Map.Entry entry : rowheights.entrySet()) {
                int cellHeight = (Integer)entry.getValue();
                maximum_height = Math.max(maximum_height, cellHeight);
            }
            return maximum_height;
        }
    }

    private class UpdatesModel
    extends AbstractTableModel {
        List<OiiiPatchMetadata> patches;
        private String[] columnNames;

        private UpdatesModel() {
            this.columnNames = UpdatesListPane.this.columnHeader;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            return this.getPatchesList().size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object value = null;
            switch (col) {
                case 0: {
                    value = this.patches.get(row).getPatchBugNumber();
                    break;
                }
                case 1: {
                    value = this.patches.get(row).getDesc();
                    break;
                }
                case 2: {
                    value = this.patches.get(row).getmetalink_node_id();
                }
            }
            return value;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value != null) {
                switch (col) {
                    case 0: {
                        OiiiPatchMetadata p = this.patches.get(row);
                        if (value != null) {
                            p.setPatchBugNumber(Integer.parseInt(value.toString()));
                        }
                        this.patches.set(row, p);
                        this.fireTableCellUpdated(row, col);
                        break;
                    }
                    case 1: {
                        OiiiPatchMetadata p = this.patches.get(row);
                        if (value != null) {
                            p.setDesc(value.toString());
                        }
                        this.patches.set(row, p);
                        this.fireTableCellUpdated(row, col);
                        break;
                    }
                    case 2: {
                        OiiiPatchMetadata p = this.patches.get(row);
                        if (value != null) {
                            p.setmetalink_node_id(value.toString());
                        }
                        this.patches.set(row, p);
                        this.fireTableCellUpdated(row, col);
                    }
                }
            }
        }

        public void setPatchesDownloaded(List<OiiiPatchMetadata> values) {
            if (values != null) {
                this.patches = new ArrayList<OiiiPatchMetadata>();
                for (OiiiPatchMetadata p : values) {
                    if (p.getmetalink_node_id() == null || p.getmetalink_node_id().length() == 0) {
                        p.setmetalink_node_id("");
                    }
                    this.patches.add(p);
                }
            }
        }

        public List<OiiiPatchMetadata> getPatchesList() {
            List<OiiiPatchMetadata> patchesList = new ArrayList<OiiiPatchMetadata>();
            if (this.patches != null) {
                patchesList = this.patches;
            }
            return patchesList;
        }
    }
}

