/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.util.logging.Logger;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.view.WindowsSecureOptionPane;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallHelper;

@ViewDef(id="WindowsSecureOptionUI")
public class WindowsSecureOptionUI
implements View,
CompositeValidator {
    private Logger logger = Logger.getLogger(WindowsSecureOptionUI.class.getName());
    private StatusMessages<ValidationStatusMessage> messages;
    WindowsSecureOptionPane view;

    public WindowsSecureOptionUI() {
        this.logger.info("Entering WindowsSecureOptionUI...");
        this.view = new WindowsSecureOptionPane();
        this.controlDeclineOption();
        this.messages = new StatusMessages();
    }

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
    }

    public void validate(FlowContext arg0) throws ValidationException {
        String existingUserName = this.view.getExistingUserName().trim();
        String newUserName = this.view.getNewUserName().trim();
        String password = this.view.getNewUserPassword().trim();
        String confirmPassword = this.view.getConfirmPassword().trim();
        if (!this.view.isDeclineSecureOption()) {
            if (this.view.isExistingUser() && (existingUserName == null || existingUserName.trim().length() == 0)) {
                throw new ValidationException((ErrorCode)CommonErrorCode.USER_NAME_EMPTY, new Object[]{"User name is empty."});
            }
            if (this.view.isNewUser()) {
                if (newUserName == null || newUserName.trim().length() == 0) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.USER_NAME_EMPTY, new Object[]{"User name is empty."});
                }
                if (GenericValidation.validateForEmptiness(password) && GenericValidation.validateForEmptiness(confirmPassword) && !password.equalsIgnoreCase(confirmPassword)) {
                    throw new ValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[0]);
                }
                if (!password.equals(confirmPassword)) {
                    throw new ValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[0]);
                }
            }
        }
    }

    public void onEvent(FlowContext arg0, EventType arg1) {
    }

    public void processInput(FlowContext flowContext) throws UncheckedValidationException {
        WindowsSecureOptionSettings bean = (WindowsSecureOptionSettings)((Object)flowContext.getBean(WindowsSecureOptionSettings.class));
        String existingUserPassword = this.view.getExistingUserPassword();
        String newUserPassword = this.view.getNewUserPassword();
        boolean declineSecureOption = this.view.isDeclineSecureOption();
        bean.setPasswordRequired("0");
        if (!this.view.isDeclineSecureOption()) {
            if (this.view.isExistingUser()) {
                bean.setUserName(this.view.getExistingUserName());
                bean.setExistingUser(true);
                if (existingUserPassword != null) {
                    bean.setPassword(existingUserPassword);
                }
            }
            if (this.view.isNewUser()) {
                bean.setUserName(this.view.getNewUserName());
                bean.setExistingUser(false);
                if (newUserPassword != null) {
                    bean.setPassword(newUserPassword);
                }
            }
        }
        bean.setDeclineOption(declineSecureOption);
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public void controlDeclineOption() {
        String chkBox = InstallHelper.getValue("oracle.install.IsBuiltInAccount");
        if (chkBox == null) {
            String topLevelComponent = Application.getInstance().getString("product.name", null, new Object[0]);
            if (topLevelComponent != null) {
                if (topLevelComponent.equalsIgnoreCase("db")) {
                    this.view.chkBoxDeclineSecureOption.setSelected(false);
                } else if (topLevelComponent.equalsIgnoreCase("client")) {
                    this.view.chkBoxDeclineSecureOption.setSelected(true);
                }
            }
        } else if (chkBox.equalsIgnoreCase("true")) {
            this.view.chkBoxDeclineSecureOption.setSelected(true);
        } else {
            this.view.chkBoxDeclineSecureOption.setSelected(false);
        }
    }
}

