/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.crs;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.DiskSpaceFlags;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.deployment.BigClusterException;
import oracle.cluster.deployment.ClientClusterInfo;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.impl.deployment.BigClusterImpl;
import oracle.cluster.server.Site;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.commons.system.process.DefaultLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.database.ConfigurationException;

public class CRSInfo {
    private Logger logger = Logger.getLogger(CRSInfo.class.getName());
    private String crsVersion;
    private HashMap<String, NodeRole> activeRoleNodeMap = null;
    private HashMap<String, NodeRole> configRoleNodeMap = null;
    private static CRSInfo instance = null;
    private String localNodeName;
    public static final char sep = File.separatorChar;
    String clusterName;
    String scanName;
    private ClusterwareInfo clusterwareInfo = null;
    public static final String OIFCFG_SUBDIR = "ext" + File.separator + "bin";
    Boolean isConfiguredGIHomePresent = null;
    private ClusterConfig clusterConfig;
    private String configuredCRSHome = null;
    private BigClusterImpl bigClusterImpl;
    public static final String executablePath = "bin";
    public static final String diskUsage = "du";
    public static final String suppressHeaderFlag = "--suppressheader";
    public static final String asmcmdUtility = File.separator + "bin" + File.separator;
    private PlainContent afdResultExtraDetails = null;
    private HashMap<String, HashMap<String, String>> adminGroups;
    private static final String CLASS_NAME = CRSInfo.class.getName();

    public PlainContent getAfdResultExtraDetails() {
        return this.afdResultExtraDetails;
    }

    public void setAfdResultExtraDetails(PlainContent afdResultExtraDetails) {
        this.afdResultExtraDetails = afdResultExtraDetails;
    }

    public void initClusterwareInfo() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
    }

    public static CRSInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (CRSInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(CRSInfo.class)) == null) {
            instance = new CRSInfo();
        }
        return instance;
    }

    public String getDefaultClusterName() {
        String strDefCRSName = this.getClusterPrefix();
        if (strDefCRSName.length() > 0) {
            strDefCRSName = strDefCRSName + "-";
        }
        return strDefCRSName + "cluster";
    }

    public String getClusterPrefix() {
        StringBuffer prefix = new StringBuffer("");
        MachineInfo mInfo = MachineInfo.getInstance();
        String hostWithoutDomain = mInfo.getLocalMachineName();
        if (hostWithoutDomain != null && hostWithoutDomain.trim().length() > 0) {
            prefix = new StringBuffer(hostWithoutDomain);
            String regEx = "[0-9]";
            boolean hasNumericSuffix = true;
            while (hasNumericSuffix && prefix.length() > 0) {
                String lastChar = prefix.substring(prefix.length() - 1);
                hasNumericSuffix = lastChar.matches(regEx);
                if (!hasNumericSuffix) continue;
                prefix.deleteCharAt(prefix.length() - 1);
            }
            if (prefix.length() > 7) {
                prefix = new StringBuffer(prefix.substring(0, 7));
            }
        }
        return prefix.toString();
    }

    public String getCRSHome() {
        if (this.configuredCRSHome == null || this.configuredCRSHome.length() == 0) {
            List<String> pre112CRSHomes = null;
            String crsHome = "";
            InventoryInfo invInfo = InventoryInfo.getInstance();
            boolean isCRSConfigured = false;
            boolean isHAConfigured = false;
            try {
                isCRSConfigured = this.isCRSConfigured();
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Could not determine if a CRS is configured.", e);
            }
            if (!isCRSConfigured) {
                try {
                    isHAConfigured = this.isHAConfigured();
                }
                catch (oracle.cluster.install.InstallException e) {
                    this.logger.log(Level.INFO, "Could not determine if a HA is configured.", e);
                }
            }
            if (isCRSConfigured || isHAConfigured) {
                this.initClusterwareInfo();
                try {
                    crsHome = this.clusterwareInfo.getCRSHome(new oracle.ops.mgmt.cluster.Version());
                }
                catch (oracle.cluster.install.InstallException e) {
                    this.logger.log(Level.WARNING, "Failed to execute getcrshome", e);
                }
                if (crsHome != null && crsHome.length() > 0) {
                    this.configuredCRSHome = crsHome;
                    this.logger.info(CLASS_NAME + ".getCRSHome() returns : " + crsHome);
                    return crsHome;
                }
            }
            try {
                pre112CRSHomes = invInfo.getListOfOH("oracle.crs", "10.1.0.0.0", "11.1.9.9.9");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (pre112CRSHomes != null && pre112CRSHomes.size() > 0) {
                crsHome = pre112CRSHomes.get(0);
            }
            this.configuredCRSHome = crsHome;
        }
        return this.configuredCRSHome;
    }

    public String[] getNodesFromCRSstack() {
        String[] clusterNodes;
        block10: {
            clusterNodes = null;
            try {
                String crsHome;
                if (!this.isCRSConfigured() || (crsHome = this.getCRSHome()) == null || crsHome.isEmpty()) break block10;
                ClusterInfo clusterInfo = null;
                try {
                    clusterInfo = new ClusterInfo(crsHome);
                }
                catch (NoSuchCRSHomeException e) {
                    this.logger.log(Level.INFO, "NoSuchCRSHomeException while checking for node names from stack", e);
                }
                catch (NoSuchExecutableException e) {
                    this.logger.log(Level.INFO, "NoSuchExecutableException while checking for node names from stack", e);
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "ClusterInfoException while checking for node names from stack", e);
                }
                if (clusterInfo == null) break block10;
                String[] nodeNames = null;
                try {
                    nodeNames = clusterInfo.getNodeNames();
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "ClusterInfoException while checking for node names from stack", e);
                }
                if (nodeNames != null && nodeNames.length > 0) {
                    ArrayList<String> nodelist = new ArrayList<String>(Arrays.asList(nodeNames));
                    LinkedHashSet<String> nodeSet = new LinkedHashSet<String>(nodelist);
                    nodelist.clear();
                    nodelist.addAll(nodeSet);
                    String localNode = this.getLocalNodeName();
                    if (nodelist.indexOf(localNode) > 0) {
                        Collections.swap(nodelist, 0, nodelist.indexOf(localNode));
                    }
                    this.logger.info(CLASS_NAME + ".getNodesFromCRSStack() returns the nodelist : " + nodelist);
                    clusterNodes = nodelist.toArray(new String[0]);
                }
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
            }
        }
        return clusterNodes;
    }

    public String getCRSActiveVersion() {
        String activeCRSVersion;
        block8: {
            activeCRSVersion = "";
            try {
                if (!this.isCRSConfigured()) break block8;
                ClusterInfo cInfo = null;
                try {
                    cInfo = new ClusterInfo(this.getCRSHome());
                    try {
                        activeCRSVersion = cInfo.getCRSActiveVersionString();
                    }
                    catch (ClusterInfoException e) {
                        this.logger.log(Level.WARNING, ((Object)((Object)e)).getClass().getName() + " while retrieving Active CRS version", e);
                    }
                }
                catch (NoSuchCRSHomeException e) {
                    this.logger.log(Level.WARNING, ((Object)((Object)e)).getClass().getName() + " while retrieving Active CRS version", e);
                }
                catch (NoSuchExecutableException e) {
                    this.logger.log(Level.WARNING, ((Object)((Object)e)).getClass().getName() + " while retrieving Active CRS version", e);
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.WARNING, ((Object)((Object)e)).getClass().getName() + " while retrieving Active CRS version", e);
                }
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
            }
        }
        this.logger.info(CLASS_NAME + ".getCRSActiveVersion() returns :" + activeCRSVersion);
        return activeCRSVersion;
    }

    public String getCRSHomeName() {
        return "";
    }

    public String getClusterName() {
        try {
            if (this.clusterName == null && this.isCRSConfigured()) {
                this.initClusterwareInfo();
                this.clusterName = this.clusterwareInfo.getClusterName(this.getCRSHome());
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while detecting the crs is configured", e);
        }
        this.logger.info(CLASS_NAME + ".getClusterName() returns :" + this.clusterName);
        return this.clusterName;
    }

    public String getScanName() {
        try {
            if (this.scanName == null && this.isCRSConfigured()) {
                this.initClusterwareInfo();
                this.scanName = this.clusterwareInfo.getScanName();
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while retrieving scan name", e);
        }
        this.logger.info(CLASS_NAME + ".getScanName() returns :" + this.scanName);
        return this.scanName;
    }

    public boolean isCRsActive() {
        return false;
    }

    public String[] getNetworkInterfaces() {
        String oifcfgPath = InstallHelper.getInstallBinariesPath();
        ArrayList<String> interfaceList = new ArrayList<String>();
        List results = null;
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        try {
            results = clusterwareInfo.listInterfaces(oifcfgPath, true);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while getting the interface list from the local node", e);
        }
        if (results != null) {
            for (OIFCFGResult res : results) {
                String interfaceName = res.getInterfaceName();
                String subnet = res.getSubnet().getHostAddress();
                OifcfgMapping type = OifcfgMapping.valueOf(res.getInterfaceType().toUpperCase());
                String netmask = res.getSubnetMaskAsString();
                String interfaceStr = interfaceName + "/" + subnet + "/" + type.getValue() + "/" + netmask;
                interfaceList.add(interfaceStr);
            }
        }
        this.logger.info(CLASS_NAME + ".getNetworkInterfaces() returns :" + interfaceList);
        return interfaceList.toArray(new String[0]);
    }

    public String getDefaultNodeList() {
        return "";
    }

    public String getLocalNodeName() {
        try {
            if (this.localNodeName == null && this.isCRSConfigured()) {
                try {
                    ClusterInfo clusterInfo = new ClusterInfo(this.getCRSHome());
                    this.localNodeName = clusterInfo.getLocalNodeName();
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "Exception while getting the local node name from crs stack", e);
                }
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        this.logger.info(CLASS_NAME + ".getLocalNodeName() returns : " + this.localNodeName);
        return this.localNodeName;
    }

    public String getCRSVersion() {
        try {
            if (this.crsVersion == null && this.isCRSConfigured()) {
                try {
                    ClusterInfo clusterInfo = new ClusterInfo(this.getCRSHome());
                    this.crsVersion = clusterInfo.getCRSActiveVersionString();
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "Exception while getting the active version from crs stack", e);
                }
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        this.logger.info(CLASS_NAME + ".getCRSVersion() returns : " + this.crsVersion);
        return this.crsVersion;
    }

    /*
     * Unable to fully structure code
     */
    public List<String> getRemoteNodes() {
        nodeList = new ArrayList<String>();
        if (this.getCRSHome() != null) {
            if (this.isFlexCluster()) {
                this.initClusterwareInfo();
                try {
                    nodeNames = this.clusterwareInfo.getClusterNodeActiveRoles(this.getCRSHome()).keySet();
                    if (nodeNames.size() <= 0) ** GOTO lbl39
                    clusterInfo = new ClusterInfo(this.getCRSHome());
                    for (String node : nodeNames) {
                        if (node.equals(clusterInfo.getLocalNodeName())) continue;
                        nodeList.add(node);
                    }
                }
                catch (oracle.cluster.install.InstallException e) {
                    this.logger.log(Level.INFO, "Exception while getting node name and their active node roles in the cluster", e);
                }
                catch (NoSuchCRSHomeException e) {
                    this.logger.log(Level.INFO, "NoSuchCRSHomeException while checking for node names from stack", e);
                }
                catch (NoSuchExecutableException e) {
                    this.logger.log(Level.INFO, "NoSuchExecutableException while checking for node names from stack", e);
                }
                catch (ClusterInfoException e) {
                    this.logger.log(Level.INFO, "ClusterInfoException while checking for node names from stack", e);
                }
            } else {
                try {
                    clusterInfo = new ClusterInfo(this.getCRSHome());
                    nodeNames = clusterInfo.getNodeNames();
                    if (nodeNames != null && nodeNames.length > 0) {
                        for (String node : nodeNames) {
                            if (node.equals(clusterInfo.getLocalNodeName())) continue;
                            nodeList.add(node);
                        }
                    }
                }
                catch (Exception var2_8) {
                    // empty catch block
                }
            }
        }
lbl39:
        // 10 sources

        this.logger.info(CRSInfo.CLASS_NAME + ".getRemoteNodes() returns the remote nodes as :" + nodeList);
        return nodeList;
    }

    public String getDefaultGNSDomain() {
        String gnsDomain = null;
        String prefix = this.getClusterPrefix();
        String domain = MachineInfo.getInstance().getDomainName();
        gnsDomain = prefix + "." + domain;
        this.logger.info(CLASS_NAME + ".getDefaultGNSDomain() returns the gns domain as :" + gnsDomain);
        return gnsDomain;
    }

    public String getDefaultIPAddressForGNSVIP() {
        String defaultIP;
        block12: {
            defaultIP = null;
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            String oifcfgPath = scratchPath + File.separator + OIFCFG_SUBDIR;
            NetworkInterface oInterface = null;
            List results = null;
            try {
                oInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(MachineInfo.getInstance().getFullHostName()));
            }
            catch (SocketException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            try {
                ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                results = clusterwareInfo.listInterfaces(MachineInfo.getInstance().getFullHostName(), oifcfgPath, true);
                if (oInterface != null && results != null && results.size() > 0) {
                    for (OIFCFGResult res : results) {
                        StringTokenizer tokenizer;
                        int numOfTokens;
                        if (!oInterface.getName().equals(res.getInterfaceName())) continue;
                        InetAddress subnet = res.getSubnet();
                        if (!(subnet instanceof Inet4Address) || (numOfTokens = (tokenizer = new StringTokenizer(defaultIP = subnet.getHostAddress(), ".")).countTokens()) != 4) break block12;
                        String[] tokens = new String[numOfTokens];
                        int tokenIndex = 0;
                        while (tokenizer.hasMoreElements()) {
                            tokens[tokenIndex++] = tokenizer.nextToken();
                        }
                        String lastField = tokens[numOfTokens - 1];
                        try {
                            int last = Integer.parseInt(lastField);
                            tokens[numOfTokens - 1] = Integer.toString(++last);
                        }
                        catch (NumberFormatException e) {
                            this.logger.log(Level.INFO, "Error while defaulting the GNS VIP");
                        }
                        defaultIP = "";
                        for (String s : tokens) {
                            defaultIP = defaultIP + s + ".";
                        }
                        defaultIP = defaultIP.substring(0, defaultIP.length() - 1);
                        break block12;
                    }
                    break block12;
                }
                if (oInterface == null) {
                    this.logger.log(Level.WARNING, "NetworkInterface object is null");
                }
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.WARNING, "The defaulting of GNS VIP failed.", e);
            }
        }
        this.logger.info(CLASS_NAME + ".getDefaultIPAddressForGNSVIP() returns the default IP as :" + defaultIP);
        return defaultIP;
    }

    public HashMap<String, String> getAdminGroups(String crsHome) {
        HashMap<String, String> groups;
        if (crsHome != null && this.adminGroups != null && (groups = this.adminGroups.get(crsHome)) != null) {
            this.logger.log(Level.INFO, "Retrieving admin groups from cache: " + groups);
            return groups;
        }
        this.logger.log(Level.INFO, "Determining admin groups for crs home: " + crsHome);
        this.initClusterwareInfo();
        HashMap groupOutput = new HashMap();
        try {
            String osdbagrpUtilPath = new File(crsHome, executablePath).getAbsolutePath();
            oracle.ops.mgmt.cluster.Version version = this.clusterwareInfo.getSRVCTLVersion(crsHome);
            groupOutput = this.clusterwareInfo.getAdminGroups(osdbagrpUtilPath, version);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.warning(((Object)((Object)e)).getClass().getName() + " thrown while retrieving Admin groups" + (Object)((Object)e));
        }
        this.logger.info(CLASS_NAME + ".getAdminGroups() returns the following Adming Groups : " + groupOutput);
        if (groupOutput != null) {
            if (this.adminGroups == null) {
                this.adminGroups = new HashMap();
            }
            this.logger.log(Level.INFO, "Saving admin groups in cache: " + groupOutput);
            this.adminGroups.put(crsHome, groupOutput);
        }
        return groupOutput;
    }

    public List<String> getHAManagedDatabases(String crsHomeLoc) {
        this.initClusterwareInfo();
        ArrayList<String> HAManagedDBList = new ArrayList();
        try {
            HAManagedDBList = this.clusterwareInfo.getHAManagedDatabases(crsHomeLoc);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.warning(((Object)((Object)e)).getClass().getName() + " thrown while retrieving Admin groups" + (Object)((Object)e));
        }
        this.logger.info(CLASS_NAME + ".getHAManagedDatabases() returns the list of HA managed databases : " + HAManagedDBList);
        return HAManagedDBList;
    }

    public boolean doesDatabaseExistsOnNode(String crsHoome, String node, String db) throws oracle.cluster.install.InstallException {
        boolean isDBExists = false;
        this.initClusterwareInfo();
        isDBExists = this.clusterwareInfo.isDatabaseExists(crsHoome, node, db);
        this.logger.info(CLASS_NAME + ".doesDatabaseExistsOnNode() returns that database " + db + " exists on node " + node + " :" + isDBExists);
        return isDBExists;
    }

    public String getActualHostName(String node) {
        String hostname = "";
        oracle.ops.mgmt.cluster.Version version = new oracle.ops.mgmt.cluster.Version();
        try {
            hostname = ClusterInfo.getHostName((String)node, (oracle.ops.mgmt.cluster.Version)version);
        }
        catch (ClusterInfoException e) {
            this.logger.info("Failed while retrieving the hostname for the nodes");
        }
        this.logger.info(CLASS_NAME + ".getActualHostname() returns " + hostname);
        return hostname;
    }

    public boolean isConfiguredGIHomePresent() {
        if (this.isConfiguredGIHomePresent == null) {
            this.isConfiguredGIHomePresent = new Boolean(false);
            ClusterwareInfo clusterInfo = new ClusterwareInfo();
            try {
                if (clusterInfo.isHAConfigured() || clusterInfo.isCRSConfigured()) {
                    Version version = InventoryInfo.getInstance().getProductVersion(this.getCRSHome());
                    this.isConfiguredGIHomePresent = version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0 ? new Boolean(true) : new Boolean(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logger.info(CLASS_NAME + ".isConfiguredGIHomePresent() returns " + this.isConfiguredGIHomePresent);
        return this.isConfiguredGIHomePresent;
    }

    public Version getConfiguredHAVersion() {
        Version haVersion = null;
        ClusterwareInfo clusterInfo = new ClusterwareInfo();
        try {
            if (clusterInfo.isHAConfigured()) {
                haVersion = InventoryInfo.getInstance().getProductVersion(this.getCRSHome());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "failed while getting Configured HA Version");
        }
        this.logger.info(CLASS_NAME + ".getConfiguredHAVersion() returns the HA version as " + haVersion);
        return haVersion;
    }

    public String getCRSUser() {
        String crsUser = null;
        try {
            CVUHelper cvu = CVUHelper.getInstance();
            VerificationResult result = cvu.getCRSUser();
            if (result != null) {
                crsUser = result.getActualValue();
            }
        }
        catch (VerificationException e) {
            this.logger.log(Level.WARNING, "Verification exception occured while getting crs user.");
        }
        catch (UnsupportedOperationException e) {
            this.logger.log(Level.WARNING, "Unsupported operation exception occured while getting crs user.");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception occured while getting crs user.");
        }
        this.logger.info(CLASS_NAME + ".getCRSUser() returns the CRS user " + crsUser);
        return crsUser;
    }

    public List<String> getNodesWithStackDown(String crsHome, List<String> nodes) {
        ArrayList<String> nodesCRSList = new ArrayList<String>();
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        for (String node : nodes) {
            if (FileInfo.getInstance().areLocsSame(this.configuredCRSHome, crsHome)) continue;
            try {
                if (clusterwareInfo.isCRSRunning(crsHome, node)) continue;
                this.logger.log(Level.FINEST, "CRSHome:" + crsHome + " node:" + node + " ConfiguredHome:" + this.configuredCRSHome);
                nodesCRSList.add(node);
            }
            catch (oracle.cluster.install.InstallException e1) {
                nodesCRSList.add(node);
                this.logger.log(Level.WARNING, "InstallException occured during the cluster check. Reason: ", e1);
            }
        }
        if (nodesCRSList.size() > 0) {
            this.logger.info(CLASS_NAME + ".getNodesWithStackDown() returns the list of nodes not running in the CRS Home " + crsHome + " nodes " + nodesCRSList);
        }
        return nodesCRSList;
    }

    public String getSIHAUser() {
        String sihaUser = null;
        try {
            CVUHelper cvu = CVUHelper.getInstance();
            VerificationResult result = cvu.getSIHAUser();
            if (result != null) {
                sihaUser = result.getActualValue();
            }
        }
        catch (VerificationException e) {
            this.logger.log(Level.WARNING, "Verification exception occured while getting siha user.");
        }
        catch (UnsupportedOperationException e) {
            this.logger.log(Level.WARNING, "Unsupported operation exception occured while getting siha user.");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Exception occured while getting siha user.");
        }
        this.logger.info(CLASS_NAME + ".getCRSUser() returns the SIHA user " + sihaUser);
        return sihaUser;
    }

    public boolean isCRSRunningOnAnyNode(List<String> nodes) {
        boolean isCRSRunningOnAnyNode = false;
        try {
            if (this.isCRSConfigured()) {
                try {
                    String home = InventoryInfo.getInstance().getCRSHome();
                    isCRSRunningOnAnyNode = this.isCRSRunningOnAnyNode(home, nodes);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Exception occured while checking for crs on nodes. [" + nodes + "]");
                    this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                }
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        this.logger.info(CLASS_NAME + ".isCRSRunningOnAnyNode() returns value " + isCRSRunningOnAnyNode);
        return isCRSRunningOnAnyNode;
    }

    public boolean isCRSRunningOnAnyNode(String crshome, List<String> nodes) {
        boolean crsRunning = false;
        boolean isPre112Home = true;
        try {
            Version version = InventoryInfo.getInstance().getProductVersion(crshome);
            if (version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0) {
                isPre112Home = false;
            }
        }
        catch (InstallException e1) {
            this.logger.log(Level.WARNING, "Oracle home value is not found in Oracle Inventory. Reason: ", (Throwable)((Object)e1));
            this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)((Object)e1)));
        }
        for (String node : nodes) {
            try {
                crsRunning = isPre112Home ? ClusterInfo.checkCSSStatus((String)node, (String)crshome, (oracle.ops.mgmt.cluster.Version)new oracle.ops.mgmt.cluster.Version()) : new ClusterwareInfo().isCRSRunning(crshome, node);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Exception occurred while checking for crs running on node:" + node);
                this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                crsRunning = false;
            }
            if (!crsRunning) continue;
            break;
        }
        this.logger.info(CLASS_NAME + ".isCRSRunningOnAnyNode() returns value " + crsRunning + " for the CRS Home at " + crshome);
        return crsRunning;
    }

    public boolean isCRSRunningOnLocalNode() {
        boolean isCRSRunningOnLocalNode = false;
        try {
            if (this.isCRSConfigured()) {
                try {
                    String home = InventoryInfo.getInstance().getCRSHome();
                    isCRSRunningOnLocalNode = this.isCRSRunningOnLocalNode(home);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Exception occured while checking for crs on local node.");
                    this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                }
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if crs is configured", e);
        }
        this.logger.info(CLASS_NAME + ".isCRSRunningOnLocalNode() returns value " + isCRSRunningOnLocalNode);
        return isCRSRunningOnLocalNode;
    }

    public boolean isCRSRunningOnLocalNode(String crshome) {
        String strLocalHostName = MachineInfo.getInstance().getLocalMachineName();
        boolean crsRunning = false;
        boolean isPre112Home = true;
        try {
            Version version = InventoryInfo.getInstance().getProductVersion(crshome);
            if (version.compareTo(InstallConstants.VERSION_11_2, 4) >= 0) {
                isPre112Home = false;
            }
        }
        catch (InstallException e1) {
            this.logger.log(Level.WARNING, "Oracle home value is not found in Oracle Inventory. Reason: ", (Throwable)((Object)e1));
            this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)((Object)e1)));
        }
        try {
            crsRunning = isPre112Home ? ClusterInfo.checkCSSStatus((String)strLocalHostName, (String)crshome, (oracle.ops.mgmt.cluster.Version)new oracle.ops.mgmt.cluster.Version()) : new ClusterwareInfo().isCRSRunning(crshome, strLocalHostName);
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "Exception occurred while checking for crs running on local node:[" + strLocalHostName + "]");
            this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
            crsRunning = false;
        }
        this.logger.info(CLASS_NAME + ".isCRSRunningOnLocalNode() returns value " + crsRunning + " for the CRS Home at " + crshome);
        return crsRunning;
    }

    public boolean isASMRunning(String kfodPath) {
        boolean isASMRunning = false;
        String strLocalHostName = MachineInfo.getInstance().getLocalMachineName();
        isASMRunning = this.isASMRunning(kfodPath, strLocalHostName);
        this.logger.info(CLASS_NAME + ".isASMRunning() returns " + isASMRunning + " on local node " + strLocalHostName);
        return isASMRunning;
    }

    public boolean isASMRunning(String kfodPath, String node) {
        boolean isASMRunning = false;
        try {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            isASMRunning = clusterwareInfo.isASMRunning(kfodPath, node);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while checking for ASM running on node:[" + node + "]:" + e.getMessage());
        }
        this.logger.info(CLASS_NAME + ".isASMRunning() returns " + isASMRunning + " on node " + node);
        return isASMRunning;
    }

    public VerificationResultSet checkCRSIntegrity(String[] nodes) {
        VerificationResultSet resultSet = null;
        if (DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkCRSIntegrity")) {
            try {
                resultSet = CVUHelper.getInstance().checkCRSIntegrity(nodes);
            }
            catch (VerificationException e) {
                this.logger.log(Level.WARNING, "Error while checking CRS Integrity on given nodes");
                this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
            }
        }
        this.logger.info(CLASS_NAME + ".checkCRSIntegrity() returns " + resultSet.getOverallStatus());
        return resultSet;
    }

    public boolean isFlexCluster() {
        boolean isBigCluster;
        block9: {
            isBigCluster = false;
            try {
                if (!this.isCRSConfigured()) break block9;
                String crsActiveVersion = CRSInfo.getInstance().getCRSActiveVersion();
                Version version = null;
                if (GenericValidation.isEmpty(crsActiveVersion)) break block9;
                try {
                    version = Version.parseVersion((String)crsActiveVersion);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.log(Level.INFO, "Error while comparing crs version", iae);
                    isBigCluster = false;
                }
                if (version == null) break block9;
                if (version.compareTo(InstallConstants.VERSION_12_2) >= 0) {
                    String clusterType = this.getClusterType();
                    if (clusterType != null && clusterType.trim().equalsIgnoreCase("flex")) {
                        isBigCluster = true;
                    }
                    break block9;
                }
                try {
                    if (this.isCRSRunningOnLocalNode() && version.compareTo(InstallConstants.VERSION_12_1) >= 0 && this.clusterwareInfo.getCSSMode() == CSSMode.cssBCCLUSTERED) {
                        isBigCluster = true;
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.logger.log(Level.INFO, "Error while comparing crs version", iae);
                    isBigCluster = false;
                }
            }
            catch (oracle.cluster.install.InstallException ie) {
                this.logger.log(Level.INFO, "Error while checking if CRS is configured", ie);
                isBigCluster = false;
            }
        }
        this.logger.info(CLASS_NAME + ".isFlexCluster() returns " + isBigCluster);
        return isBigCluster;
    }

    public int getMaxTargetHubSize() {
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        int maxHubSize = 0;
        try {
            maxHubSize = clusterwareInfo.getMaxHubSize();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Could not determine max hub size", e);
        }
        this.logger.info(CLASS_NAME + ".getMaxTargetHubSize() returns the max hub size: " + maxHubSize);
        return maxHubSize;
    }

    public ClusterConfig getConfiguredCRSDetails(String oracleHome) {
        return this.getConfiguredCRSDetails(oracleHome, false, true);
    }

    public ClusterConfig getConfiguredCRSDetails(String oracleHome, boolean reload, boolean updateCache) {
        if (this.clusterConfig == null || reload) {
            ClusterConfig clusterConfig = new ClusterConfig();
            try {
                ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
                if (this.isFlexCluster()) {
                    clusterConfig.setClusterType(ClusterConfig.ClusterType.BIG);
                    ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                    HashMap map = clusterwareInfo.getClusterNodeActiveRoles(oracleHome);
                    for (String key : map.keySet()) {
                        SingleClusterNode clusterNode = new SingleClusterNode(key, "");
                        if (map.get(key) == NodeRole.HUB) {
                            clusterNode.setNodeType(ClusterNode.NodeType.HUB);
                        } else if (map.get(key) == NodeRole.RIM) {
                            clusterNode.setNodeType(ClusterNode.NodeType.RIM);
                        } else if (map.get(key) == NodeRole.AUTO) {
                            clusterNode.setNodeType(ClusterNode.NodeType.AUTO);
                        }
                        clusterNodes.add(clusterNode);
                    }
                } else {
                    clusterConfig.setClusterType(ClusterConfig.ClusterType.TRADITIONAL);
                    String[] nodes = this.getNodesFromCRSstack();
                    if (nodes != null && nodes.length > 0) {
                        for (String node : nodes) {
                            clusterNodes.add(new SingleClusterNode(node, ""));
                        }
                    }
                }
                clusterConfig.setClusterNodes(clusterNodes);
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting active node roles from cluster", e);
            }
            if (updateCache) {
                this.clusterConfig = clusterConfig;
            } else {
                return clusterConfig;
            }
        }
        return this.clusterConfig;
    }

    public NodeRole getConfiguredRole(String node) {
        NodeRole nodeRole = null;
        if (this.isFlexCluster()) {
            this.initClusterNodeConfigRoles(this.getCRSHome());
            if (this.configRoleNodeMap != null) {
                nodeRole = this.configRoleNodeMap.get(node);
            }
        }
        this.logger.info(CLASS_NAME + ".getConfiguredRole() returns node role " + nodeRole + " for the node " + node);
        return nodeRole;
    }

    public NodeRole getActiveRole(String node) {
        NodeRole nodeRole = null;
        if (this.isFlexCluster()) {
            this.initClusterNodeActiveRoles(this.getCRSHome());
            if (this.activeRoleNodeMap != null) {
                nodeRole = this.activeRoleNodeMap.get(node);
            }
        }
        this.logger.info(CLASS_NAME + ".getActiveRole() returns node role " + nodeRole + " for the node " + node);
        return nodeRole;
    }

    public List<String> getConfiguredHubNodes() {
        List<String> configuredHubNodes = null;
        if (this.isFlexCluster()) {
            configuredHubNodes = this.getNodelistForConfiguredRole(NodeRole.HUB);
        }
        this.logger.info(CLASS_NAME + ".getConfiguredHubNodes() returns the following HUB nodes " + configuredHubNodes);
        return configuredHubNodes;
    }

    public List<String> getConfiguredRimNodes() {
        List<String> configuredRimNodes = null;
        if (this.isFlexCluster()) {
            configuredRimNodes = this.getNodelistForConfiguredRole(NodeRole.RIM);
        }
        this.logger.info(CLASS_NAME + ".getConfiguredRimNodes() returns the following RIM nodes " + configuredRimNodes);
        return configuredRimNodes;
    }

    public List<String> getConfiguredAutoNodes() {
        List<String> configuredAutoNodes = null;
        if (this.isFlexCluster()) {
            configuredAutoNodes = this.getNodelistForConfiguredRole(NodeRole.AUTO);
        }
        this.logger.info(CLASS_NAME + ".getConfiguredAutoNodes() returns the following AUTO nodes " + configuredAutoNodes);
        return configuredAutoNodes;
    }

    public List<String> getActiveHubNodes() {
        List<String> activeHubNodes = null;
        if (this.isFlexCluster()) {
            activeHubNodes = this.getNodelistForActiveRole(NodeRole.HUB);
        }
        this.logger.info(CLASS_NAME + ".getActiveHubNodes() returns the following HUB nodes " + activeHubNodes);
        return activeHubNodes;
    }

    public List<String> getActiveRimNodes() {
        List<String> activeRimNodes = null;
        if (this.isFlexCluster()) {
            activeRimNodes = this.getNodelistForActiveRole(NodeRole.RIM);
        }
        this.logger.info(CLASS_NAME + ".getActiveRimNodes() returns the following RIM nodes " + activeRimNodes);
        return activeRimNodes;
    }

    private List<String> getNodelistForActiveRole(NodeRole role) {
        ArrayList<String> nodelist = null;
        this.initClusterNodeActiveRoles(this.getCRSHome());
        if (this.activeRoleNodeMap != null) {
            nodelist = new ArrayList<String>();
            for (Map.Entry<String, NodeRole> e : this.activeRoleNodeMap.entrySet()) {
                if (e.getValue() != role) continue;
                nodelist.add(e.getKey());
            }
        }
        this.logger.info(CLASS_NAME + ".getNodelistForActiveRole() returns the following nodelist " + nodelist + " for the active role " + role);
        return nodelist;
    }

    private List<String> getNodelistForConfiguredRole(NodeRole role) {
        ArrayList<String> nodelist = null;
        this.initClusterNodeConfigRoles(this.getCRSHome());
        if (this.configRoleNodeMap != null) {
            nodelist = new ArrayList<String>();
            for (Map.Entry<String, NodeRole> e : this.configRoleNodeMap.entrySet()) {
                if (e.getValue() != role) continue;
                nodelist.add(e.getKey());
            }
        }
        this.logger.info(CLASS_NAME + ".getNodelistForConfiguredRole() returns the following nodelist " + nodelist + " for the configured role " + role);
        return nodelist;
    }

    private void initClusterNodeActiveRoles(String crsHome) {
        if (this.activeRoleNodeMap == null) {
            this.initClusterwareInfo();
            try {
                this.activeRoleNodeMap = this.clusterwareInfo.getClusterNodeActiveRoles(crsHome);
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Exception from getClusterNodeActiveRoles", e);
            }
        }
    }

    private void initClusterNodeConfigRoles(String crsHome) {
        if (this.configRoleNodeMap == null) {
            this.initClusterwareInfo();
            try {
                this.configRoleNodeMap = this.clusterwareInfo.getClusterNodeConfigRoles(crsHome);
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Exception from getClusterNodeConfigRoles", e);
            }
        }
    }

    public boolean isMgmtDBExists() {
        boolean mgmtDBExists = false;
        try {
            if (this.isCRSConfigured()) {
                try {
                    mgmtDBExists = this.clusterwareInfo.isMgmtDBConfigured(oracle.ops.mgmt.cluster.Version.getVersion((String)this.getCRSActiveVersion()));
                }
                catch (oracle.cluster.install.InstallException e) {
                    this.logger.log(Level.INFO, "Exception from isMgmtDBConfigured", e);
                }
                catch (ConfigurationException e) {
                    this.logger.log(Level.INFO, "Exception from getVersion", e);
                }
            } else {
                mgmtDBExists = false;
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception from isCRSConfigured", e);
        }
        this.logger.info(CLASS_NAME + ".isMgmtDBExists() returns value " + mgmtDBExists);
        return mgmtDBExists;
    }

    public boolean isCRSConfigured() throws oracle.cluster.install.InstallException {
        this.initClusterwareInfo();
        boolean crsConfigured = false;
        crsConfigured = this.clusterwareInfo.isCRSConfigured();
        this.logger.info(CLASS_NAME + ".isCRSConfigured() returns value " + crsConfigured);
        return crsConfigured;
    }

    public boolean isHAConfigured() throws oracle.cluster.install.InstallException {
        this.initClusterwareInfo();
        boolean haConfigured = false;
        haConfigured = this.clusterwareInfo.isHAConfigured();
        this.logger.info(CLASS_NAME + ".isHAConfigured() returns value " + haConfigured);
        return haConfigured;
    }

    public int getMgmtDBRequiredSize(int nodeCount, int seedSize) {
        this.initClusterwareInfo();
        int mgmtSpace = 0;
        try {
            mgmtSpace = this.clusterwareInfo.getMgmtDBSize(nodeCount, seedSize);
            this.logger.log(Level.FINEST, "Management db size =" + mgmtSpace);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while calculating the required management DB size", e);
        }
        this.logger.info(CLASS_NAME + ".getMgmtDBRequiredSize() returns the mgmtdb size required as " + mgmtSpace);
        return mgmtSpace;
    }

    public int getMgmtDBRequiredSize(int hubOrAutoNodeCount, int rimNodeCount, int seedSize) {
        this.initClusterwareInfo();
        int mgmtSpace = 0;
        try {
            this.logger.log(Level.FINEST, "hub or Auto node count=" + hubOrAutoNodeCount + "rimNodeCount=" + rimNodeCount);
            mgmtSpace = this.clusterwareInfo.getMgmtDBSize(hubOrAutoNodeCount, rimNodeCount, seedSize);
            this.logger.log(Level.FINEST, "Management db size =" + mgmtSpace);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while calculating the required management DB size", e);
        }
        this.logger.info(CLASS_NAME + ".getMgmtDBRequiredSize() returns the mgmtdb size required as " + mgmtSpace);
        return mgmtSpace;
    }

    public List<String> getNodesForAdminManagedDatabase(String crsHome) {
        ArrayList<String> nodelist = new ArrayList();
        this.bigClusterImpl = new BigClusterImpl();
        try {
            nodelist = this.bigClusterImpl.getNodesForAdminManagedDatabase(crsHome);
        }
        catch (BigClusterException e) {
            this.logger.log(Level.INFO, "Exception from getNodesForAdminManagedDatabase", e);
        }
        this.logger.info(CLASS_NAME + ".getNodesForAdminManagedDatabase() returns the the nodelist for admin-managed database " + nodelist);
        return nodelist;
    }

    public boolean isDatabaseAdminManaged(String oracleHome, String dbUniqueName) {
        boolean isDBAdminManaged = false;
        try {
            isDBAdminManaged = this.clusterwareInfo.isDatabaseAdminManaged(oracleHome, dbUniqueName);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while identifying if Database is Admin-managed", e);
        }
        this.logger.info(CLASS_NAME + ".isDatabaseAdminManaged() returns value " + isDBAdminManaged + " for database " + dbUniqueName);
        return isDBAdminManaged;
    }

    public boolean isUserHavingACFSPermission(String oracleHome, String user) {
        boolean isUserACFSPermission = false;
        if (PlatformInfo.getInstance().isWindows()) {
            isUserACFSPermission = true;
        } else {
            try {
                isUserACFSPermission = this.clusterwareInfo.validateACFSPermission(oracleHome, user);
            }
            catch (oracle.cluster.install.InstallException e) {
                this.logger.log(Level.INFO, "Error while checking user has permission to operate on oracl home provided as ACFS", e);
            }
        }
        this.logger.info(CLASS_NAME + ".isUserHavingACFSPermission() returns value " + isUserACFSPermission + " for user " + user);
        return isUserACFSPermission;
    }

    public String getASMModeStr() {
        String asmModeStr = null;
        try {
            String crsActiveVersion;
            if (this.isCRSConfigured() && this.isCRSRunningOnLocalNode() && Version.parseVersion((String)(crsActiveVersion = this.getCRSActiveVersion())).compareTo(InstallConstants.VERSION_12_1) >= 0) {
                asmModeStr = this.clusterwareInfo.getASMStatusInfo().getASMModeStr();
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while retrieving ASM Type", e);
        }
        this.logger.info(CLASS_NAME + ".getASMModeStr() returns " + asmModeStr);
        return asmModeStr;
    }

    public String getClusterType() {
        this.initClusterwareInfo();
        String clusterType = null;
        try {
            clusterType = this.clusterwareInfo.getClusterType();
        }
        catch (oracle.cluster.install.InstallException ie) {
            this.logger.log(Level.INFO, "Error while retrieving Cluster Type", ie);
        }
        this.logger.info(CLASS_NAME + ".getClusterType() returns " + clusterType);
        return clusterType;
    }

    public boolean isApplicationCluster() {
        boolean isAppCluster;
        block7: {
            isAppCluster = false;
            try {
                if (!this.isCRSConfigured()) break block7;
                String crsActiveVersion = CRSInfo.getInstance().getCRSActiveVersion();
                Version version = null;
                if (GenericValidation.isEmpty(crsActiveVersion)) break block7;
                try {
                    version = Version.parseVersion((String)crsActiveVersion);
                }
                catch (IllegalArgumentException iae) {
                    isAppCluster = false;
                    this.logger.log(Level.INFO, "Error while parsing crs active version", iae);
                }
                if (version != null) {
                    if (version.compareTo(InstallConstants.VERSION_12_2) >= 0) {
                        this.initClusterwareInfo();
                        isAppCluster = this.clusterwareInfo.isApplicationCluster();
                    } else {
                        isAppCluster = false;
                        this.logger.log(Level.INFO, "Active CRS version is not 12.2 or above");
                    }
                }
            }
            catch (oracle.cluster.install.InstallException ie) {
                isAppCluster = false;
                this.logger.log(Level.INFO, "Error while retrieving Cluster Type", ie);
            }
        }
        this.logger.info(CLASS_NAME + ".isApplicationCluster() returns value :" + isAppCluster);
        return isAppCluster;
    }

    public List<String> getHistoricalClusterNodes(String crsHome) {
        ArrayList<String> allNodes = new ArrayList();
        try {
            allNodes = this.clusterwareInfo.getHistoricalClusterNodes(crsHome);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while retrieving nodes list in OCR", e);
        }
        this.logger.info(CLASS_NAME + ".getHistoricalClusterNodes() returns all nodes :" + allNodes);
        return allNodes;
    }

    public boolean isExtendedCluster() {
        boolean isExtCluster;
        block7: {
            isExtCluster = false;
            try {
                if (!this.isCRSConfigured()) break block7;
                String crsActiveVersion = CRSInfo.getInstance().getCRSActiveVersion();
                Version version = null;
                if (GenericValidation.isEmpty(crsActiveVersion)) break block7;
                try {
                    version = Version.parseVersion((String)crsActiveVersion);
                }
                catch (IllegalArgumentException iae) {
                    isExtCluster = false;
                    this.logger.log(Level.INFO, "Error while parsing crs active version", iae);
                }
                if (version != null) {
                    if (version.compareTo(InstallConstants.VERSION_12_2) >= 0) {
                        this.initClusterwareInfo();
                        isExtCluster = this.clusterwareInfo.isExtendedCluster();
                    } else {
                        isExtCluster = false;
                        this.logger.log(Level.INFO, "Active CRS version is not 12.2 or above");
                    }
                }
            }
            catch (oracle.cluster.install.InstallException e) {
                isExtCluster = false;
                this.logger.log(Level.INFO, "Error while determining if this cluster is Extended Cluster", e);
            }
        }
        this.logger.info(CLASS_NAME + ".isExtendedCluster() returns value :" + isExtCluster);
        return isExtCluster;
    }

    public List<String> getConfiguredSiteNames() {
        ArrayList<String> siteNames = new ArrayList<String>();
        if (this.isExtendedCluster()) {
            siteNames.addAll(this.getConfiguredSites().keySet());
        }
        this.logger.info(CLASS_NAME + ".getConfiguredSiteNames() returns the site names :" + siteNames);
        return siteNames;
    }

    public boolean isLeafNodeAllowed(String oracleHome) throws oracle.cluster.install.InstallException {
        return ClusterwareInfo.isLeafNodeAllowed((String)oracleHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAFDSupported(String oracleHome) {
        boolean isAFDSupported = false;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File afddriverstate = null;
        File afddriverstatePath = new File(oracleHome, executablePath);
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        afddriverstate = !isWindows ? new File(afddriverstatePath, "afddriverstate") : new File(afddriverstatePath, "afddriverstate.bat");
        if (afddriverstate != null && afddriverstate.exists()) {
            class OutputParser
            extends DefaultLineProcessor {
                List<String> output;

                OutputParser() {
                }

                public void processLine(String line, int lineNumber) {
                    if (this.output == null) {
                        this.output = new ArrayList<String>();
                    }
                    CRSInfo.this.logger.log(Level.INFO, "Parsing {0}", line);
                    this.output.add(line);
                }

                List<String> getOutput() {
                    return this.output;
                }
            }
            OutputParser outputParser = new OutputParser();
            DefaultLineProcessor stderrProcessor = new DefaultLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    CRSInfo.this.logger.warning(line);
                }
            };
            if (!isWindows) {
                processBuilder.command(afddriverstate.getPath());
            } else {
                processBuilder.command("\"" + afddriverstate.getPath() + "\"");
            }
            List<String> command = processBuilder.command();
            command.add("-orahome");
            command.add(oracleHome);
            command.add("supported");
            command.add("-s");
            String tempOB = OFAWrapper.getInstance().getTempOracleBaseLocation();
            File tempOBFile = new File(tempOB);
            if (tempOBFile.exists() || tempOBFile.mkdirs()) {
                processBuilder.environment().put("ORACLE_BASE", tempOB);
            } else {
                this.logger.warning("Could not create temp oracle base: " + tempOB);
            }
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)outputParser, (OutputProcessor)stderrProcessor);
            int exitStatus = 1;
            try {
                exitStatus = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (NullPointerException e) {
                this.logger.log(Level.WARNING, "Exception occured ", e);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.WARNING, "Exception occured ", e);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception occured ", e);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "Exception occured ", e);
            }
            finally {
                processBuilder.command().clear();
            }
            if (exitStatus == 0) {
                isAFDSupported = true;
            } else {
                List errors;
                isAFDSupported = false;
                ArrayList<String> totalLines = new ArrayList<String>();
                if (outputParser.getOutput() != null) {
                    totalLines.addAll(outputParser.getOutput());
                }
                if ((errors = stderrProcessor.getLines()) != null && errors.size() > 0) {
                    totalLines.addAll(errors);
                }
                if (totalLines.size() > 0) {
                    this.afdResultExtraDetails = new PlainContent("");
                    this.afdResultExtraDetails.setContentType(ContentType.HTML);
                    this.afdResultExtraDetails.setTitle(Application.getInstance().getResource(StringResourceBundle.class.getName()).getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
                    StringBuffer extraDetails = new StringBuffer();
                    for (String line : totalLines) {
                        if (line == null) continue;
                        extraDetails.append("&nbsp;-&nbsp;");
                        extraDetails.append(StringUtils.textToHtml((String)line) + "<br>");
                    }
                    StringBuffer details = new StringBuffer(this.afdResultExtraDetails.getContent());
                    details.append(extraDetails.toString());
                    this.afdResultExtraDetails.setContent(details.toString());
                    this.setAfdResultExtraDetails(this.afdResultExtraDetails);
                }
            }
        }
        this.logger.info(CLASS_NAME + ".isAFDSupported() on this platform returns value :" + isAFDSupported);
        return isAFDSupported;
    }

    public boolean isAFDDriversLoaded(String configuredGIHome) {
        boolean bAFDLoaded = false;
        this.initClusterwareInfo();
        try {
            bAFDLoaded = this.clusterwareInfo.isAFDDriversLoaded(configuredGIHome);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception occurred ClusterwareInfo.isAFDDriversLoaded():", e);
        }
        return bAFDLoaded;
    }

    public boolean isCRSConfiguredInHome(String crsHome) {
        boolean isCRSConfiguredInHome = false;
        boolean isCRSConfigured = false;
        try {
            isCRSConfigured = this.isCRSConfigured();
        }
        catch (Exception e) {
            this.logger.warning("Could not check if the crs was configured.");
        }
        if (isCRSConfigured) {
            String configuredCRSHome = this.getCRSHome();
            boolean isCRSConfiguredFromHome = FileInfo.getInstance().areLocsSame(configuredCRSHome, crsHome);
            if (isCRSConfiguredFromHome) {
                isCRSConfiguredInHome = true;
            }
        }
        this.logger.info(CLASS_NAME + ".isCRSConfiguredInHome() returns value :" + isCRSConfiguredInHome + " for the CRS home :" + crsHome);
        return isCRSConfiguredInHome;
    }

    public boolean isHAConfiguredInHome(String haHome) {
        boolean isHAConfiguredInHome = false;
        boolean isHAConfigured = false;
        try {
            isHAConfigured = this.isHAConfigured();
        }
        catch (Exception e) {
            this.logger.warning("Could not check if the SIHA was configured.");
        }
        if (isHAConfigured) {
            String configuredHAHome = this.getCRSHome();
            boolean isHAConfiguredFromHome = FileInfo.getInstance().areLocsSame(configuredHAHome, haHome);
            if (isHAConfiguredFromHome) {
                isHAConfiguredInHome = true;
            }
        }
        this.logger.info(CLASS_NAME + ".isHAConfiguredInHome() returns value :" + isHAConfiguredInHome + " for the SIHA home :" + haHome);
        return isHAConfiguredInHome;
    }

    public int getBackupDGSize() {
        int ocrBackupSize = 0;
        this.initClusterwareInfo();
        try {
            ocrBackupSize = this.clusterwareInfo.getBackupDGSize();
        }
        catch (oracle.cluster.install.InstallException ie) {
            this.logger.log(Level.INFO, "Error while determining ocr backup size", ie);
        }
        this.logger.info(CLASS_NAME + ".getBackupDGSize() for OCR returns value :" + ocrBackupSize);
        return ocrBackupSize;
    }

    public List<String> getActiveClusterNodes(String crsHome) {
        List activeClusterNodes = null;
        this.initClusterwareInfo();
        try {
            activeClusterNodes = this.clusterwareInfo.getActiveClusterNodes(crsHome);
        }
        catch (oracle.cluster.install.InstallException ex) {
            this.logger.log(Level.WARNING, "Install Exception occurred while retreiving active cluster nodes for home : " + crsHome, ex);
        }
        this.logger.info(CLASS_NAME + ".getActiveClusterNodes() returns the node list :" + activeClusterNodes);
        return activeClusterNodes;
    }

    public Map<NodeRole, List<String>> getServersFromFreePool() {
        HashMap<NodeRole, List<String>> nodeRoleServerMap = new HashMap();
        this.initClusterwareInfo();
        try {
            nodeRoleServerMap = this.clusterwareInfo.getActiveServersForFreePool();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Error while retrieving the free servers from free pool");
        }
        return nodeRoleServerMap;
    }

    public List<String> getHubFreeServers() {
        ArrayList<String> hubFreeServers = new ArrayList();
        Map<NodeRole, List<String>> nodeRoleServerMap = this.getServersFromFreePool();
        if (nodeRoleServerMap != null) {
            hubFreeServers = nodeRoleServerMap.get(NodeRole.HUB);
        }
        this.logger.info(CLASS_NAME + ".getHubFreeServers() returns the free hub node list :" + hubFreeServers);
        return hubFreeServers;
    }

    public boolean isHARunning() {
        boolean isHARunning = false;
        try {
            if (this.isHAConfigured()) {
                try {
                    String home = InventoryInfo.getInstance().getCRSHome();
                    this.initClusterwareInfo();
                    isHARunning = this.clusterwareInfo.isHARunning(home);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Exception occured while checking for SIHA.");
                    this.logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                }
            }
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while checking if SIHA is configured", e);
        }
        this.logger.info(CLASS_NAME + ".isHARunning() returns value :" + isHARunning);
        return isHARunning;
    }

    public boolean isRHPServerConfigured(String crsHome) {
        boolean isRHPServerConfigured = false;
        this.initClusterwareInfo();
        RHPContainerType rhpContainerType = null;
        try {
            rhpContainerType = this.clusterwareInfo.getRHPClusterType(crsHome);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while fetching RHP Cluster type" + (Object)((Object)e));
        }
        if (rhpContainerType != null && rhpContainerType == RHPContainerType.RHPS) {
            isRHPServerConfigured = true;
        }
        this.logger.info(CLASS_NAME + ".isRHPServerConfigured() returns value :" + isRHPServerConfigured + " for the Grid Home :" + crsHome);
        return isRHPServerConfigured;
    }

    public int getAdditionalDGSizeRequired(int numOfHubOrAutoNodes, int numOfLeafNodes, int seedDBSize, boolean isRHPS, boolean isDSC, int noOfMemberClusters) {
        int totalRequiredSize = 0;
        this.initClusterwareInfo();
        EnumSet<DiskSpaceFlags> flags = EnumSet.of(DiskSpaceFlags.MGMTDB_DISKSPACE_FLAGS_NONE);
        try {
            totalRequiredSize = this.clusterwareInfo.getReqdDiskGroupSize(numOfHubOrAutoNodes, numOfLeafNodes, seedDBSize, isRHPS, isDSC, noOfMemberClusters, flags);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while determining the additional required space for DG" + (Object)((Object)e));
        }
        this.logger.info(CLASS_NAME + ".getAdditionalDGSizeRequired() returns value :" + totalRequiredSize);
        return totalRequiredSize;
    }

    public Map<String, String> getConfiguredSites() {
        HashMap<String, String> siteNameGUIDMap = new HashMap<String, String>();
        List siteObjs = null;
        try {
            siteObjs = this.clusterwareInfo.getConfiguredSites();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception while retrieving sites", e);
        }
        if (siteObjs != null) {
            for (Site site : siteObjs) {
                if (site == null) continue;
                siteNameGUIDMap.put(site.getSiteName(), site.getSiteGUID());
            }
        }
        this.logger.info(CLASS_NAME + ".getConfiguredSites() returns the site names and its GUIDs :" + siteNameGUIDMap);
        return siteNameGUIDMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDBSizeOnASM(String diskgroupName, String dbUniqueName, boolean bMirrorSize) {
        int spaceInMB = 0;
        String gridHome = this.getCRSHome();
        File asmcmdFile = null;
        File asmcmdPath = new File(gridHome, asmcmdUtility);
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        asmcmdFile = !isWindows ? new File(asmcmdPath, "asmcmd") : new File(asmcmdPath, "asmcmd.bat");
        String sid = "";
        ASMInstance asmInstance = null;
        try {
            ASMUtility utility = ASMUtility.getInstance();
            asmInstance = utility.getASMInstance();
        }
        catch (ASMUtilityException ae) {
            this.logger.log(Level.WARNING, "Exception occurred while determining ASM instance." + (Object)((Object)ae));
        }
        sid = asmInstance.getSid();
        if (asmcmdFile.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(asmcmdFile.getPath());
            processBuilder.command().add(diskUsage);
            processBuilder.command().add(suppressHeaderFlag);
            processBuilder.command().add(diskgroupName + "/" + dbUniqueName);
            processBuilder.environment().put("ORACLE_HOME", gridHome);
            processBuilder.environment().put("PATH", asmcmdPath.getPath());
            processBuilder.environment().put("ORACLE_SID", sid);
            class LineProcessor
            extends DefaultLineProcessor {
                List<String> output;

                LineProcessor() {
                }

                public void processLine(String line, int lineNumber) {
                    if (this.output == null) {
                        this.output = new ArrayList<String>();
                    }
                    CRSInfo.this.logger.log(Level.INFO, "Parsing {0}", line);
                    this.output.add(line);
                }

                List<String> getOutput() {
                    return this.output;
                }
            }
            LineProcessor lineProcessor = new LineProcessor();
            DefaultLineProcessor stderrProcessor = new DefaultLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    CRSInfo.this.logger.log(Level.WARNING, line);
                }
            };
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, (OutputProcessor)stderrProcessor);
            int exitCode = 1;
            try {
                exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
                if (exitCode == 0) {
                    String outputLine = lineProcessor.getOutput().get(0).trim();
                    if (outputLine != null) {
                        String[] size = outputLine.split(" +");
                        if (size.length >= 2) {
                            if (!bMirrorSize) {
                                spaceInMB = Integer.parseInt(size[0]);
                            }
                            spaceInMB = Integer.parseInt(size[1]);
                        }
                        this.logger.log(Level.INFO, "Number of tokens in the output line is less than two,we can't find required used space by the database on diskgroup");
                    }
                    this.logger.log(Level.INFO, "Space used by database on diskgroup can't be determined as outputline has null value");
                }
                this.logger.log(Level.WARNING, "Execution was unsuccessful with exitCode value:" + exitCode);
            }
            catch (NullPointerException e) {
                this.logger.log(Level.WARNING, "Exception occurred" + e);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.WARNING, "Exception occurred such as NumberFormatException" + e);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Exception occurred due to incorrect input and output specifications" + e);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "Exception occurred due to interruption in launching the required process" + e);
            }
            finally {
                processBuilder.command().clear();
            }
        } else {
            this.logger.info("Unable to determine path of the file :" + asmcmdFile.getPath());
        }
        this.logger.info(CLASS_NAME + ".getDBSizeOnASM() returns value :" + spaceInMB);
        return spaceInMB;
    }

    public String getMgmtDBDiskGroup() {
        String diskGroupName = "";
        this.initClusterwareInfo();
        try {
            diskGroupName = this.clusterwareInfo.getMgmtDBDiskGroup();
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "MGMTDB does not exists. Exception occurred while determining the disk group that holds the MGMTD DB" + (Object)((Object)e));
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while determining the disk group that holds the MGMTD DB" + (Object)((Object)e));
        }
        this.logger.info(CLASS_NAME + ".getMgmtDBDiskGroup() returns value :" + diskGroupName);
        return diskGroupName;
    }

    public boolean isRHPServerConfigurationSupported(String crsHome) {
        boolean bRHPServerConfigSupported = false;
        this.initClusterwareInfo();
        try {
            bRHPServerConfigSupported = this.clusterwareInfo.isRHPSupported(crsHome, true);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.INFO, "Exception occurred while determining if RHP Server configuration is supported on this cluster: ", e);
        }
        this.logger.info(CLASS_NAME + ".isRHPServerConfigurationSupported() returns value :" + bRHPServerConfigSupported);
        return bRHPServerConfigSupported;
    }

    public boolean isMemberCluster() {
        boolean isMemberCluster = false;
        ClusterClassification clusterClass = this.getClusterClass();
        if (clusterClass != null && clusterClass.equals((Object)ClusterClassification.MEMBER_CLUSTER)) {
            isMemberCluster = true;
        }
        this.logger.info(CLASS_NAME + ".isMemberCluster() returns value " + isMemberCluster);
        return isMemberCluster;
    }

    public boolean isDomainServicesCluster() {
        boolean isDSC = false;
        ClusterClassification clusterClass = this.getClusterClass();
        if (clusterClass != null && clusterClass.equals((Object)ClusterClassification.DOMAIN_CLUSTER)) {
            isDSC = true;
        }
        this.logger.info(CLASS_NAME + ".isDomainServicesCluster() returns value " + isDSC);
        return isDSC;
    }

    public ClusterClassification getClusterClass() {
        this.initClusterwareInfo();
        ClusterClassification clusterClass = null;
        try {
            clusterClass = this.clusterwareInfo.getClusterClassification();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while determining the cluster class: ", e);
        }
        this.logger.info(CLASS_NAME + ".getClusterClass() returns " + clusterClass);
        return clusterClass;
    }

    public boolean isUpgradeEndMarkerSet() {
        boolean isUpgradeMarkerSet = false;
        try {
            CommonFactory m_commonFactory = CommonFactory.getInstance();
            Cluster clust = m_commonFactory.getCluster();
            isUpgradeMarkerSet = clust.isUpgradeEndMarkerSet();
        }
        catch (ManageableEntityException e) {
            this.logger.log(Level.WARNING, "Exception occurred while determining the upgrade marker: ", e);
            isUpgradeMarkerSet = false;
        }
        this.logger.info(CLASS_NAME + ".isUpgradeEndMarkerSet() returns value: " + isUpgradeMarkerSet);
        return isUpgradeMarkerSet;
    }

    public boolean isVIPLessNetwork() {
        boolean isVIPLessNetwork = false;
        this.initClusterwareInfo();
        try {
            isVIPLessNetwork = this.clusterwareInfo.isVipLessNetwork();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while determine if the network is vip-less ", e);
        }
        this.logger.info(CLASS_NAME + ".isVIPLessNetwork() returns value: " + isVIPLessNetwork);
        return isVIPLessNetwork;
    }

    public String getClusterGUID() {
        String clusterGUID = "";
        this.initClusterwareInfo();
        try {
            clusterGUID = this.clusterwareInfo.getClusterGUID();
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while fetching the cluster guid", e);
        }
        this.logger.info(CLASS_NAME + ".getClusterGUID() returns value: " + clusterGUID);
        return clusterGUID;
    }

    public String getMinSupportedMCVersion() {
        oracle.ops.mgmt.cluster.Version version = null;
        String minMCVersion = "";
        try {
            Cluster cluster = CommonFactory.getInstance().getCluster();
            version = cluster.getMinMCVersion();
        }
        catch (ManageableEntityException e) {
            this.logger.log(Level.WARNING, "Exception occurred while retreiving the min. supported version of a MC supported by this DSC: ", e);
        }
        if (version != null) {
            this.logger.fine("Minimum MC version supported is : " + version);
            minMCVersion = version.toString();
        }
        this.logger.info(CLASS_NAME + ".getMinSupportedMCVersion() returns value: " + minMCVersion);
        return minMCVersion;
    }

    public String getMinSupportedDSCVersion() {
        oracle.ops.mgmt.cluster.Version version = null;
        String minDSCVersion = "";
        try {
            Cluster cluster = CommonFactory.getInstance().getCluster();
            version = cluster.getMinDSCVersion();
        }
        catch (ManageableEntityException e) {
            this.logger.log(Level.WARNING, "Exception occurred while retreiving the min. supported version of the DSC supported by this MC: ", e);
        }
        if (version != null) {
            this.logger.fine("Minimum DSC version supported is : " + version);
            minDSCVersion = version.toString();
        }
        this.logger.info(CLASS_NAME + ".getMinSupportedDSCVersion() returns value: " + minDSCVersion);
        return minDSCVersion;
    }

    public List<ClientClusterInfo> getClientClusters() {
        ArrayList<ClientClusterInfo> clientClustersList = new ArrayList();
        this.initClusterwareInfo();
        try {
            clientClustersList = this.clusterwareInfo.getClientClusterInfo();
        }
        catch (NotExistsException e) {
            this.logger.log(Level.WARNING, "CCs does not exist. Exception occurred while fetching the list of client clusters configured with this DSC " + (Object)((Object)e));
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while fetching the list of client clusters configured with this DSC " + (Object)((Object)e));
        }
        return clientClustersList;
    }

    public Map<String, Integer> getRequiredSpaceForGridUpgrade(int numOfHubOrAutoNodes, int numOfLeafNodes, int seedDBSize, String oracleHome) {
        HashMap diskGroupSpaceMap = new HashMap();
        this.initClusterwareInfo();
        try {
            diskGroupSpaceMap = this.clusterwareInfo.getAdditionalSizeReqdForUpgrade(numOfHubOrAutoNodes, numOfLeafNodes, seedDBSize, oracleHome);
        }
        catch (oracle.cluster.install.InstallException e) {
            this.logger.log(Level.WARNING, "Exception occurred while trying to determine free space required for ASM disk groups." + (Object)((Object)e));
        }
        this.logger.info(CLASS_NAME + ".getRequiredSpaceForGridUpgrade() returns value: " + diskGroupSpaceMap);
        return diskGroupSpaceMap;
    }

    private static enum OifcfgMapping {
        UNKNOWN(3),
        PRIVATE(2),
        PUBLIC(1);

        private String value;

        private OifcfgMapping(int indentifier) {
            this.value = indentifier + "";
        }

        public String getValue() {
            return this.value;
        }
    }
}

