/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.dhcp;

import java.net.InetAddress;
import java.net.NetworkInterface;
import oracle.install.library.dhcp.WinNativeDHCPImpl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixPlatform;

public class DHCPInfo {
    private static DHCPInfo instance = null;

    private DHCPInfo() {
    }

    public static DHCPInfo getInstance() {
        if (instance == null) {
            instance = new DHCPInfo();
        }
        return instance;
    }

    public boolean isDHCPEnabled(String strNode) {
        try {
            String result = null;
            InetAddress inet = InetAddress.getLocalHost();
            String fullyQualifiedIP = inet.getHostAddress();
            OiiolTextLogger.appendText((String)("Detecting the IP.....:" + fullyQualifiedIP));
            inet = InetAddress.getByName(fullyQualifiedIP);
            String ipaddr = inet.getHostAddress();
            NetworkInterface nwiObj = NetworkInterface.getByInetAddress(inet);
            String bindingInterfaceDesc = nwiObj.getDisplayName();
            String bindingInterfaceName = nwiObj.getName();
            OiiolTextLogger.appendText((String)("Checking the network interface display name.... :" + bindingInterfaceDesc));
            OiiolTextLogger.appendText((String)("Checking the network reference  name.....  :" + bindingInterfaceName));
            int platform = OiixPlatform.getCurrentPlatform();
            OiiolTextLogger.appendText((String)("Checking the platform ......." + platform));
            if (OiixPlatform.isPlatInGroup((int)-3, (int)platform)) {
                try {
                    WinNativeDHCPImpl nativeWinObj = new WinNativeDHCPImpl();
                    result = nativeWinObj.checkIfLoopBackSupported(bindingInterfaceDesc);
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                return platform == 46;
            }
            if (result.equalsIgnoreCase("SUCCESS")) {
                return true;
            }
            if (result.equalsIgnoreCase("FAILURE") || result.equalsIgnoreCase("FAILED")) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

