/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.processes;

import java.io.File;
import java.util.Vector;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.processes.ssgetRunningProcessClassW32;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.sysman.oii.oiil.OiilNativeException;

public class ssgetRunningProcessW32 {
    private static ssgetRunningProcessW32 instance;

    protected ssgetRunningProcessW32() {
    }

    public static ssgetRunningProcessW32 getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ssgetRunningProcessW32)(proxyFactory = ProxyFactory.getInstance()).createProxy(ssgetRunningProcessW32.class)) == null) {
            instance = new ssgetRunningProcessW32();
        }
        return instance;
    }

    public Object getRunningProcesses(String[] files) throws InstallException {
        String retVal = "";
        String[] retServices = null;
        String psapiLocation = System.getProperty("oracle.installer.scratchPath") + File.separator + "ext" + File.separator + "bin" + File.separator + "psapi.dll";
        if (files.length == 0) {
            return retVal;
        }
        try {
            ssgetRunningProcessClassW32 srpc = new ssgetRunningProcessClassW32();
            retServices = ssgetRunningProcessClassW32.ssgetRunningProcessW32(files, psapiLocation);
        }
        catch (OiilNativeException ne) {
            if (ne.getExceptionString().equalsIgnoreCase("NoServicesForProcessException")) {
                throw new InstallException((ErrorCode)CommonErrorCode.RUNNING_PROCESSES_NO_SERVICE_EXCEPTION, new Object[0]);
            }
            throw new InstallException((Throwable)ne, (ErrorCode)CommonErrorCode.RUNNING_PROCESSES_RUNTIME_EXCEPTION, new Object[0]);
        }
        if (retServices == null) {
            return retVal;
        }
        Vector sortRetServices = (Vector)this.sortUnique(retServices);
        int retSize = sortRetServices.size();
        String expstr = "";
        for (int i = 0; i < retSize; ++i) {
            expstr = expstr + "\n" + (String)sortRetServices.elementAt(i);
        }
        throw new InstallException((ErrorCode)CommonErrorCode.RUNNING_PROCESSES_SERVICES_FOUND, expstr);
    }

    public Object sortUnique(String[] sortarr) {
        int i;
        Vector<String> sorted = new Vector<String>();
        for (i = 0; i < sortarr.length - 1; ++i) {
            for (int j = i + 1; j < sortarr.length; ++j) {
                if (sortarr[i].compareTo(sortarr[j]) <= 0) continue;
                String temp = sortarr[i];
                sortarr[i] = sortarr[j];
                sortarr[j] = temp;
            }
        }
        for (i = 0; i < sortarr.length - 1; ++i) {
            if (sortarr[i].equals(sortarr[i + 1])) continue;
            sorted.addElement(sortarr[i]);
        }
        sorted.addElement(sortarr[sortarr.length - 1]);
        return sorted;
    }
}

