/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.StringUtils;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class FunctionsUtil {
    private static Logger logger = Logger.getLogger(FunctionsUtil.class.getName());

    public static String implodeList(String[] sarr, String sDele) {
        return OiixFunctionOps.implodeList((String[])sarr, (String)sDele);
    }

    public static String[] explodeString(String str, String sDele) {
        return OiixFunctionOps.explodeString((String)str, (String)sDele);
    }

    public static String[] intersect(String[] sa1, String[] sa2) {
        return OiixFunctionOps.intersect((String[])sa1, (String[])sa2);
    }

    public static String[] subtract(String[] sa1, String[] sa2) {
        return OiixFunctionOps.subtract((String[])sa1, (String[])sa2);
    }

    public static Boolean isEmpty(String[] a) {
        return OiixFunctionOps.isEmpty((String[])a);
    }

    public static String pathify(String path) {
        return OiixFunctionOps.pathify((String)path);
    }

    public static String getReadableSize(long size, Unit unitVal) {
        double hr = 1024.0;
        int convIndex = 0;
        double m = 0.0;
        String Value = "";
        double space = size;
        int count = 0;
        String mValue = "";
        NumberFormat nf = NumberFormat.getInstance();
        m = space;
        if (m < 1024.0 || m == 1024.0) {
            mValue = String.valueOf((long)m);
        } else {
            while (m > 1024.0) {
                m = space / 1024.0;
                ++count;
            }
            mValue = m % 1.0 == 0.0 ? String.valueOf((long)m) : nf.format(BigDecimal.valueOf(m).setScale(1, RoundingMode.CEILING));
        }
        for (Unit un : Unit.values()) {
            if (!unitVal.equals((Object)un)) continue;
            convIndex = un.getindex() + count;
            break;
        }
        Unit valval = Unit.values()[convIndex];
        Value = mValue.concat(" " + valval.getVal(convIndex));
        return Value;
    }

    public static String getTimeStamp() {
        String timestamp;
        try {
            timestamp = OiiolLoggerUtil.getTimeStamp();
        }
        catch (Exception e) {
            timestamp = null;
        }
        if (timestamp == null) {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS_aaa");
            timestamp = dateFormat.format(date);
        }
        return timestamp;
    }

    public static void instantiateFile(Map<Object, Object> variableMap, File sourceFile, File destinationFile, String delimiter) {
        String destinationBakFile = new String(destinationFile.getAbsolutePath() + FunctionsUtil.getTimeStamp() + ".bak");
        try {
            if (destinationFile.exists()) {
                OiixFileOps.copyFile((String)destinationFile.getAbsolutePath(), (String)destinationBakFile, (boolean)true, (boolean)true);
            }
            OiixFileOps.instantiateFile((String)sourceFile.getAbsolutePath(), (String)destinationFile.getAbsolutePath(), (HashMap)((HashMap)FunctionsUtil.sanitizeMap(variableMap)), (String)"%");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while instantiating the file", e);
        }
    }

    private static Map<Object, Object> sanitizeMap(Map<Object, Object> paramsMap) {
        if (paramsMap != null) {
            for (Map.Entry<Object, Object> e : paramsMap.entrySet()) {
                if (!(e.getValue() instanceof String)) continue;
                e.setValue(StringUtils.sanitizeString((String)((String)e.getValue())));
            }
        }
        return paramsMap;
    }

    public static void moveFileOnNodes(File sourceFile, File destinationFile, List<String> nodes) {
        try {
            if (nodes != null && nodes.size() > 0) {
                ClusterCmd clusterCmd = new ClusterCmd();
                for (String node : nodes) {
                    if (!clusterCmd.fileExists(node, sourceFile.getAbsolutePath())) continue;
                    clusterCmd.moveFilesOnNode(node, sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while moving the file", e);
        }
    }

    public static enum Unit {
        Byte(1, "Byte"),
        KB(2, "KB"),
        MB(3, "MB"),
        GB(4, "GB"),
        TB(5, "TB"),
        PB(6, "PB");

        private int index;
        private String unit;

        private Unit(int index, String unit) {
            this.index = index;
            this.unit = unit;
        }

        public int getindex() {
            return this.index;
        }

        public String getVal() {
            return this.unit;
        }

        public String getVal(int index) {
            switch (index) {
                case 1: {
                    this.unit = "Byte";
                    break;
                }
                case 2: {
                    this.unit = "KB";
                    break;
                }
                case 3: {
                    this.unit = "MB";
                    break;
                }
                case 4: {
                    this.unit = "GB";
                    break;
                }
                case 5: {
                    this.unit = "TB";
                    break;
                }
                default: {
                    this.unit = "PB";
                }
            }
            return this.unit;
        }
    }
}

