/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallerException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.driver.util.RemoteOperationHelper;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.ClusterWindows;

public class IPMIWrapper {
    private static IPMIWrapper instance = null;
    private static final String strIPMIFile = "/dev/ipmi0";
    private static final String strIPMIRegistryKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDrv";
    private static final HashMap<Integer, String> supportedPlatforms = new HashMap();
    private static Logger logger;

    protected IPMIWrapper() {
    }

    public static IPMIWrapper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (IPMIWrapper)(proxyFactory = ProxyFactory.getInstance()).createProxy(IPMIWrapper.class)) == null) {
            instance = new IPMIWrapper();
        }
        return instance;
    }

    public boolean isIPMIDriverInstalled(String[] arrNodes) {
        ClusterCmd ccmd = new ClusterCmd();
        String regKey = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDRV";
        if (PlatformInfo.getInstance().isWindows()) {
            boolean keyExists = true;
            try {
                String arrNode;
                ClusterWindows clusterWindows = new ClusterWindows();
                String[] stringArray = arrNodes;
                int n = stringArray.length;
                for (int i = 0; i < n && (keyExists = clusterWindows.regKeyExistsOnNode("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDRV", arrNode = stringArray[i])); ++i) {
                }
                return keyExists;
            }
            catch (ClusterException clusterException) {}
        } else {
            try {
                return ccmd.pathExists(arrNodes, strIPMIFile, 0);
            }
            catch (ClusterException clusterException) {
            }
            catch (ClusterOperationException clusterOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public List<String> validateIPMIDriverInstalledOnUnix(String[] arrNodes) throws InstallerException {
        List<String> failedNodeList = null;
        try {
            RemoteOperationHelper.getInstance().pathExists(arrNodes, strIPMIFile, 0);
        }
        catch (ClusterOperationException e) {
            failedNodeList = RemoteOperationHelper.getInstance().getFailedNodes();
        }
        catch (ClusterException e) {
            throw new InstallerException((Throwable)e);
        }
        if (failedNodeList == null) {
            failedNodeList = Collections.emptyList();
        }
        return failedNodeList;
    }

    public List<String> valiateIPMIDriverInstalledOnWindows(String[] arrNodes) {
        ArrayList<String> failedNodeList = new ArrayList<String>(0);
        if (PlatformInfo.getInstance().isWindows()) {
            try {
                ClusterWindows clusterWindows = new ClusterWindows();
                for (String arrNode : arrNodes) {
                    if (clusterWindows.regKeyExistsOnNode(strIPMIRegistryKey, arrNode)) continue;
                    failedNodeList.add(arrNode);
                }
            }
            catch (ClusterException e) {
                logger.log(Level.WARNING, "ClusterException occurred while checking for registry key: HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\IPMIDrv on nodes: " + Arrays.toString(arrNodes), e);
            }
        }
        return failedNodeList;
    }

    public String getUserCredCookie(String strBMCUsername, String strBMCPassword) {
        return "ImplementaionPending";
    }

    public boolean isCurrentPlatformSupported() {
        PlatformInfo pInfo = PlatformInfo.getInstance();
        if (pInfo.isWindows()) {
            return true;
        }
        return supportedPlatforms.containsKey(pInfo.getCurrentPlatform());
    }

    public String getIPMIString() {
        PlatformInfo pInfo = PlatformInfo.getInstance();
        if (pInfo.isWindows()) {
            return strIPMIRegistryKey;
        }
        int currentPlatform = pInfo.getCurrentPlatform();
        if (supportedPlatforms.containsKey(currentPlatform)) {
            return supportedPlatforms.get(currentPlatform);
        }
        return null;
    }

    public HashMap getSupportedPlatforms() {
        return supportedPlatforms;
    }

    static {
        supportedPlatforms.put(46, strIPMIFile);
        logger = Logger.getLogger(IPMIWrapper.class.getName());
    }
}

