/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.SingleClusterNode;
import oracle.install.library.util.cluster.range.NodeRangeBuilder;
import oracle.install.library.util.cluster.range.compiler.NodeRangeCompiler;
import oracle.install.library.util.cluster.range.compiler.NodeToken;
import oracle.install.library.util.cluster.range.enums.NodeTokenType;

public class NodeRangeSupport {
    private static final int MAXIMUM_HOSTNAME_LENGTH = 253;
    private static final int MAXIMUM_DOMAIN_LABEL_LENGTH = 63;
    private static final Logger logger = Logger.getLogger(NodeRangeSupport.class.getName());
    private long totalNodeNames = 0L;
    private NodeRangeCompiler nodeRangeCompiler = new NodeRangeCompiler();
    private NodeRangeBuilder nodeRangeBuilder;
    private static NodeRangeSupport instance = null;
    private List<String> filteredHostnames = new ArrayList<String>();
    private List<String> filteredVIPnames = new ArrayList<String>();

    public static NodeRangeSupport getInstance() {
        if (instance == null) {
            instance = new NodeRangeSupport();
        }
        return instance;
    }

    protected NodeRangeSupport() {
    }

    public long getTotalNodeNames() {
        return this.totalNodeNames;
    }

    public boolean validateNodeRangeExpression(String expression) {
        boolean validationResult = true;
        List<NodeToken> parsedTokens = null;
        try {
            this.nodeRangeCompiler.compile(expression, false);
            parsedTokens = this.nodeRangeCompiler.getParsedTokens();
            for (NodeToken token : parsedTokens) {
                NodeTokenType currentType = token.getTokenType();
                if (currentType != NodeTokenType.NOT_DETERMINED && currentType != NodeTokenType.INVALID) continue;
                validationResult = false;
                logger.log(Level.WARNING, "Not valid token detected after the compilation of the node expression located at: " + token.getTokenContent());
                break;
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Validation failed due an empty string submitted as node range expression");
            validationResult = false;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Some exception ocurred while validating the string submitted as node range expression: " + ex.getMessage());
            validationResult = false;
        }
        if (validationResult) {
            this.nodeRangeBuilder = new NodeRangeBuilder(this.nodeRangeCompiler.createNodeGenerators(parsedTokens));
            this.totalNodeNames = this.nodeRangeBuilder.getTotalHostnames();
        } else {
            this.totalNodeNames = 0L;
        }
        return validationResult;
    }

    public List<String> generateNodeNames(String expression) {
        List<String> nodeNames = null;
        if (this.validateNodeRangeExpression(expression)) {
            nodeNames = this.nodeRangeBuilder.generateHostnames();
        }
        return nodeNames;
    }

    public List<ClusterNode> generateClusterNodes(String rangeExpression, String vipSuffix, ClusterNode.NodeType nodeType, String nodeSite) {
        ArrayList<ClusterNode> result = new ArrayList<ClusterNode>();
        List<String> nodeNames = this.generateNodeNames(rangeExpression);
        this.filteredHostnames.clear();
        this.filteredVIPnames.clear();
        if (nodeNames != null) {
            StringBuilder vipBuilder = new StringBuilder();
            boolean isVIPSuffixSpecified = vipSuffix != null && !vipSuffix.isEmpty();
            for (String nodeName : nodeNames) {
                if (!NodeRangeSupport.isHostnameLengthValid(nodeName)) {
                    this.filteredHostnames.add(nodeName);
                    continue;
                }
                if (isVIPSuffixSpecified) {
                    boolean isHostNameSubdomainPresent = nodeName.indexOf(46) != -1;
                    vipBuilder.append(nodeName);
                    if (isHostNameSubdomainPresent) {
                        vipBuilder.insert(nodeName.indexOf(46), vipSuffix);
                    } else {
                        vipBuilder.append(vipSuffix);
                    }
                }
                String vipName = vipBuilder.toString();
                if (isVIPSuffixSpecified && !NodeRangeSupport.isHostnameLengthValid(vipName)) {
                    this.filteredVIPnames.add(vipName);
                    vipBuilder.setLength(0);
                    continue;
                }
                SingleClusterNode singleNode = new SingleClusterNode(nodeName, vipName);
                singleNode.setNodeType(nodeType);
                singleNode.setSite(nodeSite);
                vipBuilder.setLength(0);
                result.add(singleNode);
            }
        }
        return result;
    }

    public void resetCompiler() {
        if (this.nodeRangeCompiler != null) {
            this.nodeRangeCompiler = new NodeRangeCompiler();
        }
        this.totalNodeNames = 0L;
        this.filteredHostnames.clear();
        this.filteredVIPnames.clear();
    }

    private static boolean isHostnameLengthValid(String hostname) {
        boolean isValid = true;
        if (hostname.length() <= 253) {
            String[] domainLabels;
            for (String domainLabel : domainLabels = hostname.split("\\.")) {
                if (domainLabel.length() <= 63) continue;
                isValid = false;
                break;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    public List<String> getFilteredHostnames() {
        return this.filteredHostnames;
    }

    public List<String> getFilteredVIPnames() {
        return this.filteredVIPnames;
    }
}

