/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cvu;

import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.library.util.cvu.CVUHelper;

public class CVUValidationException
extends ValidationException {
    public CVUValidationException() {
        this.updateExtraDetails();
    }

    public CVUValidationException(String message, Severity severity) {
        super(message, severity);
        this.updateExtraDetails();
    }

    public CVUValidationException(String message) {
        super(message);
        this.updateExtraDetails();
    }

    public CVUValidationException(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.updateExtraDetails();
    }

    public CVUValidationException(ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.updateExtraDetails();
    }

    public CVUValidationException(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.updateExtraDetails();
    }

    public CVUValidationException(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.updateExtraDetails();
    }

    public CVUValidationException(ErrorInfo errorInfo) {
        super(errorInfo);
        this.updateExtraDetails();
    }

    public CVUValidationException(Throwable cause, ErrorInfo errorInfo) {
        super(cause, errorInfo);
        this.updateExtraDetails();
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        CVUHelper helper = CVUHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }
}

