/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.io.File;
import java.text.DecimalFormat;
import oracle.cluster.winsecurity.Credentials;
import oracle.install.commons.base.interview.common.action.AbstractSummaryAction;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.Percentage;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.bean.ClientSetupBean;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.library.partition.PartitionInfoUnix;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.StageSizeInfo;

public class SummaryAction
extends AbstractSummaryAction {
    private static final DecimalFormat DISK_SPACE_FORMATTER = new DecimalFormat(".##");

    protected void buildSummary(FlowContext flowContext) {
        Variable customComponents;
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.client.resource.ClientDialogLabelResID");
        Summary summary = Summary.getInstance();
        summary.clear();
        summary.setTitle("Summary");
        summary.setDescription(application.getName());
        String description = resource.getString("INSTALL_CLIENT_SUMMARY_GLOBAL_SETTING_CATEGORY", "Global settings.", new Object[0]);
        Category globalSettingsCategory = new Category("GlobalSettings", description);
        summary.addCategory(globalSettingsCategory);
        try {
            long reqSpace = 0L;
            boolean considerOracleHomeOffset = false;
            if (installSettings.getInstallType() != ClientInstallSettings.InstallType.Custom) {
                reqSpace = StageSizeInfo.getSize((String)installSettings.getInstallType().toString(), (boolean)considerOracleHomeOffset);
                String oracleHomeFolder = SummaryAction.getLastExistingParent(installSettings.getOracleHome());
                long freeSpace = PartitionInfoUnix.getPartitionFreeSpace((String)oracleHomeFolder);
                int requiredPercentage = 100;
                if (freeSpace > reqSpace) {
                    requiredPercentage = (int)Math.round(100.0 * (double)reqSpace / (double)freeSpace);
                }
                String stringTotalSpace = this.readableSpace(freeSpace);
                String stringReqSpace = this.readableSpace(reqSpace);
                String message = resource.getString("INSTALL_CLIENT_SUMMARY_DISK_SPACE_REQUIRED", "required {0} available {1}", new Object[]{stringReqSpace, stringTotalSpace});
                description = resource.getString("INSTALL_CLIENT_SUMMARY_DISK_SPACE", "Disk space", new Object[0]);
                globalSettingsCategory.addVariable(new Variable("requiredPercentage", description, (Object)new Percentage(requiredPercentage, message)));
            }
        }
        catch (InstallException reqSpace) {
            // empty catch block
        }
        String fromLoc = FunctionsUtil.pathify((String)installSettings.getProductDescriptorLocation());
        description = resource.getString("INSTALL_CLIENT_SUMMARY_TITLE_SOURCE_LOC", "Source location", new Object[0]);
        Variable sourceVar = new Variable("Source", description, (Object)fromLoc);
        globalSettingsCategory.addVariable(sourceVar);
        description = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_LABEL", "Installation Type:", new Object[0]);
        String installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_INSTANTCLIENT_LABEL", "InstantClient", new Object[0]);
        String installTypeStateId = "clientInstallType";
        switch (installSettings.getInstallType()) {
            case InstantClient: {
                installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_INSTANTCLIENT_LABEL", "InstantClient", new Object[0]);
                break;
            }
            case Administrator: {
                installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_ADMINISTRATOR_LABEL", "Administrator", new Object[0]);
                break;
            }
            case Runtime: {
                installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_RUNTIME_LABEL", "Runtime", new Object[0]);
                break;
            }
            case Custom: {
                installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_CUSTOM_LABEL", "Custom", new Object[0]);
            }
        }
        if (installSettings.isUpgrading()) {
            installTypeString = resource.getString("INSTALL_CLIENT_SUMMARY_TYPE_UPGRADE_LABEL", "Upgrade", new Object[0]);
            installTypeStateId = "clientInstallMode";
        }
        Variable installType = new Variable("installType", description, (Object)installTypeString, this.isTraversableStateId(flowContext, installTypeStateId) ? installTypeStateId : "");
        globalSettingsCategory.addVariable(installType);
        if (installSettings.getInternalInstallType() != ClientInstallSettings.InstallType.InstantClient.name()) {
            description = resource.getString("INSTALL_CLIENT_SUMMARY_TITLE_ORACLE_BASE", "Oracle Base:", new Object[0]);
            Variable oracleBaseVar = new Variable("OracleBase", description, (Object)installSettings.getOracleBase(), this.isTraversableStateId(flowContext, "getOracleHome") ? "getOracleHome" : "");
            globalSettingsCategory.addVariable(oracleBaseVar);
        }
        description = resource.getString("INSTALL_CLIENT_SUMMARY_TITLE_ORACLE_HOME", "Oracle Home name:", new Object[0]);
        Variable oracleHomevar = new Variable("OracleHome", description, (Object)installSettings.getOracleHome(), this.isTraversableStateId(flowContext, "getOracleHome") ? "getOracleHome" : "");
        globalSettingsCategory.addVariable(oracleHomevar);
        PatchDownloadType downloadType = autoBean.getDownloadType();
        if (autoBean.isApplyUpdates() && downloadType != null) {
            Application app = Application.getInstance();
            Resource r = app.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
            description = r.getString("AUTO_UPDATES_OPTION_DESC", "Software updates option", new Object[0]);
            String value = r.getString((Enum)autoBean.getDownloadType(), new Object[0]);
            Variable autoUpdatesOptionsVar = new Variable("AutoUpdatesOption", description, (Object)value, this.isTraversableStateId(flowContext, "AutoUpdatesOptionsUI") ? "AutoUpdatesOptionsUI" : "");
            globalSettingsCategory.addVariable(autoUpdatesOptionsVar);
            if (autoBean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
                description = r.getString("AUTO_UPDATES_DOWNLOAD_LOC", "Pre-downloaded software updates location", new Object[0]);
                Variable autoUpdatesLoc = new Variable("AutoUpdatesDownloadLoc", description, (Object)autoBean.getPatchDownloadLocation(), this.isTraversableStateId(flowContext, "AutoUpdatesOptionsUI") ? "AutoUpdatesOptionsUI" : "");
                globalSettingsCategory.addVariable(autoUpdatesLoc);
            }
        }
        if (!InventoryInfo.getInstance().isInventoryExist()) {
            description = resource.getString("INSTALL_CLIENT_SUMMARY_INVENTORY_CATEGORY", "Inventory information", new Object[0]);
            Category inventoryDetail = new Category("inventoryDetail", description);
            summary.addCategory(inventoryDetail);
            description = resource.getString("INSTALL_CLIENT_SUMMARY_INVENTORY_LOCATION", "Inventory location.", new Object[0]);
            Variable invLoc = new Variable("invLoc", description, (Object)cenInv.getInventoryLocation(), this.isTraversableStateId(flowContext, "inventoryPage") ? "inventoryPage" : "");
            inventoryDetail.addVariable(invLoc);
            if (!PlatformInfo.getInstance().isWindows()) {
                description = resource.getString("INSTALL_CLIENT_SUMMARY_OPER_GROUP", "oraInventory group", new Object[0]);
                Variable groupVarOper = new Variable("oper", description, (Object)cenInv.getGroupOwnership(), this.isTraversableStateId(flowContext, "inventoryPage") ? "inventoryPage" : "");
                inventoryDetail.addVariable(groupVarOper);
            }
        }
        if ((customComponents = installSettings.getCustomComponents()) != null && ((String[])customComponents).length > 0) {
            for (String component : customComponents) {
                String currentCompName;
                int separator;
                if (component == null || component.length() <= 0 || (separator = component.indexOf(":")) == -1 || (currentCompName = component.substring(0, separator)) == null || !currentCompName.equalsIgnoreCase("oracle.ntoramts") || !PlatformInfo.getInstance().isWindows() || installSettings.getOraMTSPortNumber() == null || installSettings.getOraMTSPortNumber() == 0) continue;
                description = resource.getString("MTS_PORT_DESC", "OraMTS Port Number", new Object[0]);
                Variable mtsPortNumber = new Variable("OraMTSPortNumber", description, (Object)installSettings.getOraMTSPortNumber(), this.isTraversableStateId(flowContext, "mtsDialog") ? "mtsDialog" : "");
                globalSettingsCategory.addVariable(mtsPortNumber);
                break;
            }
        }
        if (PlatformInfo.getInstance().isWindows() && installSettings.getInstallType() != ClientInstallSettings.InstallType.InstantClient) {
            WindowsSecureOptionSettings secureBean = (WindowsSecureOptionSettings)flowContext.getBean(WindowsSecureOptionSettings.class);
            String serviceUserDescription = resource.getString("ORACLE_SERVICE_USER", "Oracle Service User", new Object[0]);
            String userName = null;
            userName = !secureBean.isDeclineOption() ? secureBean.getUserName() : Credentials.BuiltinUser.LOCALSERVICE.toString();
            globalSettingsCategory.addVariable(new Variable("serviceUser", serviceUserDescription, (Object)userName, this.isTraversableStateId(flowContext, "getWindowsSecureOptionDetails") ? "getWindowsSecureOptionDetails" : ""));
        }
    }

    private String readableSpace(long space) {
        String stringSpace = "";
        if ((float)space < 1024.0f) {
            stringSpace = space + " MB";
        } else {
            stringSpace = DISK_SPACE_FORMATTER.format((float)space / 1024.0f);
            stringSpace = stringSpace + " GB";
        }
        return stringSpace;
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return SummaryAction.getLastExistingParent(f.getParent().toString());
    }

    public final Route transition(FlowContext flowContext) {
        ClientSetupBean setupBean = (ClientSetupBean)((Object)flowContext.getBean(ClientSetupBean.class));
        String oracleHome = setupBean.getClientInstallSettings().getOracleHome();
        String responseFilePath = oracleHome + File.separator + InstallConstants.RESPONSE_FILE_PATH + File.separator + "client" + "_" + FunctionsUtil.getTimeStamp() + ".rsp";
        this.saveResponseFile(flowContext, responseFilePath);
        return super.transition(flowContext);
    }
}

