/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.fixup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcf.OipcfExecuteFixUpRuleException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageFixes {
    public static final String PACKAGE_SEPARATOR = "-";
    public static final String SEPARATOR = " ";
    public static final String PACKAGE_STRING = "PACKAGES";
    public static final String OCFS_TOOLS = "_OCFS_TOOLS";
    public static final String OCFS = "_OCFS";
    public static final String ENABLE_PACKAGE = "INSTALL_PACKAGES";
    public static final String BASE_URL = "RPM_BASE_URL";
    public static final String ENABLE_STRING = "\"true\"";
    public static final String EQUALS = "=";
    public static final String APOSTROPHE = "\"";
    public static final String ORACLE_PACKAGES_ENABLE = "ORACLE_PACKAGES_ENABLE";
    public static final String ORACLE_RPM_LOCATION = "ORACLE_RPM_LOCATION";
    public static final String ORACLE_PACKAGES = "ORACLE_PACKAGES";
    public static final String EXPORT_RPM_VARS = "EXPORT_RPM_VARS";

    public static OipcfFixUpResult enablePackageInstall(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return PackageFixes.enableAllPackageInstall(re, refhost, res, outfiles, "");
    }

    public static OipcfFixUpResult enableOCFSToolsInstall(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return PackageFixes.enableAllPackageInstall(re, refhost, res, outfiles, OCFS_TOOLS);
    }

    public static OipcfFixUpResult enableOCFSInstall(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles) {
        return PackageFixes.enableAllPackageInstall(re, refhost, res, outfiles, OCFS);
    }

    public static OipcfFixUpResult enableAllPackageInstall(OipcrIRulesEngine re, String refhost, OipcrIResult res, ArrayList outfiles, String spPkg) {
        OipcfFixUpResult oFixUpResult;
        String sResponseFile = (String)outfiles.get(0);
        String sEnableFile = (String)outfiles.get(1);
        String baseUrl = null;
        if (sResponseFile == null || !new File(sResponseFile).exists()) {
            OipcfFixUpResult oFixUpResult2 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-002", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-002")), (List)outfiles);
            return oFixUpResult2;
        }
        if (sEnableFile == null || !new File(sEnableFile).exists()) {
            OipcfFixUpResult oFixUpResult3 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-001", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-001")), (List)outfiles);
            return oFixUpResult3;
        }
        StringBuffer sPackageBuffer = new StringBuffer();
        Iterator iter = null;
        if (res != null) {
            iter = res.getResultDetails();
        } else {
            OipcfFixUpResult oFixUpResult4 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-003", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-003")), (List)outfiles);
            return oFixUpResult4;
        }
        while (iter.hasNext()) {
            OipcrResultDetails oResultDetails = (OipcrResultDetails)iter.next();
            if (oResultDetails.getResult() == 1) continue;
            String sExpectedPackage = (String)oResultDetails.getExpectedData();
            if (sExpectedPackage == null) {
                OipcfFixUpResult oFixUpResult5 = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException("FIXUP-004", OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-004")), (List)outfiles);
                return oFixUpResult5;
            }
            if (spPkg.equals("")) {
                int nIndex = sExpectedPackage.indexOf(PACKAGE_SEPARATOR);
                if (nIndex != -1) {
                    sExpectedPackage = sExpectedPackage.substring(0, nIndex);
                }
            } else {
                try {
                    baseUrl = PackageFixes.getBaseURL(re, refhost, spPkg);
                }
                catch (Exception e) {
                    baseUrl = null;
                }
            }
            sPackageBuffer.append(sExpectedPackage);
            sPackageBuffer.append(SEPARATOR);
        }
        try {
            PackageFixes.instantiateEnableFile(sEnableFile, spPkg, true);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        try {
            PackageFixes.instantiateResponseFile(sResponseFile, sPackageBuffer.toString(), spPkg, baseUrl);
        }
        catch (IOException e) {
            oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), (List)outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateEnableFile(String sEnableFile, String spPkg, boolean addEnableString) throws IOException {
        String line;
        String enablePackage = addEnableString ? ENABLE_PACKAGE + spPkg : spPkg;
        File oFile = new File(sEnableFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheck = false;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (!line.startsWith(enablePackage)) continue;
            line = enablePackage + EQUALS + ENABLE_STRING;
            fileContentsList.set(i, line);
            bCheck = true;
            break;
        }
        if (!bCheck) {
            line = enablePackage + EQUALS + ENABLE_STRING;
            fileContentsList.add(line);
        }
        try {
            PackageFixes.writeToFile(sEnableFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sEnableFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void instantiateResponseFile(String sResponseFile, String packageNames, String spPkg, String baseUrl) throws IOException {
        String packageString = PACKAGE_STRING + spPkg;
        String baseUrlString = BASE_URL + spPkg;
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        boolean bCheckPackage = false;
        boolean bCheckUrl = baseUrl == null;
        for (int i = 0; i < fileContentsList.size(); ++i) {
            line = (String)fileContentsList.get(i);
            if (line.startsWith(packageString)) {
                line = packageString + EQUALS + APOSTROPHE + packageNames + APOSTROPHE;
                fileContentsList.set(i, line);
                bCheckPackage = true;
            }
            if (line.startsWith(baseUrlString)) {
                line = baseUrlString + EQUALS + APOSTROPHE + baseUrl + APOSTROPHE;
                fileContentsList.set(i, line);
                bCheckUrl = true;
            }
            if (bCheckPackage && bCheckUrl) break;
        }
        if (!bCheckPackage) {
            line = packageString + EQUALS + APOSTROPHE + packageNames + APOSTROPHE;
            fileContentsList.add(line);
        }
        if (!bCheckUrl && baseUrl != null) {
            line = baseUrlString + EQUALS + APOSTROPHE + baseUrl + APOSTROPHE;
            fileContentsList.add(line);
        }
        try {
            PackageFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }

    private static void writeToFile(String sFile, ArrayList fileContentsList) throws IOException {
        File oFile = new File(sFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(oFile));
        for (int i = 0; i < fileContentsList.size(); ++i) {
            String line = (String)fileContentsList.get(i);
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }

    private static String getBaseURL(OipcrIRulesEngine re, String sRefFile, String spPkg) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)re.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)re.getKnowledgeSource("sessioncontext");
        Node oLocationsNode = oGenRefHost.getNode("LOCS");
        if (oLocationsNode != null) {
            NodeList oNodes = oLocationsNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("LOC")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sLocVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_LOC_UNDER_LOCS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_LOC_UNDER_LOCS", (Object[])args));
                        }
                        sLocVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sLocVar);
                        if (oVar == null) continue;
                        String sLoc = (String)oVar.getValue();
                        return sLoc;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_LOC_UNDER_LOCS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_LOC_UNDER_LOCS", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_LOCS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_LOCS_INFO", (Object[])args));
        }
        return null;
    }

    public static OipcfFixUpResult enableOraclePackages(String enableFile, String responseFile, Map envVars, String rpmLocation, String[] pkgsToInstall) {
        ArrayList<String> outfiles = new ArrayList<String>();
        outfiles.add(enableFile);
        outfiles.add(responseFile);
        try {
            PackageFixes.instantiateEnableFile(enableFile, ORACLE_PACKAGES_ENABLE, false);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), outfiles);
            return oFixUpResult;
        }
        ArrayList<String> oParamValueList = new ArrayList<String>();
        String listEnvVarName = null;
        if (envVars != null && !envVars.isEmpty()) {
            for (String key : envVars.keySet()) {
                String value = (String)envVars.get(key);
                String param = key + EQUALS + APOSTROPHE + value + APOSTROPHE;
                oParamValueList.add(param);
                if (listEnvVarName != null) {
                    listEnvVarName = listEnvVarName + SEPARATOR + key;
                    continue;
                }
                listEnvVarName = key;
            }
        }
        String slistEnvVarName = "EXPORT_RPM_VARS=\"" + listEnvVarName + APOSTROPHE;
        oParamValueList.add(slistEnvVarName);
        String srpmLocation = "ORACLE_RPM_LOCATION=\"" + rpmLocation + APOSTROPHE;
        oParamValueList.add(srpmLocation);
        String spkgsToInstall = null;
        if (pkgsToInstall != null && pkgsToInstall.length > 0) {
            spkgsToInstall = "ORACLE_PACKAGES=\"" + OiixFunctionOps.implodeList((String[])pkgsToInstall, (String)SEPARATOR) + APOSTROPHE;
            oParamValueList.add(spkgsToInstall);
        }
        try {
            PackageFixes.instantiateResponseFile(responseFile, oParamValueList);
        }
        catch (IOException e) {
            OipcfFixUpResult oFixUpResult = new OipcfFixUpResult(OipcfFixUpResult.FAILED, (OiixException)new OipcfExecuteFixUpRuleException((Throwable)e), outfiles);
            return oFixUpResult;
        }
        return new OipcfFixUpResult(OipcfFixUpResult.PASSED);
    }

    private static void instantiateResponseFile(String sResponseFile, List paramValueList) throws IOException {
        File oFile = new File(sResponseFile);
        BufferedReader br = new BufferedReader(new FileReader(oFile));
        ArrayList<String> fileContentsList = new ArrayList<String>();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                fileContentsList.add(line);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-005", (Object[])args));
        }
        ArrayList<String> oAbsentParamList = new ArrayList<String>();
        for (int i = 0; i < paramValueList.size(); ++i) {
            boolean bCheck = false;
            String sResultString = (String)paramValueList.get(i);
            String sCompareString = sResultString.substring(0, sResultString.indexOf(EQUALS));
            for (int j = 0; j < fileContentsList.size(); ++j) {
                line = (String)fileContentsList.get(j);
                if (!line.startsWith(sCompareString)) continue;
                line = sResultString;
                fileContentsList.set(j, line);
                bCheck = true;
                break;
            }
            if (bCheck) continue;
            oAbsentParamList.add(sResultString);
        }
        fileContentsList.addAll(oAbsentParamList);
        try {
            PackageFixes.writeToFile(sResponseFile, fileContentsList);
        }
        catch (IOException e) {
            Object[] args = new String[]{sResponseFile};
            throw new IOException(OiixResourceBundle.getString((String)"oracle.sysman.prov.fixup.resources.FixUpRuntimeRes", (String)"FIXUP-006", (Object[])args));
        }
    }
}

