/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.helper.helper18;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.helper.CVUHelperConstants;
import oracle.ops.verification.helper.helper18.CommandLineOption;

public abstract class CVUHelper
implements CVUHelperConstants {
    private static String CV = "cv";
    private static String LOG = "log";
    private static String[] m_args;
    private static String TRACE_CVUHELPER_FNAME;
    private static String m_localHost;
    private ArrayList<CommandLineOption> m_cmdLineOptList = null;

    public CVUHelper() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
            Trace.out((String)"Security manager is set");
        }
        this.m_cmdLineOptList = new ArrayList();
    }

    public void addCommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
        CommandLineOption cmdOpt = new CommandLineOption(key, numberOfArgs, methodName, usageInfo);
        this.m_cmdLineOptList.add(cmdOpt);
    }

    void displayUsage(boolean isDisplayError) {
        this.displayUsage(isDisplayError, null);
    }

    void displayUsage(boolean isDisplayError, String message) {
        String invalidCommand = "Invalid commandline argument: " + message;
        String usageString = "USAGE:" + LSEP;
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            String curOpt = cmdOpt.getKey();
            String usageInfo = cmdOpt.getUsageInfo();
            usageString = usageString + "    " + curOpt + "  : " + usageInfo + LSEP;
        }
        if (isDisplayError) {
            if (message != null && message.trim().length() > 0) {
                usageString = invalidCommand + LSEP + usageString;
            }
            this.displayExecutionError(usageString);
        }
    }

    private void displayUsage(String curOpt) {
        String usageInfo = null;
        String usageString = "Incorrect arguments to option " + curOpt + LSEP + "USAGE:" + LSEP;
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            if (!curOpt.equalsIgnoreCase(cmdOpt.getKey())) continue;
            usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (usageInfo == null) {
            this.displayExecutionError("Incorrect commandline option : " + curOpt);
            return;
        }
        usageString = usageString + "    " + curOpt + "  : " + usageInfo;
        this.displayErrorResult(usageString);
    }

    public String parseArguments(String[] args) {
        boolean argsOK = false;
        boolean found = false;
        String methodName = null;
        int numberOfArgs = -1;
        String curOpt = null;
        if (args.length < 1) {
            this.displayUsage(true);
            return null;
        }
        Trace.out((String)"more than one arg found");
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            curOpt = cmdOpt.getKey();
            if (!curOpt.equalsIgnoreCase(args[0])) continue;
            found = true;
            methodName = cmdOpt.getMethodName();
            numberOfArgs = cmdOpt.getNumberOfArgs();
            String usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (found) {
            if (numberOfArgs != 1 && args.length != numberOfArgs) {
                Trace.out((String)"incorrect number of arguments");
                this.displayUsage(args[0]);
                this.displayVRESStatus(2);
                this.displayExecutionErrorStatus();
                return null;
            }
        } else {
            Trace.out((String)"option not supported");
            this.displayUsage(true, args[0]);
            return null;
        }
        return methodName;
    }

    public void displaySuccessResult(String rslt) {
        System.out.println("<CVH_OUT>");
        System.out.println(rslt);
        System.out.println("</CVH_OUT>");
    }

    public void displaySuccessResult(String rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displayWarningResult(String warning) {
        System.out.println("<CVH_WMSG>");
        System.out.println(warning);
        System.out.println("</CVH_WMSG>");
    }

    public void displayWarningResult(String warning, int status) {
        this.displayWarningResult(warning);
        this.displayVRESStatus(status);
    }

    public void displayErrorResult(String errMsg) {
        System.out.println("<CVH_EMSG>");
        System.out.println(errMsg);
        System.out.println("</CVH_EMSG>");
    }

    public void displayErrorResult(String errMsg, int status) {
        this.displayErrorResult(errMsg);
        this.displayVRESStatus(status);
    }

    public void displayVRESStatus(int status) {
        System.out.println("<CVH_VRES>" + status + "</CVH_VRES>");
    }

    public void displayExecutionError(String errMsg) {
        System.out.println("<CVH_EMSG>");
        System.out.println(errMsg);
        System.out.println("</CVH_EMSG>");
        System.out.println("<CVH_ERES>2</CVH_ERES>");
    }

    public void displayExecutionErrorStatus() {
        System.out.println("<CVH_ERES>2</CVH_ERES>");
    }

    public void displayExecutionSuccess() {
        System.out.println("<CVH_ERES>0</CVH_ERES>");
    }

    public static void setupTracing() {
        int tracingLvl;
        boolean bAppend;
        String traceFileName;
        String traceProp = System.getProperty("TRACING.ENABLED");
        String traceLvl = System.getProperty("TRACING.LEVEL");
        boolean tracetostdout = false;
        boolean saveTraceState = false;
        if (traceProp != null && traceProp.equalsIgnoreCase("false")) {
            Trace.setSavePreviousLog((boolean)false);
            return;
        }
        if (null != System.getProperty("TRACING.STDOUT")) {
            tracetostdout = true;
        }
        System.setProperty("TRACING.ENABLED", "true");
        if (!tracetostdout) {
            saveTraceState = Trace.isTraceEnabled();
            Trace.traceEnabled((boolean)false);
        }
        if ((traceFileName = CVUHelper.getTraceFile()) == null) {
            Trace.traceEnabled((boolean)false);
            return;
        }
        boolean bSavePreviousLog = CVUHelper.isCVUTestEnv();
        boolean bl = bAppend = !bSavePreviousLog;
        if (!tracetostdout) {
            Trace.traceEnabled((boolean)saveTraceState);
        }
        Trace.setSavePreviousLog((boolean)bSavePreviousLog);
        if (traceLvl != null) {
            try {
                tracingLvl = Integer.parseInt(traceLvl);
            }
            catch (NumberFormatException e) {
                tracingLvl = 5;
            }
        } else {
            tracingLvl = 5;
        }
        Trace.enableTracing();
        Trace.setMaxLogOutputSize((int)100);
        Trace.setMaxLogOutputFiles((int)4);
        Trace.setTraceProcessOption((boolean)true);
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true, (boolean)bAppend);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }

    private static String getTraceFile() {
        String cvHome = System.getProperty("CV_HOME");
        String logDirStr = cvHome + FSEP + CV + FSEP + LOG;
        String prop = System.getProperty("CV_TRACELOC");
        if (prop == null || prop.trim().length() <= 0) {
            prop = System.getenv("CV_TRACELOC");
        }
        if (prop != null && prop.trim().length() > 0) {
            logDirStr = prop;
        } else {
            String orabaseExe = new SystemFactory().CreateSystem().getExeName("orabase");
            String orabasePath = cvHome + FSEP + "bin" + FSEP + orabaseExe;
            File oraBase = new File(orabasePath);
            if (oraBase.exists()) {
                String[] output = null;
                String[] cmd = new String[]{orabasePath};
                RuntimeExec rt = new RuntimeExec(cmd, null, null);
                rt.runCommand();
                String[] error = rt.getError();
                output = rt.getOutput();
                if (rt.getExitValue() == 0 && (error == null || error.length == 0) && output != null && output.length == 1 && m_localHost != null && m_localHost.length() > 0) {
                    logDirStr = output[0] + FSEP + "crsdata" + FSEP + m_localHost.toLowerCase() + FSEP + "cvu";
                }
            }
        }
        File logDir = new File(logDirStr);
        if (!logDir.exists() && !logDir.mkdirs()) {
            return null;
        }
        if (!logDir.canWrite()) {
            return null;
        }
        return logDirStr + FSEP + TRACE_CVUHELPER_FNAME;
    }

    protected static String getLocalHost() throws UnknownHostException {
        if (m_localHost != null) {
            return m_localHost;
        }
        String longHostName = null;
        longHostName = InetAddress.getLocalHost().getHostName();
        int dotIdx = longHostName.indexOf(".");
        m_localHost = dotIdx != -1 ? longHostName.substring(0, dotIdx) : longHostName;
        Trace.out((String)("Hostname retrieved:" + longHostName + ", returned: " + m_localHost));
        return m_localHost;
    }

    public static boolean isCVUTestEnv() {
        String sysprop = System.getProperty("CVU_TEST_ENV");
        if (sysprop == null || sysprop.trim().length() <= 0) {
            sysprop = System.getenv("CVU_TEST_ENV");
        }
        return Boolean.parseBoolean(sysprop);
    }

    public String strArr2List(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < strArr.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    static {
        TRACE_CVUHELPER_FNAME = "cvuhelper.log";
        m_localHost = null;
    }
}

