@echo off

REM #
REM # Copyright (c) 2001 Oracle Corporation.  All rights reserved.
REM #
REM # PRODUCT
REM #   OID Provisioning Tool
REM #
REM # FILENAME
REM #   oidprovtool.bat
REM #
REM # DESCRIPTION
REM #   This script is used to launch the provisioning tool
REM #
REM # NOTE:
REM #   This script is typically invoked as follows:
REM #
REM #

SETLOCAL

REM  Make sure that our JRE is used for this invocation.
IF Windows_NT == %OS% SET PATH=%s_JRE_LOCATION%\bin;%ORACLE_HOME%\bin;%PATH%
IF not Windows_NT == %OS% SET PATH="%s_JRE_LOCATION%\bin;%ORACLE_HOME%\bin;%PATH%"

REM Set class path
SET CLASSROOT=%ORACLE_HOME%\classes
SET LDAPJCLNT18=%ORACLE_HOME%\jlib\ldapjclnt18.jar
SET NETCFG=%ORACLE_HOME%\jlib\netcfg.jar
SET JNDIJARS=%ORACLE_HOME%\jlib\ldap.jar;%ORACLE_HOME%\jlib\jndi.jar;%ORACLE_HOME%\jlib\providerutil.jar

REM make sure ldapjclnt18.jar is present
IF NOT EXIST %LDAPJCLNT18% GOTO NO_LDAPJCLNT18JAR_FILE

SET CLASSPATHADD=%LDAPJCLNT18%;%JNDIJARS%;%CLASSROOT%;%NETCFG%;

SET JRE=jre -nojit
SET CLASSPATH_QUAL=cp

IF "%ORACLE_OEM_JAVARUNTIME%x" == "x" GOTO JRE_START
SET JRE=%ORACLE_OEM_JAVARUNTIME%\bin\java -nojit
SET CLASSPATH_QUAL=classpath
SET CLASSPATHADD=%CLASSPATHADD%;%ORACLE_OEM_JAVARUNTIME%\lib\classes.zip
SET CLASSPATHADD=%CLASSPATHADD%;%ORACLE_HOME%\jlib\javax-ssl-1_2.jar
SET CLASSPATHADD=%CLASSPATHADD%;%ORACLE_HOME%\jlib\jssl-1_2.jar
SET CLASSPATHADD=%CLASSPATHADD%;%ORACLE_HOME%\j2ee\home\jps-api.jar;%ORACLE_HOME%\j2ee\home\jps-internal.jar

:JRE_START

%ORACLE_HOME%\jdk\bin\java -Xms48m -Xmx256m -%CLASSPATH_QUAL% %CLASSPATHADD% -DORACLE_HOME=%ORACLE_HOME%  oracle.ldap.util.provisioning.ProvisioningProfile %*

GOTO THE_END

:NO_LDAPJCLNT18JAR_FILE
   ECHO Missing jar file
   ECHO %LDAPJCLNT18% not found
   GOTO THE_END

:THE_END
   ENDLOCAL
