#ifdef RCSID
static char *RCSid = 
   "$ oa.h Release 12.2.1.3.0 $ ";
#endif /* RCSID */


/* Copyright (c) 1989, 2017, Oracle and/or its affiliates. 
All rights reserved.*/

/*
NAME
  OA.H - OA generic header file
DESCRIPTION
NOTES
MODIFIED
*/

#ifndef OA
#define OA

#ifndef SOA
#include <soa.h>
#endif

#ifndef OAXM
#include <oaxm.h>
#endif

#ifndef OAMST
#include <oamst.h>
#endif

/*
**  OA return codes
*/
#define OA_SUCC   0       /* success */
#define OA_FAIL  -1       /* operation failed */
#define OA_WARN  -2       /* operation had problems */
#define OA_FTL   -3       /* operation completely bombed */

/* If this an error */
#define OA_ISERR(rc) ((rc) != OA_SUCC)

/*
**  Types of memory to alloc for OA memory manager
*/
#define OAMM_STD  0       /* common, ordinary type */
#define OAMM_TXT  1       /* short text buffer, < 256 bytes */

/*
**  Debug macros
*/
#define OA_DBG_DEBUG  ((uword)1 << 0) /* random debug information */
#define OA_DBG_STATS  ((uword)1 << 1) /* record status information */
#define OA_DBG_MON    ((uword)1 << 2) /* monitor process (eg. read/write io) */
#define OA_DBG_FLAKY  ((uword)1 << 3) /* make module return random errors */

/*
**  OA common alloc function
*/
#define oaalcm(lcx,type,size) soamalc(size)

/*
**  OA alloc standard memory function (would basically end up in malloc)
*/
#define oaallc(lcx,size) oaalcm(lcx,OAMM_STD,size)

/*
**  OA alloc short text function
*/
#define oaalct(lcx,size) oaalcm(lcx,OAMM_TXT,size)


/*
**  OA common re-alloc function
*/
#define oarelm(lcx,type,ptr,size) soareal(ptr,size)

/*
**  OA re-alloc standard memory function (would basically end up in realloc)
*/
#define oareal(lcx,ptr,size) oarelm(lcx,OAMM_STD,ptr,size)


/*
**  OA common free function
*/
#define oafrem(lcx,type,size) soafree(size)

/*
**  OA free standard memory function
*/
#define oafree(lcx,size) oafrem(lcx,OAMM_STD,size)

/*
**  OA free short text memory function
*/
#define oafret(lcx,size) oafrem(lcx,OAMM_TXT,size)

/*--------------------------------------------------------------------------*/

#endif  /* OA */
