/*
 * $ dsi.h Release 12.2.1.3.0 $ 
 */

/* Copyright (c) 1991, 2017, Oracle and/or its affiliates. 
All rights reserved.*/
/*
   NAME
     dsi.h - The DS Interface library external header
   DESCRIPTION
     <short description of component this file declares/defines>
   PUBLIC FUNCTION(S)
     <list of external functions declared/defined - with one-line descriptions>
   PRIVATE FUNCTION(S)
     <list of static functions defined in .c file - with one-line descriptions>
   RETURNS
     <function return values, for .c file with single function>
   NOTES
     <other useful comments, qualifications, etc.>
   MODIFIED   (MM/DD/YY)
*/

/***********************************************************************
 *
 *  DSI.H
 *
 *  Header file for Interoffice DS api functions
 *
 ***********************************************************************/


#ifndef DSI_H
#define DSI_H

/**********************  Field length constants ************************/
#define DSI_MAXSIZE_UNAM    30
#define DSI_MAXSIZE_NAME    80
#define DSI_MAXSIZE_ADDR    255
#define DSI_MAXSIZE_DESC    255
#define DSI_MAXSIZE_ATTR    255

/* Structure for transferring directory object information */

typedef struct
{
    text    rszName_dsiobj[DSI_MAXSIZE_NAME + 1];    /* display name */
    text    rszAddr_dsiobj[DSI_MAXSIZE_ADDR + 1];    /* e-mail address */
                                                     /* an item ID for DLs */
    text    rszDesc_dsiobj[DSI_MAXSIZE_DESC + 1];    /* description */
    ub4     ulObjID_dsiobj;                          /* DS local objectid */
}   dsiobj;

/* dsiobj same-size struct for persons which places first/last name fields in
   unused portion of the address field, for person address is username (30) */
typedef struct
{
    text    rszName_dsiobjp [ DSI_MAXSIZE_NAME+1 ];  /* display name         */
    text    rszAddr_dsiobjp [ DSI_MAXSIZE_UNAM+1 ];  /* e-mail addr|DL item  */
    text    rszPhone_dsiobjp[ DSI_MAXSIZE_UNAM+1 ];  /* phone number         */
    text    rszFName_dsiobjp[ DSI_MAXSIZE_NAME+1 ];  /* ptr to first name    */
    text    rszLName_dsiobjp[ DSI_MAXSIZE_NAME+1 ];  /* ptr to last name     */
    text    rszPad_dsiobjp  [ 32 ];  /* pad remaining space to max addr size */
    text    rszDesc_dsiobjp [ DSI_MAXSIZE_DESC+1 ];  /* description          */
    ub4     ulObjID_dsiobjp;                         /* DS local objectid    */
} dsiobjp;


/* Search Condition Descriptor */

typedef struct
{
    ub4     ulAttrID_dsiscd;        /* Identifier of attribute to search on */
    ub1     ubOpID_dsiscd;          /* Operator Identifier */
    text    rszSearchVal_dsiscd[DSI_MAXSIZE_ATTR];/* Value of the attribute */

} dsiscd;


/* Object Information */

typedef struct
{
    ub4     ulNumAttrs_dsioinf;     /* Number of attributes returned */
    text  **lppszAttrs_dsioinf;     /* Ptr to array of attr value strings */
    uword    *pulAtIDs_dsioinf;      /* Ptr to array of attr identifiers */
} dsioinf;

/****************** Object Class Identifiers *********************/

#define DSIOCI_PRIVATE_ALIASES    1
#define DSIOCI_PUBLIC_ALIASES     2
#define DSIOCI_PRIVATE_DLS        3
#define DSIOCI_PUBLIC_DLS         4
#define DSIOCI_PERSONS            5
#define DSIOCI_GATEWAYS           6
#define DSIOCI_LOCATIONS          7
#define DSIOCI_ORGANIZATIONS      8
#define DSIOCI_ROLES              9
#define DSIOCI_ROOMS              10
#define DSIOCI_EQUIPMENT          11
#define DSIOCI_DOMAINS            12
#define DSIOCI_FIRST_TYPE         DSIOCI_PRIVATE_ALIASES
#define DSIOCI_LAST_TYPE          DSIOCI_DOMAINS

/****************** Object Attribute Identifiers *********************/

#define DSIOAI_GENERAL_NAME       0
#define DSIOAI_OBJECT_TYPE        1
#define DSIOAI_OBJECT_NAME        2
#define DSIOAI_OBJECT_MANAGER     3

/***************** Object Attribute Value Type  *********************/
/***** Used to associate data type with a data value ****************/
#define DSIOAVT_UB4               1
#define DSIOAVT_TEXT              2

/****************** Search Operation Identifiers *********************/

#define DSISOI_BEGINS_WITH      1   /* DSXLOPAW */
#define DSISOI_EQUALS           4   /* DSXLOPNO */
#define DSISOI_CONTAINS         8   /* DSXLOPCN */

/****************** Result of Name Resolution ***********************/

#define DSINR_RESOLVED          1
#define DSINR_UNRESOLVED        2
#define DSINR_AMBIGUOUS         3

/************** Object Attribute Value Descriptor ******************/
typedef struct
{
  ub4   dsiads_oavt;           /* Object Attribute Value Type */
  union   
    {
      ub4     ddataval;          /* Data value directly contained  */
      dvoid  *pdataval;          /* Data value pointed to by a ptr */
    } dsiads_val;
} dsiads;

/**************** Object Attribute  ********************************/
typedef struct
{
  ub4      dsiatr_oai;            /* Object Arribute ID */
  dsiads   dsiatr_dsc;            /* Object Attribute Descriptor */
} dsiatr;


/**************** Prototypes for the functions in dsi.c **************/


void dsiVersion(/*_             text *    lpszVersion _*/);

/* 
** dsilogon():  DS Context handle will be a dvoid pointer,
** which can be cast to s_handle (dstctx) or dsctx (dsts *)
*/

ub4 dsiLogon (/*_               text *    lpszUsername, 
                                text *    lpszPassword,
                                text *    lpszConnect, 
                                dvoid **  lppDSContext _*/);

ub4 dsiLogonInfRet (/*_         text *    lpszUsername,
                                text *    lpszPassword,
                                text *    lpszConnect,
                                dvoid **  lppDSContext,
                                text *    lpszErrString,
                                ub4 *     lpLowVersion,
                                ub4 *     lpHighVersion _*/);
                    /* Note: lpszErrString should be DS_VNAME bytes long */

ub4 dsiRelease (/*_             dvoid *   lpDSContext _*/);

ub4 dsissSearchStart (/*_       dvoid *    lpvDSContext, 
                                ub4        ulTypeOrOID, 
                                dsiscd *   lpszSearch,
                                ub4 *      lpulNbrRows, 
                                dsiobj     ObjList[],
                                dvoid **    lpvListContext _*/);

ub4 dsiscSearchContinue (/*_    dvoid *   lpvListContext, 
                                dsiobj    ObjList[],
                                ub4 *     lpulNbrRows _*/);

ub4 dsisfSearchFinish (/*_      dvoid * lpvListContext _*/);

ub4 dsidlfsDLFetchStart (/*_    dvoid *    lpvDSContext, 
                                ub4        ulTypeOrOID, 
                                ub4 *      lpulNbrRows, 
                                dsiobj     ObjList[],
                                dvoid **    lpvListContext _*/);

ub4 dsidlfcDLFetchContinue (/*_ dvoid *   lpvListContext, 
                                dsiobj    ObjList[],
                                ub4 *     lpulNbrRows _*/);

ub4 dsidlffDLFetchFinish (/*_   dvoid * lpvListContext _*/);

ub4 dsiGetInfo (/*_             dvoid *    lpvDSContext, 
                                ub1        bType,
                                ub4        ulObjID, 
                                dsioinf *  lpObjInfo  _*/);

ub4 dsiRelInfo (/*_             dvoid *    lpvDSContext,
                                dsioinf *  lpObjInfo   _*/);

ub4 dsiaePrivAliasEdit (/*_     dvoid *    lpvDSContext, 
                                text *     lpszOldName,
                                text *     lpszNewName, 
                                text *     lpszNewAddr,
                                text *     lpszNewDesc _*/);

ub4 dsiaaPrivAliasAdd (/*_      dvoid *   lpvDSContext,
                                text *    lpszName,
                                text *    lpszAddr,
                                text *    lpszDesc,
                                ub4 *     lpulOID _*/);

ub4 dsiadPrivAliasDel (/*_      dvoid *   lpvDSContext,
                                text *    lpszName,
                                text *    lpszAddr,
                                text *    lpszDesc _*/);

ub4 dsidePrivDLEdit (/*_        dvoid *   lpvDSContext,
                                text *    lpszOldName,
                                text *    lpszNewName,
                                text *    lpszNewDesc,
                                ub4       ulObjectID _*/);

ub4 dsidaPrivDLAdd (/*_         dvoid *    lpvDSContext, 
                                text *     lpszName,
                                text *     lpszDesc, 
                                ub4 *      lpulOID _*/);

ub4 dsiddPrivDLDel (/*_         dvoid *    lpvDSContext, 
                                text *     lpszName,
                                ub4        ulObjectID _*/);

ub4 dsimaPrivDLMemberAdd (/*_   dvoid *   lpvDSContext,
                                text *    lpszName,
                                ub4 *     lpulOID,
                                ub4 *     lpulItemID,
                                text *    lpszDesc,
                                ub4       ulMbrCount,
                                text **   lppszMembers,
                                ub4 *     lpulMbrItems _*/);

ub4 dsimdPrivDLMemberDel (/*_   dvoid *    lpvDSContext, 
                                text *     lpszName,
                                text *     lpszMember, 
                                ub4        ulObjectID _*/);

ub4 dsispwSetPassword (/*_  dvoid * lpvDSContext,
                            text *  lpszOldPassword,
                            text *  lpszNewPassword _*/);

ub4 dsiGetAttrs(/*_ dvoid     *lpDSContext,
	   	    ub4        lobjid,
		    ub4        lnoAtrIds,
		    ub4       *lpAtrIds,
		    ub4       *lnoAtrs,
		    dsiatr    **lppAtrs _*/);

ub4 dsifree (/*_   dvoid    *lpvDSContext,
                   dvoid    *lptrToFree _*/);

/*
   the following two function's definition is nowhere to be found
   neither has it been invoked anywhere.  That's why, commenting
   it out in order to take care of Olint errors.
*/
#ifdef NEVER
ub4
dsiNameRes(/*_ dsts    *lpDSContext,    
	       text    *lpName,      
	       ub1     *lptype,      
	       dsoid   *lpoid,       
	       ub4     *lpStatusResolve _*/);
#endif

/* Please avoid using dsigpooGetPersonOrOrg; use dsigoaGetObjAts instead! */
ub4 /* Get Object's Attributes */
dsigoaGetObjAts(/*_  dvoid *    lpvDSContext,
                     ub1        bType,
                     ub4        ulObjID,
                     dsioinf *  pOInf        _*/);
ub4 /* Get Person Or Organization */
dsigpooGetPersonOrOrg (/*_ dvoid *    lpvDSContext,
                           ub4        ulObjID,
                           bool       boolPerson,
                           dsioinf *  lpObjInfo _*/);


#endif /* DSI_H */
