#ifdef RCSID
static char *RCSid =
   " $ oaos.h Release 12.2.1.3.0 $ ";
#endif /* RCSID */

/* Copyright (c) 1991, 2017, Oracle and/or its affiliates. 
All rights reserved.*/


/*
NAME
  oaos.h	-- Oracle Office Start/Stop header file
PURPOSE
  Facility to start and stop Oracle Office configured processes.
PUBLIC FUNCTIONS:
  oaos		-- Oracle Office Start/Stop routine
  oaospa	-- parse command line arguments
  oaospr	-- prompt user for password
  oaosset	-- generate arguments for spawning child process
  oaoscmp	-- Oracle Office Start/Stop CoMPare argument
  oaosimh	-- Oracle Office Start/Stop Init Message Handler
  oaosdin	-- Daemon INitialize
  oaosdgl	-- get daemon list param (from ds_proc_params table)
  oaosdgp	-- get daemon param (from oo_proc_params table)
  oaosdap	-- check for daemon Active or Passive
  oaoscnt       -- count active agents for current class
  oaosdts	-- daemon TimeStamp
  oaosdps	-- daemon process status
  oaosgns	-- get node state
NOTES

MODIFIED
*/




#ifndef OAOS
#define OAOS

#ifndef S
#include <s.h>
#endif

#ifndef OAXM
#include <oaxm.h>
#endif 

#ifndef LDX
#include <ldx.h>
#endif 

#ifndef OAMH
#include <oamh.h>
#endif 

#ifndef OACM
#include <oacm.h>
#endif



#define OAOS_STRING_SIZE	256		/* size of string parameters */


struct oaosa		            /* attribute structure for parse routine */
{
    ub4		imask_oaosa;	    /* flags indicating allowable attributes,
				       set by caller */
    ub4		omask_oaosa;	    /* flags indicating specified attributes,
				       set by parse routine */
#define OAOSA_SPAWNED	(ub4)0X0001
#define OAOSA_CLASS	(ub4)0x0002
#define OAOSA_INSTANCE	(ub4)0x0004
#define OAOSA_PASSWORD	(ub4)0x0008
#define OAOSA_CONNECT	(ub4)0x0010
#define OAOSA_ACTION	(ub4)0x0020
#define OAOSA_MODE	(ub4)0x0040
#define OAOSA_FACILITY	(ub4)0x0080
#define OAOSA_FLAGS	(ub4)0x0100
#define OAOSA_REMOTE	(ub4)0x0200
#define OAOSA_VERBOSE	(ub4)0x0400
    ub4		ign_oaosa; /* bit array set for unparsed parms in argv[0-31] */
    ub1		erridx_oaosa;	 /* first argv index where parse failed or 0 */
    ub1		pwdidx_oaosa;	      /* 1-relative index of password arg,
					 to be used as argument to siutli()  */
    ub1		spawned_oaosa;				   /* spawned=yes|no */
    ub1		verbose_oaosa;				   /* verbose=yes|no */
    sword	class_oaosa;				     /* class=number */
    sword	instance_oaosa;				  /* instance=number */
    text	password_oaosa[OAOS_STRING_SIZE];	  /* password=string */
    text	connect_oaosa[OAOS_STRING_SIZE];	   /* connect=string */
    text	action_oaosa[OAOS_STRING_SIZE];		    /* action=string */
    text	mode_oaosa[OAOS_STRING_SIZE];		      /* mode=string */
    text	facility_oaosa[OAOS_STRING_SIZE];	  /* facility=string */
    text	flags_oaosa[OAOS_STRING_SIZE];		     /* flags=string */
    text	remote_oaosa[OAOS_STRING_SIZE];		    /* remote=string */
};
typedef struct oaosa oaosa;


struct oaoscx			      /* context for daemon management calls */
{
    sword	class_oaoscx;		/* daemon class id */
    sword	instance_oaoscx;	/* daemon instance id */
    ub4		state_oaoscx;		/* om_cur_node.state (see below) */
    sb4		runindex_oaoscx;	/* om_cur_node.run_index */
    sb4		debug_oaoscx;		/* om_cur_node.debug */
    sword	starttime_oaoscx;	/* oo_proc_time.start_time (0..23)*/
    sword	duration_oaoscx;	/* oo_proc_time.duration (hours) */
    sword	remaintime_oaoscx;	/* minutes till start of next period */
    text	runflag_oaoscx;		/* oo_proc_time.run_flag */
    sb4		sleeptime_oaoscx;	/* oo_proc_time.sleep_time (mins) */
    text	infoflag_oaoscx[241];	/* oo_proc_time.info_flag */
};
typedef struct oaoscx oaoscx;


/*--------------------------------- oaos ------------------------------------*/
/*
  NAME
    oaos	-- Oracle Office Start/Stop
  FUNCTION
    Start/Stop Oracle Office configured processes.
    Pass the empty string "" for unspecified values (not null pointers).
  ARGUMENTS
    ctx		-- oaxm context pointer
    hst		-- hstdef pointer
    password	-- daemon password
    connect	-- connect string
    flags	-- string, TBD
  RETURNS
    OA_SUCC	-- success
    > 0		-- SQL errors
    < 0 	-- see below
*/

/* local errors returned */
#define OAOS_ENOMEM		-4			    /* malloc failed */
#define OAOS_EIMH		-5	    /* failed to access message file */
#define OAOS_ESPAWN		-6		  /* error spawning guardian */
#define OAOS_ETIMEOUT		-7			 /* guardian timeout */

sword oaos(/*_ oaxmctx *ctx, struct hstdef *hst, text *password, text *connect,
	       text *flags _*/);

/*--------------------------------- oaos2 -----------------------------------*/
/*
  NAME
    oaos2	-- Oracle Office Start/Stop for 2.1 release
*/
sword oaos2(/*_ oaxmctx *ctx, struct hstdef *hst, text *password, 
                text *connect, text *flags _*/);

/*--------------------------------- oaospa ----------------------------------*/
/*
  NAME
    oaospa	-- Oracle Office Start/Stop Parse Arguments
  FUNCTION
    Parse arguments for Oracle Office daemon processes using oapapa.
    Set imask_oaosa to indicate which arguments you're interested in.
    Upon return, omask_oaosa will indicate which ones were specified,
		 ign_oaosa is a bit array that indicates argv's that
			   were unrecognized or ignored,
		 erridx_oaosa is index of first argv that bombed,
		 pwdidx_oaosa is to be passed to siutli for hiding password,
		 all others either contain valid data or zero.
  ARGUMENTS
    ctx		-- oaxm context pointer
    attr	-- attribute structure where parsed arguments are returned
    argc	-- count of process arguments to be parsed
    argv	-- process arguments to be parsed
  RETURNS
    OA_SUCC	-- all arguments parsed successfuly
    OA_WARN	-- some arguments did not parse
    other	-- oapapa or other error code
*/
sword oaospa(/*_ oaxmctx *ctx, oaosa *attr, eword argc, text **argv _*/);


/*--------------------------------- oaospr ----------------------------------*/
/*
  NAME
    oaospr	-- Oracle Office Start/Stop Prompt user
  FUNCTION
    Prompt user for arguments (currently for password only).
    Turns off echo for password.
  ARGUMENTS
    ctx		-- oaxm context pointer
    attr	-- attribute structure arguments are returned
  RETURNS
    OA_SUCC
*/
sword oaospr(/*_ oaxmctx *ctx, oaosa *attr _*/);


/*--------------------------------- oaosset ---------------------------------*/
/*
  NAME
    oaosset	-- Oracle Office Start/Stop Set arguments
  FUNCTION
    Generate argc/argv for spawning child processes based on attr.
    Used by start/stop and guardian.
  ARGUMENTS
    ctx		-- oaxm context pointer
    argc	-- input/output parameter counting arguments passed
    argv	-- input/output parameter holding passed arguments
    class       -- daemon class
    instance    -- deamon instance
    password    -- deamon password
    connect     -- connect string
    flags       -- string
  RETURNS

*/
sword oaosset(/*_ oaxmctx *ctx, eword *argc, text **argv, sword class,
	   sword instance, text *password, text *connect, text *flags _*/);


/*--------------------------------- oaoscmp ---------------------------------*/
/*
  NAME
    oaoscmp	-- Oracle Office Start/Stop CoMPare argument
  FUNCTION
    Check a string against a range of messages for a match.
    As a side effect, str is converted to uppercase!
  ARGUMENTS
    ctx		-- oaxm context pointer
    str		-- string to be compared
    minmsg	-- range start
    maxmsg	-- range end
    def	        -- returned when str is empty
  RETURNS
    OA_FAIL	-- no match
    match	-- otherwise
*/
sword oaoscmp(/*_ oaxmctx *ctx, text *str, sword minmsg, sword maxmsg,
		  sword def _*/);


/*------------------------------ oaosimh ------------------------------------*/
/*
  NAME
    oaosimh	-- Oracle Office Start/Stop Init Message Handler
  FUNCTION
    Initialize oamh and add OA product if necessary.
  ARGUMENTS
    ctx		-- oaxm context pointer
  RETURNS
    (oamh *)	-- success
    NULLP(oamh) -- In case of oamh errors.
*/

oamh *oaosimh(/*_ oaxmctx *ctx _*/);


/*------------------------------ oaosdin ------------------------------------*/
/*
  NAME
    oaosdin	-- Daemon INitialize
  FUNCTION
    Initializes context and checks node state to determine if daemon should
    run or exit.  The following fields in the context are updated:
	class_oaoscx
	instance_oaoscx
	state_oaoscx
	run_index_oaoscx
	debug_oaoscx
  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- pointer to context structure allocated by caller
    class	-- daemon class id
    instance	-- daemon instance id
  RETURNS
    OA_SUCC	-- success, state=running
    OA_WARN	-- warning, state=shutdown, shuting down, or single user mode
    otherwise	-- SQL error code
*/

sword oaosdin(/*_ struct hstdef *hst, oaoscx *ctx, sword class, 
			sword instance _*/);


/*------------------------------ oaosdgp ------------------------------------*/
/*
  NAME
    oaosdgp	-- get daemon param (from oo_proc_params table)
  FUNCTION
    Get the value for the specified token from database tables.
    Date types returned in Oracle SQLT_DAT Date format.
    Zero is returned for a null number.
  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- oaoscx context
    token_id	-- token id of desired parameter
    token_type	-- type of desired parameter
    ptr		-- ptr to caller buffer area of appropriate type:
		   sb4 for number, text[256] for char, ldx_t[LDXSIZ] for date
  RETURNS
    OA_SUCC	-- success
    otherwise	-- SQL error code
*/

#define OAOS_NUMBER_TYPE	1
#define OAOS_CHAR_TYPE		2
#define OAOS_DATE_TYPE		3

sword oaosdgp(/*_ struct hstdef *hst, oaoscx *ctx,
		  eword token_id, eword token_type, dvoid *ptr _*/);


/*------------------------------ oaosdgl ------------------------------------*/
/*
  NAME
    oaosdgl	-- get daemon list param (from ds_proc_params table)
  FUNCTION
    Get the values for the specified token from database tables.
    Date types returned in Oracle SQLT_DAT Date format.  
    Zero is returned for a null number.
    Space will be allocated for all the values and should be freed by the 
    caller.
  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- oaoscx context
    token_id	-- token id of desired parameter
    token_type	-- type of desired parameter
    ptr		-- ptr to caller buffer area of appropriate type returned by
                   routine.  (sb4 for number, text[256] for char, 
		   dat_t[ODTSIZ] for date)
    nelm	-- number of elements in buffer area
  RETURNS
    OA_SUCC	-- success
    otherwise	-- SQL error code
*/

#define OAOS_NUMLST_TYPE	11
#define OAOS_STRLST_TYPE	12
#define OAOS_DATLST_TYPE	13

sword oaosdgl( /*_ struct hstdef *hst, oaoscx *ctx, uword tkid, uword tktype, 
		   dvoid **ptr, ub4 *nelm _*/ );

/*------------------------------ oaosdap ------------------------------------*/
/*
  NAME
    oaosdap	-- check for daemon Active or Passive
  FUNCTION
    Updates the following fields in the context structure:
	state_oaoscx
	run_index_oaoscx
	debug_oaoscx
	start_time_oaoscx
	duration_oaoscx
	remain_time_oaoscx
	run_flag_oaoscx
	sleep_time_oaoscx
	info_flag_oaoscx
    Checks for a change in system state or run index, in which case
    OA_WARN is returned and daemon should exit.

    Generally, sleeping time used should be sleep_time_oaoscx if active
    (run_flag_oaoscx == 'A'), and remain_time_oaoscx if passive.
  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- oaoscx context
  RETURNS
    OA_SUCC	-- success
    OA_WARN	-- warning, system shutdown or restarted
    otherwise	-- SQL error code
*/

sword oaosdap(/*_ struct hstdef *hst, oaoscx *ctx _*/);

/*------------------------------ oaoscnt ------------------------------------*/
/*
  NAME
    oaoscnt	-- CouNT active agents of a given class
  FUNCTION
    This returns the number of agents (instances) of the class of the current
    agent which are currently in the "active" state.

  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- oaoscx context
    cnt         -- returned agent count
  RETURNS
    OA_SUCC	-- success
    OA_WARN	-- warning, system shutdown or restarted
    otherwise	-- SQL error code
*/

sword oaoscnt(/*_ struct hstdef *hst, oaoscx *ctx, eword *cnt _*/);

/*------------------------------ oaosdts ------------------------------------*/
/*
  NAME
    oaosdts	-- daemon TimeStamp
  FUNCTION
    Update the last_wake_time or last_sleep_time of oo_process record and
    performs a commit.
  ARGUMENTS
    hst		-- hostdef structure
    ctx		-- oaoscx context
    wake	-- TRUE/FALSE
  RETURNS
    OA_SUCC	-- success
    otherwise	-- SQL error code
*/

sword oaosdts(/*_ struct hstdef *hst, oaoscx *ctx, boolean wake _*/);


/*------------------------------ oaosgns ------------------------------------*/
/*
  NAME
    oaosgns	-- get node state
  FUNCTION
    Get the node state, timestamp, and broadcast message.
  ARGUMENTS
    hst		-- hostdef structure
    timestamp	-- buffer for timestamp of broadcast message (size LDXTSIZ)
    broadcast	-- buffer for broadcast message (size 256)
  RETURNS
    OA_FTL	-- node shutdown, display message and exit
    OA_SUCC	-- success
    otherwise	-- SQL error code
*/

sword oaosgns(/*_ struct hstdef *hst, ldx_t *timestamp, text *broadcast _*/);


/*------------------------------ oaosdps ------------------------------------*/
/*
  NAME
    oaosdps	-- daemon process status
  FUNCTION
    Get process status information for configured daemons.
    Date types returned in Oracle SQLT_DAT Date format.
    Zero is returned for a null number.
  ARGUMENTS
    hst		-- hostdef structure
    callp	-- callback function provided by caller
    callc	-- context for callback function
  RETURNS
    OA_SUCC	-- success
    otherwise	-- SQL error code
*/

sword oaosdps(/*_ struct hstdef *hst,
		  void (*callp)(
		      dvoid *callc, text *classname,
		      sword classid, sword instanceid, ub4 processstate,
		      ldx_t *lastwake, ldx_t *lastsleep,
		      text *osprocid, ub4 dbsessid),
		  dvoid *callc _*/);


#endif /* OAOS */
