/*
** $ oodef.h Release 12.2.1.3.0 $
*/

/* Copyright (c) 1991, 2017, Oracle and/or its affiliates. 
All rights reserved.*/

/*===========================================================================*\
NAME
    oodef.h  (Header file for Oracle Office)
NOTES
    This file contains general system constants and parameters.
MODIFIED
\*===========================================================================*/

#ifndef OODEF
#define OODEF

#ifndef S
#include <s.h>
#endif									/* S */

/*-----------------*\
|  Return Codes     |
\*-----------------*/

/*-----------------*\
|  Public Structs   |
\*-----------------*/

/*-----------------*\
|  Class Ids        |
\*-----------------*/

#define  OOCLS_OMDAEMON		1			/* message transport */
#define  OOCLS_COLLECT		2		       /* garbage collection */
#define  OOCLS_MONITOR		3			    /* queue monitor */
#define  OOCLS_GUARDIAN		4			  /* system guardian */
#define  OOCLS_MONITOR1		5		   /* queue monitor, phase 1 */
#define  OOCLS_MONITOR2		6		   /* queue monitor, phase 2 */

#define  OOCLS_SCHED		10			 /* scheduler daemon */
#define  OOCLS_ALARM		11		   /* scheduler alarm daemon */
#define  OOCLS_REPLICATOR	20		    /* ds replication engine */
#define  OOCLS_SYNC		21		           /* ds sync daemon */
#define  OOCLS_XAGENT           22                         /*  context agent */
#define  OOCLS_POP3AGENT        23                            /*  pop3 agent */
                                                          /* 24 used by LDAP */
#define  OOCLS_OMNA             25              /* Moblie Notification agent */

/* Reserved for Document Management */
#define  OOCLS_DM_MIN		40
#define  OOCLS_DM_MAX		59

/* Reserved for Workflow */
#define  OOCLS_WKFLOW		70		/* WorkFlow	*/

#define  OOCLS_V1V2		101			    /* v1-v2 gateway */
#define  OOCLS_UNIX		102			     /* unix gateway */
#define  OOCLS_X400		104			    /* X.400 gateway */

#define  OOCLS_OVVM_MIN		200                         /* OVVM Gateways */
#define  OOCLS_OVVM_MAX		210
#define  OOCLS_OVVM		200			    


/*-----------------*\
|  Process Names    |
\*-----------------*/

#define  OOPNM_DAEMON		(text *)"OFCOMD"		  /* postman */
#define  OOPNM_STARTUP		(text *)"OFCSTART"	/* system start/stop */
#define  OOPNM_GUARDIAN		(text *)"OFCGUARD"	  /* system guardian */
#define  OOPNM_COLLECT		(text *)"OFCMGC"	/* garbage collector */
#define  OOPNM_SCHED		(text *)"OFCSCH"	     /* sched daemon */
#define  OOPNM_ALARM		(text *)"OFCALR"		   /* alarm  */
#define  OOPNM_MONITOR1		(text *)"OFCMON1"	  /* monitor phase 1 */
#define  OOPNM_MONITOR2		(text *)"OFCMON2"	  /* monitor phase 2 */
#define  OOPNM_REPLICATOR	(text *)"OFCDSD"	       /* replicator */
#define  OOPNM_SYNC		(text *)"OFCSYNC"	         /* dir sync */
#define  OOPNM_XAGENT           (text *)"OFCMXA"            /* Context Agent */
#define  OOPNM_UNIXGWY		(text *)"OFCOTU"		 /* unix gwy */
#define  OOPNM_NTAGENT          (text *)"OFCOMNA"      /* Notification agent */


/*-----------------*\
|  Process Tokens   |
\*-----------------*/

/* Generic Server parameter */
#define  OOPTP_DEBUG		0	              /* debug flag for srvr */

/* OMDaemon parameters */
#define  OOPTX_WRKSPC		1		  /* pre-allocated workspace */
#define  OOPTX_MASK		2		   /* daemon subprocess mask */
#define  OOPTX_DMH		3		/* dead-msg hold time (days) */
#define  OOPTX_BOUNCE		4		/* remote bounce time (days) */
#define  OOPTX_POSTMSTR		5 		     /* postmaster recipient */
#define  OOPTX_FLGLOC		6 	   /* postman mask :: local delivery */
#define  OOPTX_FLGREM		7	  /* postman mask :: remote delivery */
#define  OOPTX_FLGV12		8	 /* postman mask :: V1 -- V2 gateway */
#define  OOPTX_FLGNOT		9 	     /* postman mask :: notification */
#define  OOPTX_RTECNT          10               /* route-table refresh count */
#define  OOPTX_V12CNT          11 	     /* package-size for V1 - V2 gwy */
#define  OOPTX_AUTOXH	       12	    /* auto-reply expiration history */
#define  OOPTX_FLGCTX          13                  /* context option enabled */
#define  OOPTX_OMNANT          14                       /* notification type */
#define  OOPTX_OPSID	       15 			  /* OPS instance Id */


/* garbage collector parameters */
#define  OOPTG_SAVDAYS		1		 /* event history exp. dates */
#define  OOPTG_CLNSHDW		2 		  /* gc mask:  clean shadows */
#define  OOPTG_GC_REG_RECORDS	3 		  /* gc flag:  Reg. records  */
#define  OOPTG_GC_SCHEDULER	4 		  /* gc flag:  GC sched.     */
#define  OOPTG_GC_DIRECTORY	5 		  /* gc flag:  GC Dir.       */
#define  OOPTG_GC_MAIL_EXPIRY	6 		  /* gc flag:  Mail expiry   */
#define  OOPTG_GC_MAIL_PRUNING	7 		  /* gc flag:  Mail Pruning  */
#define  OOPTG_GC_MAIL_CLEANUP	8 		  /* gc flag:  Mail Cleanup  */
#define  OOPTG_GC_V1_MAIL	9 	       /* gc flag:  V1 Mail Cleanup  */
#define  OOPTG_GC_LOG_KEPT     10 	      /* days of log history to keep */
#define  OOPTG_GC_AUTOEXH      11	    /* auto-reply expiration history */
#define	 OOPTG_GC_DIR_LOGKEPT  12	   /* days of replog history to keep */
#define  OOPTG_GC_DIR_MSGKEPT  13      /* days of archived sync msgs to keep */
#define  OOPTG_GC_OMRCP_CLNUP  14       /* om_recipient records cleanup mode */
#define  OOPTG_GC_CONTEXT      15                  /* context option enabled */
#define  OOPTG_GC_INDEX        16                       /* indexes enabled ? */
#define  OOPTG_GC_THEME        17                        /* themes enabled ? */
#define  OOPTG_GC_GIST         18                           /* gists enabled */
#define  OOPTG_GC_CTX_CLNUP    19      /* context query result table cleanup */
#define	 OOPTG_GC_DIR_BILLHIST 20	   /* days of replog history to keep */

/* Monitor parameters */
#define  OOPTM_PRBREC		1		   /* problem recipient list */
#define  OOPTM_NPRBREC		2		/* no-problem recipient list */
#define  OOPTM_BADSUB		3	       /* subject for "bad" messages */
#define  OOPTM_GOODSUB		4	      /* subject for "good" messages */

/* Schedular parameters */
#define  OOPTS_

/* Replicator Parameters */
#define	 OOPTR_NMRT		1	     /* Max pkg xfer attempts */
#define  OOPTR_TMRT		2	     /* Time between retries */
#define	 OOPTR_LSLP		3            /* Time repl sleeps for */
#define  OOPTR_TORT		4	     /* Max tm bween crtng pkgs */
#define  OOPTR_CTMX		5	     /* Max evts in log b4 sending */
#define  OOPTR_PKMX		6	     /* Max pkt size */

/* Dir Sync Parameters */
#define  OOPTY_FULFREQ          1            /* Frequency to do full sync */
#define  OOPTY_FULTIME          2            /* Time of day to do full sync */
#define  OOPTY_FULHIST		3	     /* # days worth change for sync */
#define  OOPTY_SNCTYPE          4            /* Synchronization Type */
#define  OOPTY_SNCDIRC          5            /* Synchronization Direction */
#define  OOPTY_SNCPEER          6            /* Peer server address */
#define  OOPTY_SNCPSWD          7            /* Peer server password */
#define  OOPTY_SNCMBOX          8	     /* Sync account name of instance */
#define  OOPTY_SNCAUTH          9	     /* Sync account passwd of inst */
#define  OOPTY_TRNSEXE         10            /* Translator executable */
#define  OOPTY_TRNSARG         11            /* Translator arguments */
#define  OOPTY_MAPLOCN         12            /* Sync Map file location */
#define  OOPTY_OBJEXPT         13            /* Object Classes Exported */
#define  OOPTY_DOMEXPT         14	     /* Domains Exported */
#define  OOPTY_DELTHRS         15	     /* Inbound Sync delete threshold */
#define  OOPTY_TRSPTYP         16	     /* Transport type */
#define  OOPTY_MSGGWY          17	     /* Message addr gateway name */

/* Unix Gwy tokens */
#define  OOPTU_RECIPEXT		1	     /* Recipient extension */
#define  OOPTU_STRIPQUALNAME	2	     /* Strip qualified part */
#define  OOPTU_STRIPGWYTKNS	3	     /* Strip gateway prefix */
#define  OOPTU_GWYCFGFILE       4            /* Gateway configuration file */
#define  OOPTU_UTODEFTYPE	5	     /* default attachment type */
#define  OOPTU_OTUDEFENCODING	6	     /* default otu data encoding */
#define  OOPTU_OTUDEFCONTDISP	7	     /* default content-disposition */
#define  OOPTU_DEFAULT_CHARSET  8            /* default charset of text type */
                                             /* body parts */
#define  OOPTU_ENCODING_FORTEXT 9            /* default content-transfer */
                                             /* encoding for text type body */
                                             /* parts */
#define  OOPTU_UUENCODE         10           /* do uuencode? */
#define  OOPTU_UUDECODE         11           /* do uudecode? */
#define  OOPTU_ENCODING_FORHDR  12           /* default encoding for */
                                             /* non-us-ascii headers */
                                             /* (rfc1522) */
#define  OOPTU_SEND_SUMMARY     13           /* to send summary? */
#define  OOPTU_APPEND_GNAME     14           /* Append gateway name */

/* MHS gateway parameters */
#define  OOPTH_MHS_MHSVER		1    /* MHS version number           */
#define  OOPTH_MHS_ALLOMAIL		2    /* send unmapped omail features */
#define  OOPTH_MHS_ALLMHS		3    /* Send unmapped MHS features   */
#define  OOPTH_MHS_SLEEPTM		4    /* Gateway sleep time           */
#define  OOPTH_MHS_MHSADMIN		5    /* MHS admin address            */
#define  OOPTH_MHS_OMAILADMIN		6    /* OMail admin address          */
#define  OOPTH_MHS_AUTOREG_ORIG		7    /* Auto register originator?    */
#define  OOPTH_MHS_AUTOREG_FOREIGN	8    /* Auto reg all foreign addrs?  */
#define  OOPTH_MHS_IMPORT_DEF    	9    /* Default importance           */
#define  OOPTH_MHS_SENS_DEF    		10   /* Default sensitivity          */
#define  OOPTH_MHS_MENC_DEF    		11   /* Defauly OMail msg encoding   */
#define  OOPTH_MHS_ALTDLV_DEF    	12   /* Default alternate dlv flag   */
#define  OOPTH_MHS_LOGLEVEL		13   /* Gateway logging level        */
#define  OOPTH_MHS_FLAT_ADDR		14   /* Allow flat addresses         */

/* OV/VM gateway parameters */
#define  OOPTV_OVVM_RSCS_LOCALLU    1   /* Local LU name (M) */
#define  OOPTV_OVVM_RSCS_PARTLU     2   /* Partner LU name (M) */
#define  OOPTV_OVVM_RSCS_LOCALNODE  3   /* Local Node ID (M) */
#define  OOPTV_OVVM_RSCS_PARTNODE   4   /* Partner Node ID (M) */
#define  OOPTV_OVVM_RSCS_MODENAME   5   /* Session mode name (M) */
#define  OOPTV_OVVM_RSCS_NUMATTEMPTS    6  /* Number of attempts to OV/VM */
#define  OOPTV_OVVM_RSCS_ATTDELAY   7   /* Time between attempts to OV/VM */
#define  OOPTV_OVVM_RSCS_MAXWAIT    8   /* Time-out value for OS/2 CM */
#define  OOPTV_OVVM_RSCS_LOCSTSIZE  9   /* Time-out value for OS/2 CM */
#define  OOPTV_OVVM_RSCS_SBMSGFILE  10  /* Scoreboard message file */
#define  OOPTV_OVVM_OMGP_VMLOCID    11  /* Location id (M) */
#define  OOPTV_OVVM_OMGP_VMNODEID   12  /* Location id (M) */
#define  OOPTV_OVVM_OMGP_OVRELEASE  13  /* Release of PROFS */
#define  OOPTV_OVVM_OMGP_OVDFILE    14  /* OV/VM directory table */
#define  OOPTV_OVVM_OMGP_OVNOTEMSG  15  /* OV/VM note string message table */
#define  OOPTV_OVVM_OMGP_VMDOCTYPE  16  /* OV/VM document type table */
#define  OOPTV_OVVM_OMGP_OOPOLLDELAY    17  /* Time between message polls */
#define  OOPTV_OVVM_OMGP_OOCDEPGE   18  /* Codepage used by OO */
#define  OOPTV_OVVM_OMGP_VMIMMACK   19  /* Immediate ACK to OV/VM ? */
#define  OOPTV_OVVM_OMGP_MAPCODRRR  20  /* Map OV/VM .AK notes ? */
#define  OOPTV_OVVM_OMGP_OVHEADER   21  /* Generate OV/VM header ? */
#define  OOPTV_OVVM_OMGP_MAPCONFMTGS    22  /* Map confidental meetings ? */
#define  OOPTV_OVVM_OMGP_MAPPERSMTGS    23  /* Map personal meetings ? */
#define  OOPTV_OVVM_OMGP_RETACCEPT  24  /* Return accept to OV/VM ? */
#define  OOPTV_OVVM_OMGP_RETDECLINE 25  /* Return decline to OV/VM ? */
#define  OOPTV_OVVM_OMGP_OOCALFDBCK 26  /* Generate OO feedback for cal ? */
#define  OOPTV_OVVM_OMGP_OOGWDOM    27  /* Domain gateway belongs to */
#define  OOPTV_OVVM_OMGP_OOALIASDOM 28  /* Domain where OV/VM alises located */
#define  OOPTV_OVVM_OMGP_OOROOTDOM  29  /* OO root domain */
#define  OOPTV_OVVM_OMGP_OOMAPNDDOM 30  /* Map OV/VM node id to domain root */
#define  OOPTV_OVVM_OMGP_ADMINMODEL 31  /* Administrative model used */
#define  OOPTV_OVVM_OMGP_DOMTABLE   32  /* Domain mapping table */
#define  OOPTV_OVVM_OMGP_ERRORMAIL  33  /* Send error mail ? */
#define  OOPTV_OVVM_OMGP_GWERRFILE  34  /* Error message file */
#define  OOPTV_OVVM_OMGP_OOADMIN    35  /* OO admin id */
#define  OOPTV_OVVM_OMGP_OVADMIN    36  /* OV/VM admin id */
#define  OOPTV_OVVM_OMGP_OVCDEPGE   37  /* Codepage for OV/VM */
#define  OOPTV_OVVM_OMGP_OVDATEFMT  38  /* Date format used */
#define  OOPTV_OVVM_OMGP_OVMAXRECUR 39  /* Maximum period for recurring mtgs */
#define  OOPTV_OVVM_OMGP_VMCDEPGE   40  /* Codepage for VM/CMS */
#define  OOPTV_OVVM_OMGP_OOMSGTBL   41  /* OO message string table */
#define  OOPTV_OVVM_OMGP_OODOCTYPE  42  /* OO document type table */
#define  OOPTV_OVVM_OMGP_OOVMDOC    43  /* OO->OV/VM steering table */
#define  OOPTV_OVVM_OMGP_VMOODOC    44  /* OV/VM->OO sterring table */
#define  OOPTV_OVVM_OMGP_REFRESH    45  /* Configuration refresh rate */
#define  OOPTV_OVVM_OMGP_CTEXPIRED  46  /* Correlation expiry period */

/* FAX gateway parameters */
#define  OOPTF_SLEEPTIME		0    /* Gateway sleep time           */
#define  OOPTF_OMAILADMIN		1    /* Office admin address         */
#define	 OOPTF_FAXADMIN			2    /* FAX server admin address     */
#define  OOPTF_LOGLEVEL                 3    /* Gateway logging level        */
#define  OOPTF_GWDIR			4    /* Gateway working directory    */
#define  OOPTF_FAXSPOOL			5    /* Fax server spool directory   */
#define  OOPTF_FAXOPER			6    /* Fax operator address         */
#define  OOPTF_COVERPAGE		7    /* Allow customized cover page? */
#define  OOPTF_SIGNATURE		8    /* Allow customized signatures? */
#define  OOPTF_PARTIALCOVER		9    /* allow partial cover page?    */
#define  OOPTF_FAXEXECDIR		10   /* dir of job submission exec   */
#define  OOPTF_RETURNDROPAT             11   /* return dropped attachments?  */
#define  OOPTF_DIDPREFIX		12   /* did prefix to be used */
#define  OOPTF_FAXFIX     		13   /* repair the incoming faxes?   */
#define  OOPTF_RICHPREF     		14   /* rich format pref order       */

/* Context Agent Parameters */
#define  OOPTC_CONTEXT                  1    /* context enabled ? */
#define  OOPTC_INDEX                    2    /* indexes enabled ? */
#define  OOPTC_THEME                    3    /* themes enabled ? */
#define  OOPTC_GIST                     4    /* gists enabled */
#define  OOPTC_THEME_MINSZ              5    /* minimum msg size for themes */
#define  OOPTC_GIST_MINSZ               6    /* minimum msg size for gists */
#define  OOPTC_NUMTAB                   7    /* number of search tables */
#define  OOPTC_CLIMIT                   8    /* cache table limit */

/* Gateway types */
#define OOGWT_FAX	6
#define	OOGWT_MHS	9

/* Mobile notification agent parameters */
#define OOPTN_OMNA_TYPE                 1
#define OOPTN_OMNA_SVCNAME              2
#define OOPTN_OMNA_COMPNAME             3

#endif								    /* OODEF */

