<?xml version="1.0"?>
<!--
 Copyright (c) 2007, 2017, Oracle and/or its affiliates. All rights reserved.

   NAME
     rspfmt_raw2ext_transformer_v11_2_0_1.xsl - XSLT to transform internal database response file format to external property file format

   DESCRIPTION
     <short description of component this file declares/defines>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    lorajan     04/18/17  - Changing the order of client install type.
    davjimen    06/02/15  - remove oracle hostname from rsp template
    lorajan     01/22/15  - Removing the Product language section in the
                            response file based on the condition.
    lorajan     06/15/14  - XbranchMerge lorajan_bug-18449216 from
                            st_install_12.1
    lorajan     05/18/14  - Adding the condition to skip the autoupdate related
                            entries in the response file based on the
                            featurelist property "oracle.install.supportSoftwareUpdates". Disabling it for 12.1.0.2. 
    pvallam     07/01/13  - correct the boolean check
    pvallam     06/03/13  - do not show inventory location on windows
    pkuruvad    08/22/12  - Removing old winsec properties
    pkuruvad    08/16/12  - changing win security parameter names
    xiaofwan    04/27/12  - Update the format of comment section to be
                            consistent
    davjimen    04/24/12  - Update choices consistency, all bullets
    rmallego    04/16/12  - adding windows specific components in the comments
    pkuruvad    03/01/12  - Bug 13584766 changes
    rmallego    10/12/11  - sandboxing windows security related variables
    davjimen    06/02/11  - Update response files
    pvallam     05/13/11  - adding proxy realm
    pvallam     04/26/11  - XbranchMerge pvallam_bug-11770204_11203 from
                            st_install_11.2.0
    scravind    04/25/11  - XbranchMerge scravind_bug-12383298 from main
    pvallam     03/20/11  - updating name of mts bean
    gramamur    03/03/11  - Adding parameters related to Windows Secure Option
    pvallam     06/02/10  - changing the offline autoupdates option
    dschrein    03/17/10  - add upgrade-related var
    dschrein    07/28/09  - remove oracle.ons
    rochang     04/24/09  - Adding silent install for Scheduler Agent
    sangkuma    02/22/09  - Changing oracle.install.*.ORACLE_* variables to
                            ORACLE_*
    sangkuma    12/30/08  - Fixing comments for product languages property
    sangkuma    12/25/08  - Removing unnecessary comments
    sangkuma    12/15/08  - Adding version field
    pvallam     09/17/08 -  adding entry for mts port number
    msubbann    05/12/08 - Take out ORACLE_HOME_NAME property
    sangkuma    03/12/08 - change the property name of
                           oracle.install.OPERGroupNameUsed to
                           UNIX_GROUP_NAME
    dschrein    03/03/08 - need customComponents
    dschrein    01/12/08 - creation
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:PreferenceHelper="http://www.oracle.com/XSL/Transform/java/oracle.install.ivw.common.util.PreferenceHelper" xmlns:platformInfo="http://www.oracle.com/XSL/Transform/java/oracle.install.library.util.PlatformInfo" version="1.0">
<xsl:output method="text" indent="false"></xsl:output>
<xsl:template match="beanstore">###############################################################################
## Copyright(c) Oracle Corporation 1998,@<CURRENT_YEAR>@. All rights reserved.           ##
##                                                                           ##
## Specify values for the variables listed below to customize                ##
## your installation.                                                        ##
##                                                                           ##
## Each variable is associated with a comment. The comment                   ##
## can help to populate the variables with the appropriate                   ##
## values.							             ##
##                                                                           ##
###############################################################################
<xsl:variable name="obj" select="platformInfo:getInstance()"/>
<xsl:variable name="isWindows" select="platformInfo:isWindows($obj)"/>
<xsl:variable name="supportSoftwareUpdates" select="PreferenceHelper:getProperty('oracle.install.supportSoftwareUpdates')" />
<xsl:variable name="allowProductLanguageSelection" select="PreferenceHelper:getProperty('oracle.install.allowProductLanguageSelection')" />

#-------------------------------------------------------------------------------
# Do not change the following system generated value. 
#-------------------------------------------------------------------------------
oracle.install.responseFileVersion=/oracle/install/rspfmt_clientinstall_response_schema_v@<DB_VERSION_THREE_DIGITS>@

#-------------------------------------------------------------------------------
# Unix group to be set for the inventory directory.
#------------------------------------------------------------------------------- 
UNIX_GROUP_NAME=<xsl:value-of select="ClientSetupBean/CentralInventorySettings/UNIX_GROUP_NAME"/>
<xsl:variable name="ob" select="platformInfo:getInstance()"/>
<xsl:variable name="val" select="platformInfo:isUnix($ob)"/>
<xsl:if test="$val = true()">
#-------------------------------------------------------------------------------
# Inventory location.
#-------------------------------------------------------------------------------
INVENTORY_LOCATION=<xsl:value-of select="ClientSetupBean/CentralInventorySettings/INVENTORY_LOCATION"/>
</xsl:if>
<xsl:if test="$allowProductLanguageSelection ='true'">
#-------------------------------------------------------------------------------
# Specify the languages in which the components will be installed.             
#
# en   : English                  ja   : Japanese                  
# fr   : French                   ko   : Korean                    
# ar   : Arabic                   es   : Latin American Spanish    
# bn   : Bengali                  lv   : Latvian                   
# pt_BR: Brazilian Portuguese     lt   : Lithuanian                
# bg   : Bulgarian                ms   : Malay                     
# fr_CA: Canadian French          es_MX: Mexican Spanish           
# ca   : Catalan                  no   : Norwegian                 
# hr   : Croatian                 pl   : Polish                    
# cs   : Czech                    pt   : Portuguese                
# da   : Danish                   ro   : Romanian                  
# nl   : Dutch                    ru   : Russian                   
# ar_EG: Egyptian                 zh_CN: Simplified Chinese        
# en_GB: English (Great Britain)  sk   : Slovak                    
# et   : Estonian                 sl   : Slovenian                 
# fi   : Finnish                  es_ES: Spanish                   
# de   : German                   sv   : Swedish                   
# el   : Greek                    th   : Thai                      
# iw   : Hebrew                   zh_TW: Traditional Chinese       
# hu   : Hungarian                tr   : Turkish                   
# is   : Icelandic                uk   : Ukrainian                 
# in   : Indonesian               vi   : Vietnamese                
# it   : Italian                                                   
#
# all_langs   : All languages
#
# Specify value as the following to select any of the languages.
# Example : SELECTED_LANGUAGES=en,fr,ja
#
# Specify value as the following to select all the languages.
# Example : SELECTED_LANGUAGES=all_langs
#-------------------------------------------------------------------------------
SELECTED_LANGUAGES=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="ClientSetupBean/SELECTED_LANGUAGES"/></xsl:call-template>
</xsl:if>
#-------------------------------------------------------------------------------
# Complete path of the Oracle Home
#-------------------------------------------------------------------------------  
ORACLE_HOME=<xsl:value-of select="ClientSetupBean/ClientInstallSettings/ORACLE_HOME"/>

#-------------------------------------------------------------------------------
# Complete path of the Oracle Base.
#-------------------------------------------------------------------------------
ORACLE_BASE=<xsl:value-of select="ClientSetupBean/ClientInstallSettings/ORACLE_BASE"/>

<xsl:if test="$isWindows='true'">
#--------------------------------------------------------------------------------------------
# Specify the Oracle Home user.                 
#
# Use Built-in Account or specify a Windows User Account with limited privilege to 
# install and configure the Oracle Home.
#
# Set oracle.install.IsBuiltInAccount to true if you want to use BuiltIn Account.
#
# Set oracle.install.IsBuiltInAccount to false if you want to use Windows Account
# user as Oracle Home user. 
#--------------------------------------------------------------------------------------------
oracle.install.IsBuiltInAccount=<xsl:value-of select="ClientSetupBean/WindowsSecureOptionSettings/oracle_install_IsBuiltInAccount"/>
oracle.install.OracleHomeUserName=<xsl:value-of select="ClientSetupBean/WindowsSecureOptionSettings/oracle_install_OracleHomeUserName"/>
oracle.install.OracleHomeUserPassword=<xsl:value-of select="ClientSetupBean/WindowsSecureOptionSettings/oracle_install_OracleHomeUserPassword"/>
</xsl:if>

#------------------------------------------------------------------------------
#Name       : INSTALL_TYPE
#Datatype   : String
#Description: Installation type of the component.
#
#             The following choices are available. The value should contain
#             only one of these choices.
#               - Administrator
#               - Runtime
#               - InstantClient
#               - Custom
#
#Example    : INSTALL_TYPE = Administrator
#------------------------------------------------------------------------------
oracle.install.client.installType=<xsl:value-of select="ClientSetupBean/ClientInstallSettings/INSTALL_TYPE"/>

#-------------------------------------------------------------------------------
# Name       : oracle.install.client.customComponents
# Datatype   : StringList
#
# This property is considered only if INSTALL_TYPE is set to "Custom"
#
# Description: List of Client Components you would like to install
#
#   The following choices are available. You may specify any
#   combination of these choices.  The components you choose should
#   be specified in the form "internal-component-name:version"
#   Below is a list of components you may specify to install.
#
# oracle.sqlj:@<cmp_prp_version oracle.sqlj>@ -- "Oracle SQLJ"
# oracle.rdbms.util:@<cmp_prp_version oracle.rdbms.util>@ -- "Oracle Database Utilities"
# oracle.javavm.client:@<cmp_prp_version oracle.javavm.client>@ -- "Oracle Java Client"
# oracle.sqlplus:@<cmp_prp_version oracle.sqlplus>@ -- "SQL*Plus"
# oracle.dbjava.jdbc:@<cmp_prp_version oracle.dbjava.jdbc>@ -- "Oracle JDBC/THIN Interfaces"
# oracle.ldap.client:@<cmp_prp_version oracle.ldap.client>@ -- "Oracle Internet Directory Client"
# oracle.rdbms.oci:@<cmp_prp_version oracle.rdbms.oci>@ -- "Oracle Call Interface (OCI)"
# oracle.precomp:@<cmp_prp_version oracle.precomp>@ -- "Oracle Programmer"
# oracle.xdk:@<cmp_prp_version oracle.xdk>@ -- "Oracle XML Development Kit"
# oracle.network.aso:@<cmp_prp_version oracle.network.aso>@ -- "Oracle Advanced Security"
# oracle.oraolap.mgmt:@<cmp_prp_version oracle.oraolap.mgmt>@ -- "OLAP Analytic Workspace Manager and Worksheet"
# oracle.network.client:@<cmp_prp_version oracle.network.client>@ -- "Oracle Net"
# oracle.network.cman:@<cmp_prp_version oracle.network.cman>@ -- "Oracle Connection Manager"
# oracle.network.listener:@<cmp_prp_version oracle.network.listener>@ -- "Oracle Net Listener"
# oracle.ordim.client:@<cmp_prp_version oracle.ordim.client>@ -- "Oracle Multimedia Client Option"
# oracle.odbc:@<cmp_prp_version oracle.odbc>@ -- "Oracle ODBC Driver"
# oracle.has.client:@<cmp_prp_version oracle.has.client>@ -- "Oracle Clusterware High Availability API"
# oracle.dbdev:@<cmp_prp_version oracle.dbdev>@ -- "Oracle SQL Developer"
# oracle.rdbms.scheduler:@<cmp_prp_version oracle.rdbms.scheduler>@ -- "Oracle Scheduler Agent" <xsl:if test="$isWindows='true'">
# oracle.ntoramts:@<cmp_prp_version oracle.ntoramts>@ -- "Oracle Services For Microsoft Transaction Server"
# oracle.ntoledb:@<cmp_prp_version oracle.ntoledb>@ -- "Oracle Provider for OLE DB"
# oracle.ntoledb.odp_net_2:@<cmp_prp_version oracle.ntoledb.odp_net_2>@ -- "Oracle Data Provider for .NET"
# oracle.aspnet_2:@<cmp_prp_version oracle.aspnet_2>@ -- "Oracle Providers for ASP.NET" </xsl:if>
#
# Example    : oracle.install.client.customComponents="oracle.precomp:@<cmp_prp_version oracle.precomp>@","oracle.oraolap.mgmt:@<cmp_prp_version oracle.oraolap.mgmt>@","oracle.rdbms.scheduler:@<cmp_prp_version oracle.rdbms.scheduler>@"
#-------------------------------------------------------------------------------
oracle.install.client.customComponents=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="ClientSetupBean/ClientInstallSettings/oracle_install_client_CustomComponents"/></xsl:call-template>

#-------------------------------------------------------------------------------
# Host name to be used for by the Oracle Scheduler Agent.
# This needs to be entered in case oracle.rdbms.scheduler is selected in the
# list of custom components during custom install
#
# Example    : oracle.install.client.schedulerAgentHostName = acme.domain.com
#------------------------------------------------------------------------------
oracle.install.client.schedulerAgentHostName=<xsl:value-of select="ClientSetupBean/ClientInstallSettings/oracle_install_client_SchedulerAgentHostName"/>

#------------------------------------------------------------------------------
# Port number to be used for by the Oracle Scheduler Agent.
# This needs to be entered in case oracle.rdbms.scheduler is selected in the
# list of custom components during custom install
#
# Example: oracle.install.client.schedulerAgentPortNumber = 1500
#------------------------------------------------------------------------------
oracle.install.client.schedulerAgentPortNumber=<xsl:value-of select="ClientSetupBean/ClientInstallSettings/oracle_install_client_SchedulerAgentPortNumber"/>
<xsl:if test="$supportSoftwareUpdates='true'">
#------------------------------------------------------------------------------
# Specify the auto-updates option. It can be one of the following:
#   - MYORACLESUPPORT_DOWNLOAD
#   - OFFLINE_UPDATES
#   - SKIP_UPDATES
#------------------------------------------------------------------------------
oracle.installer.autoupdates.option=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_option"/>

#------------------------------------------------------------------------------
# In case MYORACLESUPPORT_DOWNLOAD option is chosen, specify the location where
# the updates are to be downloaded.
# In case OFFLINE_UPDATES option is chosen, specify the location where the updates
# are present.
#------------------------------------------------------------------------------
oracle.installer.autoupdates.downloadUpdatesLoc=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_downloadLoc" />

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username which has the patches download privileges  
# to be used for software updates.
#  Example   : AUTOUPDATES_MYORACLESUPPORT_USERNAME=abc@oracle.com
#------------------------------------------------------------------------------
AUTOUPDATES_MYORACLESUPPORT_USERNAME=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_myOracleSupportCredentials/oracle_install_autoupdates_myOracleSupportUserName"/>

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username password which has the patches download privileges  
# to be used for software updates.
#
# Example    : AUTOUPDATES_MYORACLESUPPORT_PASSWORD=password
#------------------------------------------------------------------------------
AUTOUPDATES_MYORACLESUPPORT_PASSWORD=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_myOracleSupportCredentials/oracle_install_autoupdates_myOracleSupportPassword"/>

#------------------------------------------------------------------------------
# Specify the Proxy server name. Length should be greater than zero.
#
# Example    : PROXY_HOST=proxy.domain.com 
#------------------------------------------------------------------------------
PROXY_HOST=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyHost"/>

#------------------------------------------------------------------------------
# Specify the proxy port number. Should be Numeric and at least 2 chars.
#
# Example    : PROXY_PORT=25 
#------------------------------------------------------------------------------
PROXY_PORT=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyPort"/>

#------------------------------------------------------------------------------
# Specify the proxy user name. Leave PROXY_USER and PROXY_PWD 
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_USER=username 
#------------------------------------------------------------------------------
PROXY_USER=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyUser"/>

#------------------------------------------------------------------------------
# Specify the proxy password. Leave PROXY_USER and PROXY_PWD  
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_PWD=password 
#------------------------------------------------------------------------------
PROXY_PWD=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyPassword"/>

#------------------------------------------------------------------------------
# Specify the proxy realm.
#
# Example    : PROXY_REALM=metalink
#------------------------------------------------------------------------------
PROXY_REALM=<xsl:value-of select="ClientSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyRealm"/>
</xsl:if>
</xsl:template>
<xsl:template name="toStringList">
<xsl:param name="valueList"/>
<xsl:variable name="valueCount" select="count($valueList/value)"/>
<xsl:for-each select="$valueList/value"><xsl:value-of select="."/><xsl:if test="$valueCount > position()">,</xsl:if></xsl:for-each>	
</xsl:template>
</xsl:stylesheet>

