import subprocess


def get_output(file_name):
   result = subprocess.check_output(['7z', 'l', '-slt', file_name])
   result = result.split('----------\n')[1].split("\n\n")
   return result


def unzip(archive_name, target_file, password=''):
   print "UNZIP: " + target_file
   result = subprocess.check_output(['7z', 'x', '-ooutput', archive_name, target_file])
   print result


def get_zip_list(archive_name):
   file_info = get_output(archive_name)
   file_list = {'archive_name': archive_name,
                'encrypted': False,
                'files': []}
   # Convert the raw string to dictionary
   for item in file_info:
      info = {}
      for f in map(lambda x: map(str.strip, x.split('=')),
                   item.split('\n')):
         if len(f) > 1:
            info[f[0]] = f[1]
      if len(info) > 0 and info['Folder'] == '-':
         file_list['files'].append(info)
   # Mark if any file in the archive is encrypted which
   # means that the archive is password protected.
   for item in file_list['files']:
      if item['Encrypted'] == '+':
         file_list['encrypted'] = True
         break

   return file_list


def handle_archive(archive_name):
   ziplist = get_zip_list(archive_name)
   if ziplist['encrypted']:
      # Prompt password via Safedocs
      print "Password needed"
   else:
      for file in ziplist['files']:
         unzip(archive_name, file['Path'])


if __name__ == "__main__":
   handle_archive('testzip.zip')
