/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.library.util.PlatformInfo;

public class PreferenceHelper {
    public static final String GI_SUPPORTED = "oracle.install.db.enableGISupport";
    public static final String ENABLE_GI_SUPPORT = "-enableGISupport";
    public static final String SKIP_PATH_UPDATE = "-skipPathUpdate";
    private static final Logger logger = Logger.getLogger(PreferenceHelper.class.getName());

    public static boolean isGISupported() {
        return !PlatformInfo.getInstance().isWin32System() || Boolean.getBoolean(GI_SUPPORTED) || Application.isCommandLineSwitchEnabled((String)ENABLE_GI_SUPPORT);
    }

    public static boolean isInPlaceUpgradeSupported() {
        return true;
    }

    public static String getProperty(String key) {
        if (key != null && key.length() > 0) {
            String value = System.getProperty(key);
            if (value == null) {
                value = Application.getInstance().getString(key, null, new Object[0]);
            } else {
                logger.log(Level.INFO, "PreferenceHelper.getProperty: key:" + key + " is set as system proeprty");
            }
            return value;
        }
        return null;
    }
}

