/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.common.validator.CRSNodeRemoveActionableValidationStatusMessage;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;

public class InventoryValidator
implements CompositeValidator {
    private String inventoryLoc;
    private static Logger logger = Logger.getLogger(InventoryValidator.class.getName());
    private boolean isSharedDir = false;
    private boolean isWritableLocalNode = false;
    private StatusMessages<ValidationStatusMessage> errorMessages = new StatusMessages();

    public void validate(FlowContext flowContext) throws ValidationException {
        if (this.errorMessages.size() > 0) {
            this.errorMessages.clear();
        }
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        this.inventoryLoc = cenInv.getInventoryLocation();
        if (this.checkEmptiness(this.inventoryLoc) == null) {
            this.checkInvalidChars(this.inventoryLoc);
            this.errorMessages.add((StatusMessage)this.checkCompliance(this.inventoryLoc));
            this.checkAbsolutePath(this.inventoryLoc);
            this.checkGenericInventoryValidation(this.inventoryLoc);
            this.checkUnixWritable(this.inventoryLoc);
            this.checkDirtyInventory(this.inventoryLoc);
        }
        if (PlatformInfo.getInstance().isUnix()) {
            String invGroup = cenInv.getGroupOwnership();
            if (invGroup == null || invGroup.trim().length() == 0) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ORAINVENTORY_GROUP_NOT_SPECIFIED, new Object[0]));
            } else {
                String user = System.getProperty("user.name");
                List<String> arrOsGroups = Arrays.asList(InventoryInfo.getInstance().getOSGroups());
                logger.log(Level.INFO, "User " + user + " belongs to following groups: " + arrOsGroups);
                if (!arrOsGroups.contains(invGroup)) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVALID_ORAINVENTORY_GROUP, new Object[]{invGroup, user}));
                } else {
                    this.checkChangeGroupPermission(this.inventoryLoc, user, invGroup);
                }
            }
        }
    }

    public void validateOraInventoryLocation(String oraInvLoc, String oraBase) {
        File fileInvLoc = new File(oraInvLoc);
        File fileBase = new File(oraBase);
        try {
            String strBase = fileBase.getCanonicalPath();
            if (!strBase.endsWith(File.separator)) {
                strBase = strBase + File.separator;
            }
            if (fileInvLoc.getCanonicalPath().startsWith(strBase)) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVENTORY_IN_ORACLE_BASE, new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ValidationStatusMessage checkCompliance(String inventoryLocation) {
        File userHomeDir;
        File invLoc;
        logger.log(Level.INFO, "Checking whether the given inventory location {0} is user home or not...", inventoryLocation);
        ValidationStatusMessage errorMessage = null;
        if (inventoryLocation != null && (invLoc = new File(inventoryLocation)).exists() && invLoc.equals(userHomeDir = FileSystem.getHomeDirectory())) {
            errorMessage = new ValidationStatusMessage((ErrorCode)CommonErrorCode.USER_HOME_NOT_ALLOWED_AS_INV_LOC, new Object[0]);
        }
        return errorMessage;
    }

    public StatusMessage checkEmptiness(String input) {
        ValidationStatusMessage retVal = null;
        if (input == null || input.trim().length() < 1) {
            CommonErrorCode key = CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_EMPTY_ERR;
            retVal = new ValidationStatusMessage((ErrorCode)key, new Object[0]);
            this.errorMessages.add((StatusMessage)retVal);
        }
        return retVal;
    }

    public void checkDirtyInventory(String invLoc) {
        String[] files;
        File file = new File(invLoc);
        if (file.exists() && file.isDirectory() && (files = file.list()) != null && files.length != 0) {
            File inventoryFile = new File(invLoc, "ContentsXML/inventory.xml");
            File logPath = new File(invLoc, "logs");
            File invLocks = new File(invLoc, "locks");
            if (inventoryFile != null && inventoryFile.exists() || invLocks != null && invLocks.exists()) {
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_DIRTY, new Object[]{invLoc}));
            } else if (logPath != null && logPath.exists() && logPath.isDirectory()) {
                if (!logPath.canWrite()) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_DIRTY, new Object[]{invLoc}));
                } else if (logPath.canWrite() && logPath.list().length > 0) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_DIRTY_WARN, new Object[]{invLoc}));
                }
            }
        }
    }

    public void checkAbsolutePath(String input) throws ValidationException {
        String pathDesc = "inventory";
        ValidationStatusMessage msg = null;
        msg = GenericValidation.checkAbsolutePath(input, pathDesc);
        if (msg != null) {
            throw new ValidationException(msg.getErrorInfo().getErrorCode(), msg.getErrorInfo().getMessageArgs());
        }
    }

    public void checkInvalidChars(String input) throws ValidationException {
        String invalidChars = BaseInstallLocationValidator.getBadCharsForLocation();
        if (!GenericValidation.isFilenameValid(input, invalidChars)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_INV_INVALID_CHARS, new Object[0]);
        }
    }

    public void checkGenericInventoryValidation(String input) {
        Object retVal = null;
        boolean bool = false;
        CommonErrorCode message = CommonErrorCode.INSTALL_COMMON_INVENTORY_INVALID_INV_LOCATION_ERR;
        try {
            bool = InventoryInfo.getInstance().validateInvLocForSetup(input);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        if (!bool) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)message, new Object[0]));
        }
    }

    public void checkUnixWritable(String input) {
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (input == null || input.trim().equals("")) {
            return;
        }
        boolean bool = false;
        CommonErrorCode key = CommonErrorCode.INSTALL_COMMON_INVENTORY_INV_NO_WRITE_PERMISSION_ERR;
        this.isWritableLocalNode = bool = this.isLeafWritable(input);
        if (!bool) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)key, new Object[]{input}));
        }
    }

    private boolean isLeafWritable(String dir) {
        boolean bool = false;
        File f = new File(dir);
        while (!bool) {
            bool = f.exists();
            if (bool) continue;
            f = new File(f.getParent());
        }
        return f.canWrite();
    }

    public void checkForSharedLocation(List<String> nodes) {
        if (nodes != null && nodes.size() > 1) {
            try {
                if (FileSystemInfo.getInstance().isLocationOnCFS(this.inventoryLoc, nodes)) {
                    this.isSharedDir = true;
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVENTORY_ON_SHARED_LOC, new Object[]{this.inventoryLoc}));
                }
            }
            catch (InstallException installException) {
                // empty catch block
            }
        }
    }

    public void checkRemoteDirtyInventory(List<String> nodes, String invLoc) {
        FileInfo fileInfoObject = FileInfo.getInstance();
        List<String> nodesWithNonEmptyInventoryLocation = fileInfoObject.checkRemoteNodesEmptyDirs(nodes, invLoc);
        if (!nodesWithNonEmptyInventoryLocation.equals(null) && nodesWithNonEmptyInventoryLocation.size() > 0) {
            this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_LOC_REMOTE_DIRTY, new Object[]{nodesWithNonEmptyInventoryLocation}));
        }
    }

    public void checkRemoteWritableLocation(List<String> nodes) {
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (this.isSharedDir) {
            return;
        }
        if (!this.isWritableLocalNode) {
            return;
        }
        if (nodes != null && nodes.size() > 1) {
            for (String node : nodes) {
                if (MachineInfo.getInstance().isLocalHost(node)) continue;
                boolean fileExists = false;
                String dirToCheck = this.inventoryLoc;
                try {
                    while (!fileExists) {
                        fileExists = FileInfo.getInstance().doesRemoteDirExist(node, dirToCheck);
                        if (fileExists) continue;
                        if (dirToCheck.lastIndexOf(File.separatorChar) == 0) {
                            dirToCheck = File.separator;
                            continue;
                        }
                        dirToCheck = dirToCheck.substring(0, dirToCheck.lastIndexOf(File.separatorChar));
                    }
                    boolean canWrite = FileInfo.getInstance().isRemoteDirWriatble(node, dirToCheck);
                    if (canWrite) continue;
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.DIRECTORY_NOT_WRITABLE_ON_NODE, new Object[]{this.inventoryLoc, node}));
                }
                catch (Throwable t) {
                    this.errorMessages.add((StatusMessage)new ValidationStatusMessage(t));
                }
            }
        }
    }

    public void checkChangeGroupPermission(String invLoc, String user, String invGroup) {
        if (invLoc != null && invGroup != null && new File(invLoc).exists()) {
            boolean succeeded = true;
            try {
                int retCode = FileInfo.getInstance().changeGroup(invLoc, invGroup);
                if (retCode != 0) {
                    logger.log(Level.WARNING, "The inventory group change failed with code: " + retCode);
                    succeeded = false;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "The inventory group change failed.", e);
                succeeded = false;
            }
            if (!succeeded) {
                File invLocFile = new File(invLoc);
                String invLocOwner = "";
                try {
                    invLocOwner = Files.getOwner(invLocFile.toPath(), new LinkOption[0]).getName();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the owner of the inventory location: " + invLoc, e);
                }
                if (invLocOwner != null && !invLocOwner.isEmpty()) {
                    logger.log(Level.INFO, "User owner of the inventory location " + invLoc + ": " + invLocOwner);
                    invLocOwner = " (" + invLocOwner + ")";
                } else {
                    invLocOwner = "";
                }
                String invLocGroup = "";
                try {
                    invLocGroup = Files.getFileAttributeView(invLocFile.toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes().group().getName();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the group of the inventory location: " + invLoc, e);
                }
                if (invLocGroup != null && !invLocGroup.isEmpty()) {
                    logger.log(Level.INFO, "Group owner of the inventory location " + invLoc + ": " + invLocGroup);
                    invLocGroup = " (" + invLocGroup + ")";
                } else {
                    invLocGroup = "";
                }
                this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INV_USER_GROUP_MATCH_ERR, new Object[]{invLoc, user, invGroup, invLocOwner, invLocGroup}));
            }
        }
    }

    public void checkInventoryLocOwner(String invLoc, String user) {
        File invLocFile;
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (invLoc != null && !invLoc.isEmpty() && (invLocFile = new File(invLoc)).exists()) {
            logger.log(Level.INFO, "The inventory location directory already exists: " + invLoc);
            if (user != null && !user.isEmpty()) {
                logger.log(Level.INFO, "Current user: " + user);
                String invLocOwner = null;
                try {
                    invLocOwner = Files.getOwner(invLocFile.toPath(), new LinkOption[0]).getName();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the owner of the inventory location: " + invLoc, e);
                    return;
                }
                if (invLocOwner != null && !invLocOwner.isEmpty()) {
                    logger.log(Level.INFO, "User owner of the inventory location " + invLoc + ": " + user);
                    if (!invLocOwner.equals(user)) {
                        this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_WRONG_USER, new Object[]{invLoc, invLocOwner, user}));
                    }
                } else {
                    logger.log(Level.WARNING, "Could not determine the owner of the inventory location: " + invLoc);
                }
            } else {
                logger.log(Level.WARNING, "Could not determine the current user name.");
            }
        }
    }

    public void checkInventoryLocGroup(String invLoc, String group) {
        File invLocFile;
        if (!PlatformInfo.getInstance().isUnix()) {
            return;
        }
        if (invLoc != null && !invLoc.isEmpty() && (invLocFile = new File(invLoc)).exists()) {
            logger.log(Level.INFO, "The inventory location directory already exists: " + invLoc);
            if (group != null && !group.isEmpty()) {
                logger.log(Level.INFO, "Specified inventory group: " + group);
                String invLocGroup = null;
                try {
                    invLocGroup = Files.getFileAttributeView(invLocFile.toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes().group().getName();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get the group of the inventory location: " + invLoc, e);
                    return;
                }
                if (invLocGroup != null && !invLocGroup.isEmpty()) {
                    logger.log(Level.INFO, "User group of the inventory location " + invLoc + ": " + group);
                    if (!invLocGroup.equals(group)) {
                        this.errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_INVENTORY_WRONG_GROUP, new Object[]{invLoc, invLocGroup, group}));
                    }
                } else {
                    logger.log(Level.WARNING, "Could not determine the group of the inventory location: " + invLoc);
                }
            } else {
                logger.log(Level.WARNING, "Could not determine the specified inventory group.");
            }
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.errorMessages;
    }

    public boolean isWritableLocalNode() {
        return this.isWritableLocalNode;
    }

    public static StatusMessages<ValidationStatusMessage> validateRemoteInventoryLocations(ArrayList<String> remoteNodes, String localInvLoc) {
        boolean enableActionable = true;
        return InventoryValidator.validateRemoteInventoryLocations(remoteNodes, localInvLoc, enableActionable);
    }

    public static StatusMessages<ValidationStatusMessage> validateRemoteInventoryLocations(ArrayList<String> remoteNodes, String localInvLoc, boolean enableActionable) {
        StatusMessages messages = new StatusMessages();
        ArrayList<String> allNodes = new ArrayList<String>(remoteNodes);
        allNodes.add(MachineInfo.getInstance().getLocalMachineName());
        boolean isShared = false;
        try {
            if (FileSystemInfo.getInstance().isLocationOnCFS(localInvLoc, allNodes)) {
                isShared = true;
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INVENTORY_ON_SHARED_LOC, new Object[]{localInvLoc}));
            }
        }
        catch (InstallException e) {
            logger.info("Could not check if location " + localInvLoc + " was shared for nodes " + ((Object)allNodes).toString());
        }
        if (!isShared) {
            boolean isWindows = PlatformInfo.getInstance().isWindows();
            ArrayList<String> mismatchLoc = new ArrayList<String>();
            ArrayList<String> nonEmptyLoc = new ArrayList<String>();
            ArrayList<String> nonWritableLoc = new ArrayList<String>();
            FileInfo fileInfo = FileInfo.getInstance();
            for (String node : remoteNodes) {
                RemoteInventoryInfo rInvInfo = RemoteInventoryInfo.getInstance((String)node, (boolean)true);
                boolean checkLocationWritable = false;
                if (rInvInfo.isInventoryExists()) {
                    String rInvLoc = rInvInfo.getInventoryLocation();
                    if (rInvLoc != null && !rInvLoc.isEmpty()) {
                        logger.info("Node " + node + " inventory location is: " + rInvLoc);
                        boolean sameLoc = true;
                        if (isWindows) {
                            if (!localInvLoc.equalsIgnoreCase(rInvLoc)) {
                                sameLoc = false;
                            }
                        } else if (!localInvLoc.equals(rInvLoc)) {
                            sameLoc = false;
                        }
                        if (sameLoc) {
                            checkLocationWritable = true;
                        } else {
                            mismatchLoc.add(node);
                        }
                    }
                } else {
                    logger.info("Node " + node + " does not have an inventory.");
                    if (!fileInfo.isRemoteDirEmpty(node, localInvLoc)) {
                        nonEmptyLoc.add(node);
                    }
                    checkLocationWritable = true;
                }
                if (isWindows || !checkLocationWritable) continue;
                String rInvLocLasExistingParent = FileInfo.getInstance().getLastExistingRemoteParent(node, localInvLoc);
                if (FileInfo.getInstance().isRemoteDirWriatble(node, rInvLocLasExistingParent)) continue;
                nonWritableLoc.add(node);
            }
            if (!mismatchLoc.isEmpty()) {
                if (enableActionable) {
                    messages.add((StatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_REMOTE_INVENTORY_MISMATCH_LOCATION, mismatchLoc, new Object[]{((Object)mismatchLoc).toString(), localInvLoc}));
                } else {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.REMOTE_INVENTORY_MISMATCH_LOCATION, new Object[]{((Object)mismatchLoc).toString(), localInvLoc}));
                }
            }
            if (!nonEmptyLoc.isEmpty()) {
                if (enableActionable) {
                    messages.add((StatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_REMOTE_INVENTORY_NONEMPTY_LOCATION, nonEmptyLoc, new Object[]{localInvLoc, ((Object)nonEmptyLoc).toString()}));
                } else {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ACTIONABLE_REMOTE_INVENTORY_NONEMPTY_LOCATION, new Object[]{localInvLoc, ((Object)nonEmptyLoc).toString()}));
                }
            }
            if (!nonWritableLoc.isEmpty()) {
                if (enableActionable) {
                    messages.add((StatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_REMOTE_INVENTORY_NONWRITABLE_LOCATION, nonWritableLoc, new Object[]{localInvLoc, ((Object)nonWritableLoc).toString()}));
                } else {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ACTIONABLE_REMOTE_INVENTORY_NONWRITABLE_LOCATION, new Object[]{localInvLoc, ((Object)nonWritableLoc).toString()}));
                }
            }
        }
        return messages;
    }

    public static void validateRemoteNodesHomeNameAvailable(String oracleHome, List<String> remoteNodes) throws ValidationException {
        String homeName = null;
        oracle.install.driver.oui.InventoryInfo invInfo = oracle.install.driver.oui.InventoryInfo.getInstance();
        if (invInfo.isInventoryExist()) {
            homeName = invInfo.getNameForLocation(oracleHome);
        }
        if (homeName != null) {
            logger.log(Level.INFO, "Home name for oracle home (" + oracleHome + "): " + homeName);
            boolean enableActionable = false;
            InventoryValidator.validateRemoteNodesHomeNameAvailable(remoteNodes, homeName, enableActionable);
        }
    }

    public static StatusMessages<ValidationStatusMessage> validateRemoteNodesHomeNameAvailable(List<String> remoteNodes, String homeName, boolean enableActionable) throws ValidationException {
        StatusMessages messages = new StatusMessages();
        if (homeName != null && remoteNodes != null && !remoteNodes.isEmpty()) {
            ArrayList<String> nodesHomeNameAlreadyUsed = new ArrayList<String>();
            block0: for (String remoteNode : remoteNodes) {
                List homeNamesUsed;
                RemoteInventoryInfo rii = RemoteInventoryInfo.getInstance((String)remoteNode, (boolean)true);
                if (rii == null || (homeNamesUsed = rii.getHomeNames()).isEmpty()) continue;
                for (String homeNameUsed : homeNamesUsed) {
                    if (!homeNameUsed.equalsIgnoreCase(homeName)) continue;
                    nodesHomeNameAlreadyUsed.add(remoteNode);
                    continue block0;
                }
            }
            if (!nodesHomeNameAlreadyUsed.isEmpty()) {
                if (enableActionable) {
                    messages.add((StatusMessage)new CRSNodeRemoveActionableValidationStatusMessage(CommonErrorCode.ACTIONABLE_HOME_NAME_ALREADY_USED_IN_REMOTE_INVENTORY, nodesHomeNameAlreadyUsed, new Object[]{homeName, ((Object)nodesHomeNameAlreadyUsed).toString()}));
                } else {
                    throw new ValidationException((ErrorCode)CommonErrorCode.HOME_NAME_ALREADY_USED_IN_REMOTE_INVENTORY, new Object[]{homeName, ((Object)nodesHomeNameAlreadyUsed).toString()});
                }
            }
        }
        return messages;
    }

    public static StatusMessages<ValidationStatusMessage> validateHomeNameAcrossNodes(String homeName, List<String> nodes, boolean enableActionable) throws ValidationException {
        StatusMessages messages = new StatusMessages();
        oracle.install.driver.oui.InventoryInfo invInfo = oracle.install.driver.oui.InventoryInfo.getInstance();
        if (invInfo.isHomeWithNameExist(homeName)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_NAME_ALREADY_EXISTS, new Object[]{homeName});
        }
        ArrayList<String> remoteNodes = new ArrayList<String>();
        if (nodes != null && !nodes.isEmpty()) {
            for (String node : nodes) {
                if (MachineInfo.getInstance().isLocalHost(node)) continue;
                remoteNodes.add(node);
            }
        }
        if (!remoteNodes.isEmpty()) {
            messages.addAll(InventoryValidator.validateRemoteNodesHomeNameAvailable(remoteNodes, homeName, enableActionable));
        }
        return messages;
    }
}

