/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.OracleNodeScalerBean;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.WizardValidationHelper;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.sysman.oii.oiic.OiicGlobalVarsReader;
import oracle.sysman.oii.oiis.OiisVariable;

public class NodeScalerDetailsValidator
implements CompositeValidator {
    private StatusMessages<ValidationStatusMessage> messages = new StatusMessages();
    private static final Logger logger = Logger.getLogger(NodeScalerDetailsValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        String globalvarxml;
        File globalvarxml_file;
        this.messages.clear();
        OracleNodeScalerBean nodeScalerBean = (OracleNodeScalerBean)((Object)flowContext.getBeanLike(OracleNodeScalerBean.class));
        String[] publicHostNames = nodeScalerBean.getClusterNewNodes();
        String oracleHome = nodeScalerBean.getOracleHome();
        String oracleBase = OFAWrapper.getInstance().getBaseForLocation(oracleHome);
        if (publicHostNames == null || publicHostNames.length == 0) {
            this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ADD_NODE_CLUSTER_NEW_NODES_NOT_PASSED, new Object[0]));
        }
        if (!CRSInfo.getInstance().isCRSRunningOnLocalNode()) {
            this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ADD_NODE_CRS_NOT_RUNNING_ON_LOCAL_NODE, new Object[0]));
        }
        if ((globalvarxml_file = new File(globalvarxml = oracleHome + File.separator + this.getGlobalVarXmlPath())).isFile() && globalvarxml_file.exists()) {
            try {
                String currentUser;
                Map globalvars = OiicGlobalVarsReader.readGlobalVariables((String)globalvarxml);
                String homeUserName = (String)((OiisVariable)globalvars.get("oracle_install_user")).getValue();
                if (homeUserName != null && homeUserName.length() > 0 && !(currentUser = System.getProperty("user.name")).equalsIgnoreCase(homeUserName)) {
                    this.messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.ADD_NODE_USER_NOT_SAME_AS_INSTALLING_USER, new Object[]{currentUser}));
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Error while reading the global var's", e);
            }
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return this.messages;
    }

    public String getGlobalVarXmlPath() {
        return "";
    }

    public StatusMessages<ValidationStatusMessage> validateOracleBase(String oracleBase, String[] newNodes) {
        StatusMessages messages = new StatusMessages();
        messages.addAll(WizardValidationHelper.getInstance().validateRemoteWritablePermission(oracleBase, newNodes));
        return messages;
    }

    public StatusMessages<ValidationStatusMessage> performGenericChecksForAddnode(String[] nodelist, String oracleHome, String oracleBase, boolean isShared) {
        StatusMessages messages = new StatusMessages();
        if (messages.isEmpty() && !isShared) {
            messages.addAll(WizardValidationHelper.getInstance().validateRemoteWritablePermission(oracleHome, nodelist));
        }
        if (messages.isEmpty()) {
            messages.addAll(this.validateOracleBase(oracleBase, nodelist));
        }
        return messages;
    }
}

